/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.attach.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.attach.bo.AttachBO;
import com.peak.prd.common.attach.bo.AttachQueryBO;
import com.peak.prd.common.attach.dao.IAttachPlusDao;
import com.peak.prd.common.attach.model.Attach;
import com.peak.prd.common.attach.service.IAttachPlusService;
import com.peak.prd.common.attach.vo.AttachDetailVO;
import com.peak.prd.common.attach.vo.AttachQuery;
import com.peak.prd.common.attach.vo.AttachVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AttachPlusService
extends PrdBaseService<Attach, Long, AttachQuery>
implements IAttachPlusService {
    @Resource
    private IAttachPlusDao attachPlusDao;

    public IEntityDao<Attach, Long, AttachQuery> getEntityDao() {
        return this.attachPlusDao;
    }

    @Override
    public Long insert(@NotNull Long userId, @NotNull AttachBO attachBO) {
        Attach attach = (Attach)ConvertUtil.convert((Object)attachBO, Attach.class);
        Long attachId = IdUtil.getSequence((String)"COMMON_ATTACH");
        attach.setAttachId(attachId);
        attach.setDeleted(0);
        attach.setCreatorId(userId);
        attach.setCreatedate(new Date());
        this.attachPlusDao.insertSelective((BaseEntity)attach);
        return attachId;
    }

    @Override
    public Integer update(@NotNull AttachBO attachBO) {
        Attach attach = (Attach)ConvertUtil.convert((Object)attachBO, Attach.class);
        return this.attachPlusDao.updateSelective(attach);
    }

    @Override
    public Integer delete(@NotNull Long attachId) {
        Attach attach = new Attach(attachId);
        attach.setDeleted(1);
        attach.setDeletedate(new Date());
        return this.attachPlusDao.updateSelective(attach);
    }

    @Override
    public Paging<AttachVO> getMngVOList(@NotNull AttachQueryBO attachQueryBO) {
        AttachQuery query = new AttachQuery(attachQueryBO.getPageNumber(), attachQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)attachQueryBO), (Object)query);
        query.setDeleted(0);
        query.getPage().setSortColumns("cath.CREATEDATE DESC");
        Paging attachVOPaging = this.attachPlusDao.findPaging(query, AttachVO.class);
        return attachVOPaging;
    }

    @Override
    public AttachDetailVO getInfo(@NotNull Long attachId) {
        Attach attach = (Attach)this.getById(attachId);
        if (attach == null) {
            return null;
        }
        return (AttachDetailVO)ConvertUtil.convert((Object)attach, AttachDetailVO.class);
    }

    @Override
    public List<AttachVO> getVOList(@NotNull AttachQueryBO attachQueryBO) {
        AttachQuery query = new AttachQuery(attachQueryBO.getPageNumber(), attachQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)attachQueryBO), (Object)query);
        query.setDeleted(0);
        query.getPage().setSortColumns("cath.CREATEDATE DESC");
        List attachList = this.attachPlusDao.findList(query);
        return ConvertUtil.convert((List)attachList, AttachVO.class);
    }

    @Override
    public List<AttachVO> getVOList(@NotNull Long businessId, @NotNull Integer businesstype, String name, Integer pageNumber, Integer pageSize) {
        AttachQuery query = new AttachQuery(pageNumber, pageSize);
        query.setBusinessId(businessId);
        query.setBusinesstype(businesstype);
        query.setName(name);
        query.setDeleted(0);
        query.getPage().setSortColumns("cath.CREATEDATE DESC");
        List attachList = this.attachPlusDao.findList(query);
        return ConvertUtil.convert((List)attachList, AttachVO.class);
    }

    @Override
    public List<AttachDetailVO> getDetailVOList(@NotNull Long businessId, @NotNull Integer businesstype) {
        AttachQuery query = new AttachQuery(1, 1000);
        query.setBusinessId(businessId);
        query.setBusinesstype(businesstype);
        query.setDeleted(0);
        query.getPage().setSortColumns("cath.CREATEDATE DESC");
        List attachList = this.attachPlusDao.findList(query);
        return ConvertUtil.convert((List)attachList, AttachDetailVO.class);
    }

    @Override
    public Integer updateName(@NotNull Long attachId, @NotBlank String name) {
        Attach attach = new Attach();
        attach.setAttachId(attachId);
        attach.setName(name);
        return this.attachPlusDao.updateSelective(attach);
    }
}

