/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.busiaudi.dao.imple;

import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.base.dao.imple.PrdBaseDao;
import com.peak.prd.common.busiaudi.dao.IBusiaudiPlusDao;
import com.peak.prd.common.busiaudi.model.Busiaudi;
import com.peak.prd.common.busiaudi.vo.BusiaudiQuery;
import com.peak.prd.inc.IncUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class BusiaudiPlusDao
extends PrdBaseDao<Busiaudi, Long, BusiaudiQuery>
implements IBusiaudiPlusDao {
    @Override
    public int logicDeleteByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        if (businessId == null || businesstype == null) {
            return 0;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("now", new Date());
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".logicDeleteByBusinessIdAndBusinesstype", params);
    }

    @Override
    public int logicDeleteByIds(List<Long> busiaudiIdList) {
        if (ListUtil.isNullorEmpty(busiaudiIdList)) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("busiaudiIdList", busiaudiIdList);
        params.put("now", new Date());
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".logicDeleteByIds", params);
    }

    @Override
    public int phiDeleteByIds(List<Long> busiaudiIdList) {
        if (ListUtil.isNullorEmpty(busiaudiIdList)) {
            return 0;
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("busiaudiIdList", busiaudiIdList);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".phiDeleteByIds", params);
    }

    @Override
    public int updateRefreshData(Long businessId, Integer businesstype, Date lastrefreshenddate, Long lastrefreshspentms, Date nextrefreshdate) {
        if (businessId == null || businesstype == null) {
            return 0;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("lastrefreshenddate", lastrefreshenddate);
        params.put("lastrefreshspentms", lastrefreshspentms);
        params.put("nextrefreshdate", nextrefreshdate);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".updateRefreshData", params);
    }

    @Override
    public List<Long> getUserIdsFromUser(Long businessId, Integer businesstype, String tableName, String columnName) {
        if (businessId == null || businesstype == null || tableName == null || columnName == null) {
            return new ArrayList<Long>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("tableName", tableName);
        params.put("columnName", columnName);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserIdsFromUser", params);
    }

    @Override
    public List<Long> getUserIdsFromOneOrgOrDomainIncludeSub(Long orgId, Long businessId, String tableName, String columnName) {
        if (orgId == null || businessId == null || StringUtil.isNullorEmptyStr((String)tableName) || StringUtil.isNullorEmptyStr((String)columnName)) {
            return new ArrayList<Long>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        IncUser incUser = new IncUser();
        incUser.setOrgId(orgId);
        params.put("incUser", incUser);
        params.put("businessId", businessId);
        params.put("tableName", tableName);
        params.put("columnName", columnName);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserIdsFromOneOrgOrDomainIncludeSub", params);
    }

    @Override
    public List<Long> getUserIdsFromDomainIncludeSub(Long businessId, Integer businesstype, String tableName, String columnName) {
        if (businessId == null || businesstype == null || tableName == null || columnName == null) {
            return new ArrayList<Long>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("tableName", tableName);
        params.put("columnName", columnName);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserIdsFromDomainIncludeSub", params);
    }

    @Override
    public List<Long> getUserIdsFromDomainNotIncludeSub(Long businessId, Integer businesstype, String tableName, String columnName) {
        if (businessId == null || businesstype == null || tableName == null || columnName == null) {
            return new ArrayList<Long>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("tableName", tableName);
        params.put("columnName", columnName);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserIdsFromDomainNotIncludeSub", params);
    }

    @Override
    public Integer replaceBusiness(Long businessId, Integer businesstype, Long newBusinessId, Integer newBusinesstype) {
        if (businessId == null || businesstype == null || newBusinessId == null || newBusinesstype == null) {
            return 0;
        }
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        params.put("newBusinessId", newBusinessId);
        params.put("newBusinesstype", newBusinesstype);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".replaceBusiness", params);
    }
}

