/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.busiaudi.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.domain.model.Domain;
import com.peak.prd.appsecurity.domain.service.IDomainPlusService;
import com.peak.prd.appsecurity.group.service.ITgroupPlusService;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.busiaudi.bo.BusiaudiBO;
import com.peak.prd.common.busiaudi.bo.BusiaudiScopeBO;
import com.peak.prd.common.busiaudi.dao.IBusiaudiPlusDao;
import com.peak.prd.common.busiaudi.model.Busiaudi;
import com.peak.prd.common.busiaudi.service.IBusiaudiPlusService;
import com.peak.prd.common.busiaudi.vo.BusiaudiQuery;
import com.peak.prd.common.busiaudi.vo.BusiaudiScopeMngVO;
import com.peak.prd.enums.BusiaudiScopetypeEnum;
import com.peak.prd.enums.SysInitData;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class BusiaudiPlusService
extends PrdBaseService<Busiaudi, Long, BusiaudiQuery>
implements IBusiaudiPlusService {
    @Resource
    private ITgroupPlusService tgroupPlusService;
    @Resource
    @Lazy
    private IBusiaudiPlusService self;
    @Resource
    private IOrgPlusService orgPlusService;
    @Resource
    private IDomainPlusService domainPlusService;
    private IBusiaudiPlusDao busiaudiPlusDao;

    public void setBusiaudiPlusDao(IBusiaudiPlusDao dao) {
        this.busiaudiPlusDao = dao;
    }

    public IBusiaudiPlusDao getBusiaudiPlusDao() {
        return this.busiaudiPlusDao;
    }

    public IEntityDao<Busiaudi, Long, BusiaudiQuery> getEntityDao() {
        return this.busiaudiPlusDao;
    }

    @Override
    @ClearCache(values={"#businessId", "#businesstype"})
    public void test(Long businessId, Integer businesstype) {
    }

    @Override
    public List<BusiaudiScopeMngVO> getMngInfo(Long businessId, Integer businesstype) {
        return this.getMngInfo(businessId, businesstype, null);
    }

    @Override
    public List<BusiaudiScopeMngVO> getMngInfo(Long businessId, Integer businesstype, Integer scopetype) {
        BusiaudiQuery busiaudiQuery = new BusiaudiQuery();
        busiaudiQuery.setBusinessId(businessId);
        busiaudiQuery.setBusinesstype(businesstype);
        if (scopetype != null) {
            busiaudiQuery.setScopetype(scopetype.longValue());
        }
        busiaudiQuery.setDeleted(0);
        List busiaudiList = this.getBusiaudiPlusDao().findAll(busiaudiQuery);
        return this.toMngVOList(busiaudiList);
    }

    private List<BusiaudiScopeMngVO> toMngVOList(List<Busiaudi> busiaudiList) {
        List<BusiaudiScopeMngVO> busiaudiScopeMngVOList = new ArrayList<BusiaudiScopeMngVO>();
        if (ListUtil.isNullorEmpty(busiaudiList)) {
            return busiaudiScopeMngVOList;
        }
        busiaudiScopeMngVOList = busiaudiList.stream().map(busiaudi -> this.toMngVO((Busiaudi)busiaudi)).collect(Collectors.toList());
        busiaudiScopeMngVOList.sort(new Comparator<BusiaudiScopeMngVO>(){

            @Override
            public int compare(BusiaudiScopeMngVO o1, BusiaudiScopeMngVO o2) {
                return o1.getScopetype().intValue() - o2.getScopetype().intValue();
            }
        });
        return busiaudiScopeMngVOList;
    }

    private BusiaudiScopeMngVO toMngVO(Busiaudi busiaudi) {
        if (busiaudi == null) {
            return null;
        }
        BusiaudiScopeMngVO busiaudiScopeMngVO = (BusiaudiScopeMngVO)ConvertUtil.convert((Object)busiaudi, BusiaudiScopeMngVO.class);
        busiaudiScopeMngVO.setScopeName(busiaudi.getScopename());
        if (!StringUtil.isNullorEmptyStr((String)busiaudiScopeMngVO.getScopeName())) {
            return busiaudiScopeMngVO;
        }
        if (busiaudiScopeMngVO.getScopetype().intValue() == BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_USER.getValue().intValue()) {
            busiaudiScopeMngVO.setScopeName(UserCoreUtil.getUserVO((Long)busiaudiScopeMngVO.getScopeId()).getName());
        } else if (busiaudiScopeMngVO.getScopetype().intValue() == BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue().intValue() || busiaudiScopeMngVO.getScopetype().intValue() == BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_NOT_INCLUDESUB.getValue().intValue()) {
            busiaudiScopeMngVO.setScopeName(OrgUtil.getOrgVO((Long)busiaudiScopeMngVO.getScopeId()).getOrgname());
        }
        return busiaudiScopeMngVO;
    }

    @Override
    @ClearCache(values={"#busiaudiBO.businessId", "#busiaudiBO.businesstype"})
    public int txInsert(BusiaudiBO busiaudiBO, Long userId) {
        List<Busiaudi> busiaudiList = this.getListByBusinessIdAndBusinesstype(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype());
        int insertNum = this.insertNotExist(busiaudiBO, busiaudiList, userId);
        return insertNum;
    }

    @Override
    public int insert(BusiaudiBO busiaudiBO, Long userId) throws Exception {
        int insertNum = this.txInsert(busiaudiBO, userId);
        this.sendBusiaudiChangeMesssage(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype(), userId, insertNum);
        return insertNum;
    }

    @Override
    @ClearCache(values={"#busiaudiBO.businessId", "#busiaudiBO.businesstype"})
    public int txUpdate(BusiaudiBO busiaudiBO, Long userId) {
        List<Busiaudi> busiaudiList = this.getListByBusinessIdAndBusinesstype(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype());
        int updateNum = this.insertNotExistAndUpdateExist(busiaudiBO, busiaudiList, userId) + this.deleteNotUsed(busiaudiBO, busiaudiList);
        return updateNum;
    }

    @Override
    @ClearCache(values={"#businessId", "#businesstype"})
    public int txDelete(Long businessId, Integer businesstype) {
        List<Busiaudi> busiaudiList = this.getListByBusinessIdAndBusinesstype(businessId, businesstype);
        return this.deleteNotUsed(new ArrayList<BusiaudiScopeBO>(), busiaudiList);
    }

    @Override
    @ClearCache(values={"#busiaudiBO.businessId", "#busiaudiBO.businesstype"})
    public int txUpdate(BusiaudiBO busiaudiBO, Long userId, Boolean updateByType) {
        List<Busiaudi> busiaudiList = this.getListByBusinessIdAndBusinesstype(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype());
        int updateNum = 0;
        if (updateByType != null && updateByType.booleanValue()) {
            ArrayList<Long> existTypeList = new ArrayList<Long>();
            if (!ListUtil.isNullorEmpty(busiaudiBO.getScopeList())) {
                for (BusiaudiScopeBO busiaudiScopeBO : busiaudiBO.getScopeList()) {
                    existTypeList.add(busiaudiScopeBO.getScopetype());
                }
            }
            ArrayList<Busiaudi> deleteList = new ArrayList<Busiaudi>();
            if (!ListUtil.isNullorEmpty(busiaudiList)) {
                for (Busiaudi busiaudi : busiaudiList) {
                    if (!existTypeList.contains(busiaudi.getScopetype())) continue;
                    deleteList.add(busiaudi);
                }
            }
            updateNum = this.insertNotExist(busiaudiBO, busiaudiList, userId) + this.deleteNotUsed(busiaudiBO, deleteList);
        } else {
            updateNum = this.insertNotExist(busiaudiBO, busiaudiList, userId) + this.deleteNotUsed(busiaudiBO, busiaudiList);
        }
        return updateNum;
    }

    @Override
    public int update(BusiaudiBO busiaudiBO, Long userId, Boolean updateByType) throws Exception {
        int updateNum = this.txUpdate(busiaudiBO, userId, updateByType);
        this.sendBusiaudiChangeMesssage(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype(), userId, updateNum);
        return updateNum;
    }

    @Override
    public int delete(Long businessId, Integer businesstype, Long userId) throws Exception {
        int deleteNum = this.txDelete(businessId, businesstype);
        this.sendBusiaudiChangeMesssage(businessId, businesstype, userId, deleteNum);
        return deleteNum;
    }

    @Override
    public int update(BusiaudiBO busiaudiBO, Long userId) throws Exception {
        if (busiaudiBO.getScopeList() == null) {
            return 0;
        }
        int updateNum = this.txUpdate(busiaudiBO, userId);
        this.sendBusiaudiChangeMesssage(busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype(), userId, updateNum);
        return updateNum;
    }

    private int insertNotExist(BusiaudiBO busiaudiBO, List<Busiaudi> busiaudiList, Long creatorId) {
        ArrayList<Busiaudi> insertList = new ArrayList<Busiaudi>();
        Date now = new Date();
        for (BusiaudiScopeBO busiaudiScopeBO : busiaudiBO.getScopeList()) {
            boolean exists = false;
            for (Busiaudi busiaudi : busiaudiList) {
                if (!busiaudi.getScopeId().equals(busiaudiScopeBO.getScopeId()) || !busiaudi.getScopetype().equals(busiaudiScopeBO.getScopetype())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            insertList.add(this.newBusiaudi(busiaudiScopeBO, busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype(), creatorId, now));
        }
        ArrayList<Busiaudi> distinctInsertList = new ArrayList<Busiaudi>();
        Map<Long, List<Busiaudi>> insertMap = insertList.stream().collect(Collectors.groupingBy(Busiaudi::getScopetype));
        for (Map.Entry<Long, List<Busiaudi>> entry : insertMap.entrySet()) {
            List scopeIdList;
            List<Busiaudi> value = entry.getValue();
            List distinctScopeIdList = scopeIdList = IdUtil.getIds(value, Busiaudi::getScopeId);
            for (Long scopeId : distinctScopeIdList) {
                Busiaudi busiaudi = new Busiaudi();
                busiaudi.setBusiaudiId(IdUtil.getSequence((String)"COMMON_BUSIAUDI"));
                busiaudi.setBusinessId(busiaudiBO.getBusinessId());
                busiaudi.setBusinesstype(busiaudiBO.getBusinesstype());
                busiaudi.setScopeId(scopeId);
                busiaudi.setScopetype(entry.getKey());
                busiaudi.setScopename(entry.getValue().get(0).getScopename());
                busiaudi.setCreatorId(creatorId);
                busiaudi.setCreatedate(now);
                busiaudi.setDeleted(0);
                distinctInsertList.add(busiaudi);
            }
        }
        return this.getBusiaudiPlusDao().insertBatch(distinctInsertList);
    }

    private int insertNotExistAndUpdateExist(BusiaudiBO busiaudiBO, List<Busiaudi> busiaudiList, Long creatorId) {
        ArrayList<Busiaudi> insertList = new ArrayList<Busiaudi>();
        Date now = new Date();
        for (BusiaudiScopeBO busiaudiScopeBO : busiaudiBO.getScopeList()) {
            boolean exists = false;
            Busiaudi busiaudiExist = null;
            for (Busiaudi busiaudi : busiaudiList) {
                if (!busiaudi.getScopeId().equals(busiaudiScopeBO.getScopeId()) || !busiaudi.getScopetype().equals(busiaudiScopeBO.getScopetype())) continue;
                busiaudiExist = busiaudi;
                exists = true;
                break;
            }
            if (!exists) {
                insertList.add(this.newBusiaudi(busiaudiScopeBO, busiaudiBO.getBusinessId(), busiaudiBO.getBusinesstype(), creatorId, now));
                continue;
            }
            if (StringUtil.isNullorEmptyStr((String)busiaudiScopeBO.getScopeName())) continue;
            Busiaudi busiaudi = new Busiaudi();
            busiaudi.setBusiaudiId(busiaudiExist.getBusiaudiId());
            busiaudi.setScopename(busiaudiScopeBO.getScopeName());
            this.getBusiaudiPlusDao().updateSelective(busiaudi);
        }
        return this.getBusiaudiPlusDao().insertBatch(insertList);
    }

    private int deleteNotUsed(BusiaudiBO busiaudiBO, List<Busiaudi> busiaudiList) {
        return this.deleteNotUsed(busiaudiBO.getScopeList(), busiaudiList);
    }

    private int deleteNotUsed(List<BusiaudiScopeBO> scopeList, List<Busiaudi> busiaudiList) {
        ArrayList<Busiaudi> deleteList = new ArrayList<Busiaudi>();
        for (Busiaudi busiaudi2 : busiaudiList) {
            boolean exists = false;
            for (BusiaudiScopeBO busiaudiScopeBO : scopeList) {
                if (!busiaudi2.getScopeId().equals(busiaudiScopeBO.getScopeId()) || !busiaudi2.getScopetype().equals(busiaudiScopeBO.getScopetype())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            deleteList.add(busiaudi2);
        }
        return this.getBusiaudiPlusDao().phiDeleteByIds(deleteList.stream().map(busiaudi -> busiaudi.getBusiaudiId()).collect(Collectors.toList()));
    }

    private void sendBusiaudiChangeMesssage(Long businessId, Integer businesstype, Long userId, int updateNum) throws Exception {
        TimeUnit.MILLISECONDS.sleep(100L);
        if (updateNum > 0) {
            this.sendBusiaudiChangeMesssage(businessId, businesstype, userId);
        }
    }

    private void sendBusiaudiChangeMesssage(Long businessId, Integer businesstype, Long userId) {
        JSONObject jObj = new JSONObject();
        jObj.put("businessId", (Object)businessId);
        jObj.put("businesstype", (Object)businesstype);
        jObj.put("userId", (Object)(userId == null ? SysInitData.ADMIN_ID.getValue() : userId.longValue()));
        MessageQHelper.send((String)"busiaudi", (Long)businessId, (String)"change", (Object)jObj);
    }

    @Override
    public void sendBusiaudiChangeMesssage(Long businessId, Integer businesstype) {
        this.sendBusiaudiChangeMesssage(businessId, businesstype, null);
    }

    @Override
    public boolean isInScope(Long userId, Long businessId, Integer businesstype) {
        List<Busiaudi> busiaudiList = this.findListByBusinessIdAndBusinesstype(businessId, businesstype);
        if (ListUtil.isNullorEmpty(busiaudiList)) {
            return false;
        }
        List userOrgIdList = UserCoreUtil.getAllDomainIdsAndFullOrgIds((Long)userId);
        for (Busiaudi busiaudi : busiaudiList) {
            if (!(busiaudi.getScopetype().intValue() == BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_USER.getValue().intValue() ? busiaudi.getScopeId().longValue() == userId.longValue() : busiaudi.getScopetype().intValue() == BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue().intValue() && !ListUtil.isNullorEmpty((List)userOrgIdList) && userOrgIdList.contains(busiaudi.getScopeId()))) continue;
            return true;
        }
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        for (Busiaudi busiaudi : busiaudiList) {
            if (busiaudi.getScopetype().intValue() != BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_GROUP.getValue().intValue()) continue;
            groupIdList.add(busiaudi.getScopeId());
        }
        return !ListUtil.isNullorEmpty(groupIdList) && this.tgroupPlusService.isInGroup(userId, groupIdList);
    }

    @Override
    public Integer isInScopeReturnInteger(Long userId, Long businessId, Integer businesstype) {
        return this.self.isInScope(userId, businessId, businesstype) ? 1 : 0;
    }

    @Override
    public String getUserIds(Long businessId, Integer businesstype, String separator) {
        if (separator == null) {
            separator = ",";
        }
        StringBuffer sbf = new StringBuffer();
        Integer pageNumber = 1;
        Integer pageSize = 5000;
        for (int i = 0; i < 500; ++i) {
            BusiaudiQuery busiaudiQuery = new BusiaudiQuery(pageNumber, pageSize);
            busiaudiQuery.setBusinessId(businessId);
            busiaudiQuery.setBusinesstype(businesstype);
            busiaudiQuery.setDeleted(0);
            List userIdList = this.getBusiaudiPlusDao().findList(busiaudiQuery, "getDistinctUserIdList", Long.class);
            if (ListUtil.isNullorEmpty((List)userIdList)) break;
            if (pageNumber > 1) {
                sbf.append(separator);
            }
            sbf.append(StringUtils.join((Iterable)userIdList, (String)separator));
            if (userIdList.size() < pageSize) break;
        }
        return sbf.toString();
    }

    @Override
    public String getOrgIds(Long businessId, Integer businesstype, String separator, Boolean includeSub) {
        if (separator == null) {
            separator = ",";
        }
        BusiaudiQuery busiaudiQuery = new BusiaudiQuery(1, 1000);
        busiaudiQuery.setBusinessId(businessId);
        busiaudiQuery.setBusinesstype(businesstype);
        ArrayList<Long> scopetypeList = new ArrayList<Long>();
        if (includeSub == null) {
            scopetypeList.add(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue().longValue());
            scopetypeList.add(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_NOT_INCLUDESUB.getValue().longValue());
        } else if (includeSub.booleanValue()) {
            scopetypeList.add(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue().longValue());
        } else {
            scopetypeList.add(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_NOT_INCLUDESUB.getValue().longValue());
        }
        busiaudiQuery.setScopetypeList(scopetypeList);
        busiaudiQuery.setDeleted(0);
        List busiaudiList = this.getBusiaudiPlusDao().findList(busiaudiQuery);
        if (ListUtil.isNullorEmpty((List)busiaudiList)) {
            return "";
        }
        return StringUtils.join((Iterable)busiaudiList.stream().map(Busiaudi::getScopeId).collect(Collectors.toList()), (String)separator);
    }

    @Override
    public int logicDeleteByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) throws Exception {
        int deleteNum = this.getBusiaudiPlusDao().logicDeleteByBusinessIdAndBusinesstype(businessId, businesstype);
        this.sendBusiaudiChangeMesssage(businessId, businesstype, null, deleteNum);
        return deleteNum;
    }

    @Override
    public List<Busiaudi> getListByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        BusiaudiQuery busiaudiQuery = new BusiaudiQuery(1, 1000);
        busiaudiQuery.setBusinessId(businessId);
        busiaudiQuery.setBusinesstype(businesstype);
        busiaudiQuery.setDeleted(0);
        List busiaudiList = this.getBusiaudiPlusDao().findList(busiaudiQuery);
        if (ListUtil.isNullorEmpty((List)busiaudiList)) {
            return new ArrayList<Busiaudi>();
        }
        return busiaudiList;
    }

    @Override
    @Cacheable
    public List<Busiaudi> findListByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        return this.getListByBusinessIdAndBusinesstype(businessId, businesstype);
    }

    @Override
    public List<Busiaudi> getList(Long businessId, Integer businesstype, Long scopetype) {
        BusiaudiQuery busiaudiQuery = new BusiaudiQuery(1, 1000);
        busiaudiQuery.setBusinessId(businessId);
        busiaudiQuery.setBusinesstype(businesstype);
        busiaudiQuery.setScopetype(scopetype);
        busiaudiQuery.setDeleted(0);
        List busiaudiList = this.getBusiaudiPlusDao().findList(busiaudiQuery);
        if (ListUtil.isNullorEmpty((List)busiaudiList)) {
            return new ArrayList<Busiaudi>();
        }
        return busiaudiList;
    }

    @Override
    @Cacheable
    public List<Busiaudi> findList(Long businessId, Integer businesstype, Integer scopetype) {
        return this.getList(businessId, businesstype, (long)scopetype);
    }

    @Override
    public List<Busiaudi> getList(Long businessId, Integer businesstype, Long scopetype, Integer deleted, Integer pageNumber, Integer pageSize) {
        if (pageNumber == null) {
            pageNumber = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        BusiaudiQuery busiaudiQuery = new BusiaudiQuery(pageNumber, pageSize);
        busiaudiQuery.setBusinessId(businessId);
        busiaudiQuery.setBusinesstype(businesstype);
        busiaudiQuery.setScopetype(scopetype);
        busiaudiQuery.setDeleted(deleted);
        List busiaudiList = this.getBusiaudiPlusDao().findList(busiaudiQuery);
        if (ListUtil.isNullorEmpty((List)busiaudiList)) {
            return new ArrayList<Busiaudi>();
        }
        return busiaudiList;
    }

    @Override
    public int updateRefreshData(Long businessId, Integer businesstype, Date lastrefreshenddate, Long lastrefreshspentms, Date nextrefreshdate) {
        return this.getBusiaudiPlusDao().updateRefreshData(businessId, businesstype, lastrefreshenddate, lastrefreshspentms, nextrefreshdate);
    }

    @Override
    public List<Long> getUserIdsFromUser(Long businessId, Integer businesstype, String tableName, String columnName) {
        return this.getBusiaudiPlusDao().getUserIdsFromUser(businessId, businesstype, tableName, columnName);
    }

    @Override
    public List<Long> getUserIdsFromOneOrgOrDomainIncludeSub(Long orgId, Long businessId, String tableName, String columnName) {
        return this.getBusiaudiPlusDao().getUserIdsFromOneOrgOrDomainIncludeSub(orgId, businessId, tableName, columnName);
    }

    @Override
    public List<Long> getUserIdsFromDomainIncludeSub(Long businessId, Integer businesstype, String tableName, String columnName) {
        return this.getBusiaudiPlusDao().getUserIdsFromDomainIncludeSub(businessId, businesstype, tableName, columnName);
    }

    @Override
    public List<Long> getUserIdsFromDomainNotIncludeSub(Long businessId, Integer businesstype, String tableName, String columnName) {
        return this.getBusiaudiPlusDao().getUserIdsFromDomainNotIncludeSub(businessId, businesstype, tableName, columnName);
    }

    @Override
    public Integer copy(Long businessId, Integer businesstype, Long copyBusinessId, Long creatorId) {
        List<Busiaudi> busiaudiList = this.getListByBusinessIdAndBusinesstype(businessId, businesstype);
        if (ListUtil.isNullorEmpty(busiaudiList)) {
            return 0;
        }
        List insertList = ConvertUtil.convert(busiaudiList, Busiaudi.class);
        Date now = new Date();
        for (Busiaudi busiaudi : insertList) {
            busiaudi.setBusiaudiId(IdUtil.getSequence((String)"COMMON_BUSIAUDI"));
            busiaudi.setBusinessId(copyBusinessId);
            if (creatorId != null) {
                busiaudi.setCreatorId(creatorId);
            }
            busiaudi.setCreatedate(now);
            busiaudi.setLastrefreshenddate(null);
            busiaudi.setLastrefreshspentms(null);
            busiaudi.setNextrefreshdate(null);
        }
        return this.getBusiaudiPlusDao().insertBatch(insertList);
    }

    private Busiaudi newBusiaudi(BusiaudiScopeBO busiaudiScopeBO, Long businessId, Integer businesstype, Long userId, Date createdate) {
        Busiaudi busiaudi = (Busiaudi)ConvertUtil.convert((Object)busiaudiScopeBO, Busiaudi.class);
        busiaudi.setBusiaudiId(IdUtil.getSequence((String)"COMMON_BUSIAUDI"));
        busiaudi.setBusinessId(businessId);
        busiaudi.setBusinesstype(businesstype);
        busiaudi.setScopename(busiaudiScopeBO.getScopeName());
        busiaudi.setCreatorId(userId);
        busiaudi.setCreatedate(createdate);
        busiaudi.setDeleted(0);
        return busiaudi;
    }

    @Override
    @Cacheable
    public List<Long> getRealOrgScope(Long businessId, Integer businesstype) {
        List<Busiaudi> busiaudiList = this.self.findList(businessId, businesstype, BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue());
        List orgIdList = IdUtil.getIds(busiaudiList, Busiaudi::getScopeId);
        List orgList = this.orgPlusService.findByIds(orgIdList);
        if (ListUtil.isNullorEmpty((List)orgList)) {
            return new ArrayList<Long>();
        }
        orgList = orgList.stream().filter(e -> e.getIsvirtual() == 0).collect(Collectors.toList());
        return IdUtil.getIds(orgList, Org::getOrgId);
    }

    @Override
    @Cacheable
    public List<Long> getVirtualNoFilterOrgScope(Long businessId, Integer businesstype) {
        List<Object> domainList = this.getVirtualDomainScopeList(businessId, businesstype);
        if (ListUtil.isNullorEmpty(domainList)) {
            return new ArrayList<Long>();
        }
        domainList = domainList.stream().filter(e -> e.getFilteruseron() == 0).collect(Collectors.toList());
        return IdUtil.getIds(domainList, Domain::getDomainId);
    }

    @Override
    @Cacheable
    public List<Long> getVirtualFilterOrgScope(Long businessId, Integer businesstype) {
        List<Object> domainList = this.getVirtualDomainScopeList(businessId, businesstype);
        if (ListUtil.isNullorEmpty(domainList)) {
            return new ArrayList<Long>();
        }
        domainList = domainList.stream().filter(e -> e.getFilteruseron() == 1).collect(Collectors.toList());
        return IdUtil.getIds(domainList, Domain::getDomainId);
    }

    private List<Domain> getVirtualDomainScopeList(Long businessId, Integer businesstype) {
        List<Busiaudi> busiaudiList = this.self.findList(businessId, businesstype, BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue());
        List orgIdList = IdUtil.getIds(busiaudiList, Busiaudi::getScopeId);
        List orgList = this.orgPlusService.findByIds(orgIdList);
        if (ListUtil.isNullorEmpty((List)orgList)) {
            return new ArrayList<Domain>();
        }
        orgList = orgList.stream().filter(e -> e.getIsvirtual() == 1).collect(Collectors.toList());
        List domainIdList = IdUtil.getIds(orgList, Org::getOrgId);
        return this.domainPlusService.findByIds(domainIdList);
    }

    @Override
    public List<Busiaudi> getUserSelfScope(Long userId) {
        ArrayList<Busiaudi> busiaudiList = new ArrayList<Busiaudi>();
        Busiaudi busiaudi = new Busiaudi();
        busiaudi.setScopeId(userId);
        busiaudi.setScopetype(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_USER.getValue().longValue());
        busiaudiList.add(busiaudi);
        List orgIdList = UserCoreUtil.getAllDomainIdsAndFullOrgIds((Long)userId);
        if (ListUtil.notNullorEmpty((List)orgIdList)) {
            for (Long orgId : orgIdList) {
                Busiaudi orgBusiaudi = new Busiaudi();
                orgBusiaudi.setScopeId(orgId);
                orgBusiaudi.setScopetype(BusiaudiScopetypeEnum.BUSIAUDI_SCOPETYPE_ORG_INCLUDESUB.getValue().longValue());
                busiaudiList.add(orgBusiaudi);
            }
        }
        return busiaudiList;
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':getListByBusinessIdAndBusinesstype:' + #root.args[0][0] + ',' + #root.args[0][1]"), @CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':findListByBusinessIdAndBusinesstype:' + #root.args[0][0] + ',' + #root.args[0][1]")})
    public void clearCache(List<String> values) {
    }
}

