/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.busicorrect.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.busicorrect.bo.BusicorrectBO;
import com.peak.prd.common.busicorrect.bo.BusicorrectQueryBO;
import com.peak.prd.common.busicorrect.dao.IBusicorrectPlusDao;
import com.peak.prd.common.busicorrect.model.Busicorrect;
import com.peak.prd.common.busicorrect.service.IBusicorrectPlusService;
import com.peak.prd.common.busicorrect.vo.BusicorrectMngVO;
import com.peak.prd.common.busicorrect.vo.BusicorrectQuery;
import com.peak.prd.enums.BcBusicorrectStatusEnum;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BusicorrectPlusService
extends PrdBaseService<Busicorrect, Long, BusicorrectQuery>
implements IBusicorrectPlusService {
    private IBusicorrectPlusDao busicorrectPlusDao;

    public void setBusicorrectPlusDao(IBusicorrectPlusDao dao) {
        this.busicorrectPlusDao = dao;
    }

    public IBusicorrectPlusDao getBusicorrectPlusDao() {
        return this.busicorrectPlusDao;
    }

    public IEntityDao<Busicorrect, Long, BusicorrectQuery> getEntityDao() {
        return this.busicorrectPlusDao;
    }

    @Override
    public Paging<BusicorrectMngVO> getMngVOList(BusicorrectQueryBO busicorrectQueryBO) {
        BusicorrectQuery busicorrectQuery = (BusicorrectQuery)ConvertUtil.convert((Object)((Object)busicorrectQueryBO), BusicorrectQuery.class);
        busicorrectQuery.getPage().setSortColumns("cbc.CREATEDATE desc");
        Paging busicorrectMngVOPaging = this.getBusicorrectPlusDao().findPaging(busicorrectQuery, BusicorrectMngVO.class);
        if (ListUtil.isNullorEmpty((List)busicorrectMngVOPaging.getList())) {
            return busicorrectMngVOPaging;
        }
        UserCoreUtil.setUserVO((List)busicorrectMngVOPaging.getList(), BusicorrectMngVO::getCreatorId, BusicorrectMngVO::setUserVO);
        return busicorrectMngVOPaging;
    }

    @Override
    public Long txInsert(BusicorrectBO busicorrectBO, Long userId, Long domainId) {
        Busicorrect busicorrect = (Busicorrect)ConvertUtil.convert((Object)busicorrectBO, Busicorrect.class);
        busicorrect.setBusicorrectId(IdUtil.getSequence((String)"COMMON_BUSICORRECT"));
        busicorrect.setDomainId(domainId);
        busicorrect.setStatus(0);
        busicorrect.setCreatorId(userId);
        busicorrect.setCreatedate(new Date());
        this.getBusicorrectPlusDao().insertSelective((BaseEntity)busicorrect);
        return busicorrect.getBusicorrectId();
    }

    @Override
    public Integer updateStatus(Long busicorrectId, Integer status, Long userId) {
        Busicorrect busicorrect = new Busicorrect();
        busicorrect.setBusicorrectId(busicorrectId);
        busicorrect.setStatus(status);
        busicorrect.setOperatorId(userId);
        busicorrect.setOperatedate(new Date());
        return this.getBusicorrectPlusDao().updateSelective(busicorrect);
    }

    @Override
    public Integer batchUpdateStatus(List<Long> busicorrectIdList, Integer status, Long userId) {
        Integer updateNum = this.getBusicorrectPlusDao().batchUpdateStatus(busicorrectIdList, status, userId);
        if (ListUtil.isNullorEmpty(busicorrectIdList)) {
            return updateNum;
        }
        for (Long busicorrectId : busicorrectIdList) {
            if (status.intValue() == BcBusicorrectStatusEnum.TRUE.getValue()) {
                MessageQHelper.send((String)"busicorrect", (Long)busicorrectId, (String)"true", (Object)"");
                continue;
            }
            if (status.intValue() != BcBusicorrectStatusEnum.FALSE.getValue()) continue;
            MessageQHelper.send((String)"busicorrect", (Long)busicorrectId, (String)"false", (Object)"");
        }
        return updateNum;
    }
}

