/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.holiday.service.imple;

import com.peak.common.util.DateUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.holiday.dao.IHolidayPlusDao;
import com.peak.prd.common.holiday.model.Holiday;
import com.peak.prd.common.holiday.service.IHolidayPlusService;
import com.peak.prd.common.holiday.vo.HolidayQuery;
import java.util.Calendar;
import java.util.Date;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class HolidayPlusService
extends PrdBaseService<Holiday, Long, HolidayQuery>
implements IHolidayPlusService {
    private IHolidayPlusDao holidayPlusDao;

    public void setHolidayPlusDao(IHolidayPlusDao dao) {
        this.holidayPlusDao = dao;
    }

    public IHolidayPlusDao getHolidayPlusDao() {
        return this.holidayPlusDao;
    }

    public IEntityDao<Holiday, Long, HolidayQuery> getEntityDao() {
        return this.holidayPlusDao;
    }

    @Override
    @Cacheable
    public boolean isWorkingDay(Date date) {
        boolean ret = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(7);
        date = DateUtil.toSDate((Date)date);
        if (week == 1 || week == 7) {
            HolidayQuery holidayQuery = new HolidayQuery();
            holidayQuery.setYear(DateUtil.getYear((Date)date));
            holidayQuery.setType(2);
            holidayQuery.setBegindateEnd(date);
            holidayQuery.setEnddateBegin(date);
            long count = this.holidayPlusDao.count(holidayQuery);
            if (count > 0L) {
                ret = true;
            }
        } else {
            ret = true;
            HolidayQuery holidayQuery = new HolidayQuery();
            holidayQuery.setYear(DateUtil.getYear((Date)date));
            holidayQuery.setType(1);
            holidayQuery.setBegindateEnd(date);
            holidayQuery.setEnddateBegin(date);
            long count = this.holidayPlusDao.count(holidayQuery);
            if (count > 0L) {
                ret = false;
            }
        }
        return ret;
    }
}

