/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.interactset.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.interactset.bo.InteractsetBO;
import com.peak.prd.common.interactset.dao.IInteractsetPlusDao;
import com.peak.prd.common.interactset.model.Interactset;
import com.peak.prd.common.interactset.service.IInteractsetPlusService;
import com.peak.prd.common.interactset.vo.InteractsetDetailMngVO;
import com.peak.prd.common.interactset.vo.InteractsetQuery;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class InteractsetPlusService
extends PrdBaseService<Interactset, Long, InteractsetQuery>
implements IInteractsetPlusService {
    @Resource
    private IInteractsetPlusDao interactsetPlusDao;

    public IEntityDao<Interactset, Long, InteractsetQuery> getEntityDao() {
        return this.interactsetPlusDao;
    }

    @Override
    public Long insert(Long userId, InteractsetBO interactsetBO) {
        Interactset interactset = (Interactset)ConvertUtil.convert((Object)interactsetBO, Interactset.class);
        Long interactsetId = IdUtil.getSequence((String)"COMMON_INTERACTSET");
        interactset.setInteractsetId(interactsetId);
        interactset.setCreatorId(userId);
        interactset.setCreatedate(new Date());
        this.interactsetPlusDao.insertSelective((BaseEntity)interactset);
        return interactsetId;
    }

    @Override
    public Long insertOrUpdate(Long userId, InteractsetBO interactsetBO) {
        Interactset interactset = this.getByBusinessIdAndBusinesstype(interactsetBO.getBusinessId(), interactsetBO.getBusinesstype());
        if (interactset != null) {
            this.update(interactsetBO);
            return interactset.getInteractsetId();
        }
        return this.insert(userId, interactsetBO);
    }

    @Override
    public Integer update(InteractsetBO interactsetBO) {
        return this.interactsetPlusDao.updateByBusIdBusType(interactsetBO.getBusinessId(), interactsetBO.getBusinesstype(), interactsetBO.getIscomment(), interactsetBO.getIstopic());
    }

    @Override
    public Integer update(Long businessId, Integer businessType, Integer isComment, Integer isTopic) {
        return this.interactsetPlusDao.updateByBusIdBusType(businessId, businessType, isComment, isTopic);
    }

    @Override
    public InteractsetDetailMngVO getMngInfo(Long businessId, Integer businesstype) {
        Interactset interactset = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        return (InteractsetDetailMngVO)ConvertUtil.convert((Object)interactset, InteractsetDetailMngVO.class);
    }

    @Override
    public Interactset getByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        InteractsetQuery query = new InteractsetQuery(1, 1);
        query.setBusinessId(businessId);
        query.setBusinesstype(businesstype);
        return (Interactset)this.interactsetPlusDao.findOne(query);
    }
}

