/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.pageset.service.imple;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.FileUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.common.util.ZipUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.oss.util.OssUtil;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.pageset.bo.PagesetBO;
import com.peak.prd.common.pageset.dao.IPagesetPlusDao;
import com.peak.prd.common.pageset.model.Pageset;
import com.peak.prd.common.pageset.service.IPagesetPlusService;
import com.peak.prd.common.pageset.vo.PagesetDetailVO;
import com.peak.prd.common.pageset.vo.PagesetQuery;
import com.peak.prd.common.pageset.vo.PagesetUploadVO;
import com.peak.prd.config.AppCommonConfig;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PagesetPlusService
extends PrdBaseService<Pageset, Long, PagesetQuery>
implements IPagesetPlusService {
    @Resource
    private IPagesetPlusDao pagesetPlusDao;

    public IEntityDao<Pageset, Long, PagesetQuery> getEntityDao() {
        return this.pagesetPlusDao;
    }

    @Override
    public PagesetUploadVO uploadZip(Long businessId, Integer businesstype, String tpzipfilepath, Integer type) {
        Pageset pageset = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        String typeStr = type == 1 ? "pc" : "app";
        String tpzipPath = "";
        if (pageset == null) {
            pageset = new Pageset();
            pageset.setConfigtype(1);
            pageset.setBusinessId(businessId);
            pageset.setBusinesstype(businesstype);
            tpzipPath = "pagesetzip/" + IdUtil.getGkey() + "/" + businessId + "/" + businesstype + "/" + typeStr + "/";
        } else {
            tpzipPath = type == 1 ? (StringUtil.isNullorEmptyStr((String)pageset.getPcpath()) ? "pagesetzip/" + IdUtil.getGkey() + "/" + businessId + "/" + businesstype + "/" + typeStr + "/" : pageset.getPcpath()) : (StringUtil.isNullorEmptyStr((String)pageset.getApppath()) ? "pagesetzip/" + IdUtil.getGkey() + "/" + businessId + "/" + businesstype + "/" + typeStr + "/" : pageset.getApppath());
        }
        String destPath = AppPathUtil.getResourceLocalPath() + tpzipPath;
        ZipUtil.unzip((String)tpzipfilepath, (String)destPath, null);
        FileUtil.delFile((String)tpzipfilepath);
        AppCommonConfig config = (AppCommonConfig)SpringUtil.getBean(AppCommonConfig.class);
        if (config.getOssEnable()) {
            OssUtil.uploadFolder((String)destPath);
        }
        Date curdate = new Date();
        if (type == 1) {
            pageset.setPcpath(tpzipPath);
            pageset.setPcuploaddate(curdate);
        } else {
            pageset.setApppath(tpzipPath);
            pageset.setAppuploaddate(curdate);
        }
        if (this.updateSelective(pageset) == 0) {
            this.insertSelective((BaseEntity)pageset);
        }
        PagesetUploadVO pagesetUploadVO = new PagesetUploadVO();
        pagesetUploadVO.setPath(tpzipPath + "index.html?businessId=" + businessId + "&businesstype=" + businesstype);
        pagesetUploadVO.setDate(curdate);
        return pagesetUploadVO;
    }

    @Override
    public PagesetDetailVO getInfo(Long businessId, Integer businesstype) {
        Pageset pageset = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (pageset == null) {
            return null;
        }
        PagesetDetailVO pagesetDetailMngVO = (PagesetDetailVO)ConvertUtil.convert((Object)pageset, PagesetDetailVO.class);
        pagesetDetailMngVO.setApppath(pagesetDetailMngVO.getApppath() + "index.html?businessId=" + businessId + "&businesstype=" + businesstype);
        pagesetDetailMngVO.setPcpath(pagesetDetailMngVO.getPcpath() + "index.html?businessId=" + businessId + "&businesstype=" + businesstype);
        return pagesetDetailMngVO;
    }

    @Override
    public Integer updateTypeAndTemplatenum(PagesetBO pagesetBO) {
        Pageset pageset = this.getByBusinessIdAndBusinesstype(pagesetBO.getBusinessId(), pagesetBO.getBusinesstype());
        if (pageset == null) {
            pageset = (Pageset)ConvertUtil.convert((Object)pagesetBO, Pageset.class);
            pageset.setPagesetId(IdUtil.getSequence((String)"COMMON_PAGESET"));
            return this.pagesetPlusDao.insertSelective((BaseEntity)pageset);
        }
        pageset.setConfigtype(pagesetBO.getConfigtype());
        pageset.setTemplatenum(pagesetBO.getTemplatenum());
        return this.pagesetPlusDao.updateSelective(pageset);
    }

    @Override
    public Pageset getByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        PagesetQuery query = new PagesetQuery(1, 1);
        query.setBusinessId(businessId);
        query.setBusinesstype(businesstype);
        return (Pageset)this.pagesetPlusDao.findOne(query);
    }
}

