/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.rule.bo.RuleBO;
import com.peak.prd.common.rule.dao.IRulePlusDao;
import com.peak.prd.common.rule.model.Rule;
import com.peak.prd.common.rule.service.IRulePlusService;
import com.peak.prd.common.rule.vo.RuleQuery;
import com.peak.prd.common.rule.vo.RuleVO;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RulePlusService
extends PrdBaseService<Rule, Long, RuleQuery>
implements IRulePlusService {
    @Resource
    private IRulePlusDao rulePlusDao;

    public IEntityDao<Rule, Long, RuleQuery> getEntityDao() {
        return this.rulePlusDao;
    }

    @Override
    public Rule getByBusiness(Long businessId, Integer businesstype) {
        RuleQuery ruleQuery = new RuleQuery();
        ruleQuery.setBusinessId(businessId);
        ruleQuery.setBusinesstype(businesstype);
        return (Rule)this.rulePlusDao.findOne(ruleQuery);
    }

    @Override
    public RuleVO getVOByBusiness(Long businessId, Integer businesstype) {
        Rule rule = this.getByBusiness(businessId, businesstype);
        if (rule == null) {
            return null;
        }
        RuleVO ruleVO = (RuleVO)ConvertUtil.convert((Object)rule, RuleVO.class);
        return ruleVO;
    }

    @Override
    public Integer insertOrUpdate(RuleBO ruleBO) {
        Rule rule = this.getByBusiness(ruleBO.getBusinessId(), ruleBO.getBusinesstype());
        if (rule == null) {
            rule = (Rule)ConvertUtil.convert((Object)ruleBO, Rule.class);
            rule.setRuleId(IdUtil.getSequence((String)"COMMON_RULE"));
            if (rule.getStatus() == null) {
                rule.setStatus(1);
            }
            rule.setCreatedate(new Date());
            this.rulePlusDao.insertSelective((BaseEntity)rule);
            return 1;
        }
        Rule ruleUpdate = (Rule)ConvertUtil.convert((Object)ruleBO, Rule.class);
        ruleUpdate.setRuleId(rule.getRuleId());
        return this.rulePlusDao.updateSelective(ruleUpdate);
    }
}

