/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.rule.Matchrule;
import com.peak.prd.common.rule.bo.RuleconfigBO;
import com.peak.prd.common.rule.dao.IRuleconfigPlusDao;
import com.peak.prd.common.rule.enums.RelationEnum;
import com.peak.prd.common.rule.enums.RuleconfigEnum;
import com.peak.prd.common.rule.enums.RuleconfigTypeEnum;
import com.peak.prd.common.rule.model.Ruleconfig;
import com.peak.prd.common.rule.service.IRuleconfigPlusService;
import com.peak.prd.common.rule.util.RuleParamUtil;
import com.peak.prd.common.rule.util.RuleStringUtil;
import com.peak.prd.common.rule.util.outer.OuterRuleCalculatorManager;
import com.peak.prd.common.rule.vo.RuleconfigQuery;
import com.peak.prd.enums.BcResponseStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RuleconfigPlusService
extends PrdBaseService<Ruleconfig, Long, RuleconfigQuery>
implements IRuleconfigPlusService {
    @Resource
    private IRuleconfigPlusDao ruleconfigPlusDao;

    public IEntityDao<Ruleconfig, Long, RuleconfigQuery> getEntityDao() {
        return this.ruleconfigPlusDao;
    }

    @Override
    public boolean isValid(Matchrule matchrule, Map<String, Object> params) {
        Ruleconfig ruleconfig = this.getByCode(matchrule.getName());
        if (ruleconfig == null || ruleconfig.getStatus() == null || ruleconfig.getStatus() == 0) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_NOT_EXIST_OR_STATUS_OFF);
        }
        params.put("value", matchrule.getValue());
        RuleconfigEnum ruleconfigEnum = this.getByCodeAndValid(matchrule.getName(), params);
        if (ruleconfigEnum.type().equals((Object)RuleconfigTypeEnum.OUTER)) {
            return OuterRuleCalculatorManager.getOuterRuleCalculator(ruleconfigEnum).calc(params);
        }
        switch (ruleconfigEnum) {
            default: 
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_NOT_EXIST_OR_STATUS_OFF);
        return false;
    }

    private boolean numberValid(String sqlId, Matchrule matchrule, Map<String, Object> params) {
        String sqlValue = this.querySqlValue(sqlId, matchrule, params);
        List<String> valueList = RuleStringUtil.split(matchrule.getValue());
        RelationEnum relationEnum = RelationEnum.getByCode(matchrule.getRelation());
        switch (relationEnum) {
            case EQUAL: {
                return new BigDecimal(sqlValue).compareTo(new BigDecimal(matchrule.getValue())) == 0;
            }
            case GREATER: {
                return new BigDecimal(sqlValue).compareTo(new BigDecimal(matchrule.getValue())) > 0;
            }
            case LESS: {
                return new BigDecimal(sqlValue).compareTo(new BigDecimal(matchrule.getValue())) < 0;
            }
            case GREATEREQUAL: {
                return new BigDecimal(sqlValue).compareTo(new BigDecimal(matchrule.getValue())) >= 0;
            }
            case LESSEQUAL: {
                return new BigDecimal(sqlValue).compareTo(new BigDecimal(matchrule.getValue())) <= 0;
            }
            case LEFTLIKE: 
            case RIGHTLIKE: 
            case LIKE: {
                return new BigDecimal(sqlValue).compareTo(BigDecimal.ZERO) > 0;
            }
            case RANGE: {
                return valueList.get(0).compareTo(sqlValue) <= 0 && sqlValue.compareTo(valueList.get(1)) <= 0;
            }
            case IN: {
                return valueList.contains(sqlValue);
            }
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_RELATION_NOT_EXIST_OR_NOT_VALID);
        return false;
    }

    private boolean stringValid(String sqlId, Matchrule matchrule, Map<String, Object> params) {
        String sqlValue = this.querySqlValue(sqlId, matchrule, params);
        List<String> valueList = RuleStringUtil.split(matchrule.getValue());
        RelationEnum relationEnum = RelationEnum.getByCode(matchrule.getRelation());
        switch (relationEnum) {
            case EQUAL: {
                return sqlValue.equals(matchrule.getValue());
            }
            case GREATER: {
                return sqlValue.compareTo(matchrule.getValue()) > 0;
            }
            case LESS: {
                return sqlValue.compareTo(matchrule.getValue()) < 0;
            }
            case GREATEREQUAL: {
                return sqlValue.compareTo(matchrule.getValue()) >= 0;
            }
            case LESSEQUAL: {
                return sqlValue.compareTo(matchrule.getValue()) <= 0;
            }
            case LEFTLIKE: 
            case RIGHTLIKE: 
            case LIKE: {
                return new BigDecimal(sqlValue).compareTo(BigDecimal.ZERO) > 0;
            }
            case RANGE: {
                return valueList.get(0).compareTo(sqlValue) <= 0 && sqlValue.compareTo(valueList.get(1)) <= 0;
            }
            case IN: {
                return valueList.contains(sqlValue);
            }
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_RELATION_NOT_EXIST_OR_NOT_VALID);
        return false;
    }

    private boolean dateValid(String sqlId, Matchrule matchrule, Map<String, Object> params) {
        String sqlValue = this.querySqlValue(sqlId, matchrule, params);
        List<String> valueList = RuleStringUtil.split(matchrule.getValue());
        RelationEnum relationEnum = RelationEnum.getByCode(matchrule.getRelation());
        switch (relationEnum) {
            case EQUAL: {
                return sqlValue.equals(matchrule.getValue());
            }
            case GREATER: {
                return sqlValue.compareTo(matchrule.getValue()) > 0;
            }
            case LESS: {
                return sqlValue.compareTo(matchrule.getValue()) < 0;
            }
            case GREATEREQUAL: {
                return sqlValue.compareTo(matchrule.getValue()) >= 0;
            }
            case LESSEQUAL: {
                return sqlValue.compareTo(matchrule.getValue()) <= 0;
            }
            case RANGE: {
                return valueList.get(0).compareTo(sqlValue) <= 0 && sqlValue.compareTo(valueList.get(1)) <= 0;
            }
            case IN: {
                return valueList.contains(sqlValue);
            }
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_RELATION_NOT_EXIST_OR_NOT_VALID);
        return false;
    }

    private String querySqlValue(String sqlId, Matchrule matchrule, Map<String, Object> params) {
        params.put("matchrule", matchrule);
        return RuleStringUtil.trim(this.ruleconfigPlusDao.queryOne(sqlId, params));
    }

    @Override
    public Ruleconfig getByCode(String code) {
        List<Ruleconfig> ruleconfigList = this.getAllRuleconfig(null);
        for (Ruleconfig ruleconfig : ruleconfigList) {
            if (!RuleStringUtil.standardEqual(ruleconfig.getCode(), code)) continue;
            return ruleconfig;
        }
        return null;
    }

    @Override
    public List<Ruleconfig> getAllRuleconfig(Integer status) {
        RuleconfigQuery ruleconfigQuery = new RuleconfigQuery(1, 1000);
        ruleconfigQuery.setStatus(status);
        List ruleconfigList = this.ruleconfigPlusDao.findList(ruleconfigQuery);
        if (ListUtil.isNullorEmpty((List)ruleconfigList)) {
            return new ArrayList<Ruleconfig>();
        }
        return ruleconfigList;
    }

    @Override
    public Long insert(RuleconfigBO ruleconfigBO) {
        Ruleconfig ruleconfig = (Ruleconfig)ConvertUtil.convert((Object)ruleconfigBO, Ruleconfig.class);
        ruleconfig.setRuleconfigId(IdUtil.getSequence((String)"COMMON_RULECONFIG"));
        ruleconfig.setCreatedate(new Date());
        if (ruleconfig.getStatus() == null) {
            ruleconfig.setStatus(0);
        }
        this.ruleconfigPlusDao.insertSelective((BaseEntity)ruleconfig);
        return ruleconfig.getRuleconfigId();
    }

    @Override
    public Integer update(RuleconfigBO ruleconfigBO) {
        Ruleconfig ruleconfigOri = (Ruleconfig)this.ruleconfigPlusDao.getById(ruleconfigBO.getRuleconfigId());
        if (ruleconfigOri == null) {
            return 0;
        }
        Ruleconfig ruleconfig = (Ruleconfig)ConvertUtil.convert((Object)ruleconfigBO, Ruleconfig.class);
        return this.ruleconfigPlusDao.updateSelective(ruleconfig);
    }

    @Override
    public Integer updateStatus(Long ruleconfigId, Integer status) {
        Ruleconfig ruleconfig = new Ruleconfig();
        ruleconfig.setRuleconfigId(ruleconfigId);
        ruleconfig.setStatus(status);
        return this.ruleconfigPlusDao.updateSelective(ruleconfig);
    }

    private RuleconfigEnum getByCodeAndValid(String code, Map<String, Object> params) {
        RuleconfigEnum ruleconfigEnum = RuleconfigEnum.getByCode(code);
        if (ruleconfigEnum == null) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_NOT_EXIST_OR_STATUS_OFF);
        }
        for (String param : ruleconfigEnum.params()) {
            if (RuleParamUtil.hasKey(param, params)) continue;
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_PARAM_NOT_EXIST);
        }
        return ruleconfigEnum;
    }
}

