/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.util;

import com.peak.common.util.SpringUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.rule.model.Rule;
import com.peak.prd.common.rule.service.IRulePlusService;
import com.peak.prd.common.rule.util.compile.RuleCompileUtil;
import com.peak.prd.enums.BcResponseStatusEnum;
import java.util.HashMap;
import java.util.Map;

public class RuleUtil {
    public static boolean isValidByUserId(Long businessId, Integer businesstype, Long userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        return RuleUtil.isValid(businessId, businesstype, params);
    }

    public static boolean isValid(Long businessId, Integer businesstype, Map<String, Object> params) {
        Rule rule = RuleUtil.getRulePlusService().getByBusiness(businessId, businesstype);
        if (rule == null || rule.getStatus() == 0) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_NOT_EXIST_OR_STATUS_OFF);
        }
        return RuleCompileUtil.compileAndCalcRule(rule.getRulejson(), businessId, businesstype, params);
    }

    private static IRulePlusService getRulePlusService() {
        return (IRulePlusService)SpringUtil.getBean(IRulePlusService.class);
    }
}

