/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.util.compile;

import com.peak.common.util.JsonUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.rule.Matchrule;
import com.peak.prd.common.rule.UserFilterRule;
import com.peak.prd.common.rule.enums.TokenTypeEnum;
import com.peak.prd.common.rule.service.IRuleconfigPlusService;
import com.peak.prd.common.rule.util.compile.RuleExpressionCalcUtil;
import com.peak.prd.common.rule.util.compile.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuleCompileUtil {
    public static boolean compileAndCalcRule(String rulejson, Long businessId, Integer businesstype, Map<String, Object> params) {
        params.put("businessId", businessId);
        params.put("businesstype", businesstype);
        UserFilterRule userFilterRule = (UserFilterRule)JsonUtil.JsonToObject((String)rulejson, UserFilterRule.class);
        List<Token> tokenList = RuleCompileUtil.compile(userFilterRule.getOperationrule());
        List<Boolean> ruleValueList = null;
        ruleValueList = RuleCompileUtil.calcMatchruleList(userFilterRule.getMatchrulelist(), params);
        StringBuffer newExpr = new StringBuffer();
        for (Token token : tokenList) {
            if (token.type().equals((Object)TokenTypeEnum.RULE)) {
                newExpr.append(ruleValueList.get(Integer.valueOf(token.text())));
            } else {
                newExpr.append(token.text());
            }
            newExpr.append(" ");
        }
        return RuleExpressionCalcUtil.calcBoolean(newExpr.toString());
    }

    private static boolean isAllAndNotExistBracket(List<Token> tokenList) {
        for (Token token : tokenList) {
            if (!token.type().equals((Object)TokenTypeEnum.BRACKET) && (!token.type().equals((Object)TokenTypeEnum.OPERATOR) || token.equals(Token.AND))) continue;
            return false;
        }
        return true;
    }

    private static List<Boolean> calcMatchruleList(List<Matchrule> matchrulelist, Map<String, Object> params) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(false);
        for (Matchrule matchrule : matchrulelist) {
            list.add(RuleCompileUtil.getRuleconfigPlusService().isValid(matchrule, params));
        }
        return list;
    }

    private static List<Token> compile(String expr) {
        List<Token> tokenList = new ArrayList<Token>();
        tokenList.add(new Token(expr));
        tokenList = RuleCompileUtil.findAllText(Token.LEFT_BRACKET.text(), tokenList);
        tokenList = RuleCompileUtil.findAllText(Token.RIGHT_BRACKET.text(), tokenList);
        tokenList = RuleCompileUtil.splitAndTrim(tokenList);
        return tokenList;
    }

    private static List<Token> splitAndTrim(List<Token> tokenList) {
        ArrayList<Token> resultList = new ArrayList<Token>();
        for (Token token : tokenList) {
            if (StringUtil.isNullorEmptyStr((String)token.text())) continue;
            resultList.addAll(RuleCompileUtil.splitAndTrim(token));
        }
        return resultList;
    }

    private static List<Token> splitAndTrim(Token token) {
        ArrayList<Token> resultList = new ArrayList<Token>();
        if (!token.type().equals((Object)TokenTypeEnum.TEXT)) {
            resultList.add(token);
            return resultList;
        }
        String tokenText = token.text();
        String[] textArray = tokenText.split("\\s+");
        if (textArray == null || textArray.length == 0) {
            return resultList;
        }
        for (String text : textArray) {
            if (StringUtil.isNullorEmptyStr((String)text)) continue;
            resultList.add(new Token(text));
        }
        return resultList;
    }

    private static List<Token> findAllText(String text, List<Token> tokenList) {
        ArrayList<Token> resultList = new ArrayList<Token>();
        for (Token token : tokenList) {
            if (token.type().equals((Object)TokenTypeEnum.TEXT)) {
                resultList.addAll(RuleCompileUtil.findAllText(text, token));
                continue;
            }
            resultList.add(token);
        }
        return resultList;
    }

    private static List<Token> findAllText(String text, Token token) {
        int index;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        String tokenText = token.text();
        if (StringUtil.isNullorEmptyStr((String)tokenText)) {
            return tokenList;
        }
        int p = 0;
        while (p < tokenText.length() && (index = tokenText.indexOf(text, p)) != -1) {
            if (index > p) {
                tokenList.add(new Token(tokenText.substring(p, index)));
            }
            tokenList.add(new Token(text));
            p = index + text.length();
        }
        if (p < tokenText.length()) {
            tokenList.add(new Token(tokenText.substring(p)));
        }
        return tokenList;
    }

    private static IRuleconfigPlusService getRuleconfigPlusService() {
        return (IRuleconfigPlusService)SpringUtil.getBean(IRuleconfigPlusService.class);
    }
}

