/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.util.compile;

import com.peak.common.util.StringUtil;
import com.peak.prd.common.rule.util.compile.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class RuleExpressionCalcUtil {
    public static boolean calcBoolean(String expression) {
        return RuleExpressionCalcUtil.calc(expression);
    }

    private static boolean calc(String expr) {
        String[] array = expr.split("\\s+");
        ArrayList<Token> infixTokenList = new ArrayList<Token>();
        for (String s : array) {
            if (StringUtil.isNullorEmptyStr((String)s)) continue;
            infixTokenList.add(new Token(s));
        }
        System.out.println("\u4e2d\u7f00\u8868\u8fbe\u5f0f:" + ((Object)infixTokenList).toString());
        Stack<Token> postfixTokenStack = RuleExpressionCalcUtil.infixToPostfix(infixTokenList);
        System.out.println("\u540e\u7f00\u8868\u8fbe\u5f0f:" + postfixTokenStack.toString());
        return RuleExpressionCalcUtil.calc(postfixTokenStack);
    }

    private static boolean calc(Stack<Token> stack) {
        Stack<Token> valueStack = new Stack<Token>();
        for (int i = 0; !(i >= 1000 || valueStack.size() == 1 && ((Token)valueStack.peek()).isValue() && stack.isEmpty()); ++i) {
            if (stack.peek().isOperator()) {
                stack.pop().calc(valueStack);
                continue;
            }
            valueStack.push(stack.pop());
        }
        return ((Token)valueStack.pop()).booleanValue();
    }

    private static Stack<Token> infixToPostfix(List<Token> tokenList) {
        Stack<Token> operatorStack = new Stack<Token>();
        Stack<Token> middleResultStack = new Stack<Token>();
        for (int i = 0; i < tokenList.size(); ++i) {
            Token token = tokenList.get(i);
            if (token.isValue()) {
                middleResultStack.push(token);
            } else if (token.isOperator()) {
                if (token.equals(Token.LEFT_BRACKET)) {
                    operatorStack.push(token);
                    RuleExpressionCalcUtil.printStack(middleResultStack, operatorStack);
                    continue;
                }
                if (token.equals(Token.RIGHT_BRACKET)) {
                    while (!operatorStack.peek().equals(Token.LEFT_BRACKET)) {
                        middleResultStack.push(operatorStack.pop());
                    }
                    operatorStack.pop();
                    RuleExpressionCalcUtil.printStack(middleResultStack, operatorStack);
                    continue;
                }
                if (operatorStack.isEmpty() || operatorStack.peek().equals(Token.LEFT_BRACKET)) {
                    operatorStack.push(token);
                } else {
                    while (!operatorStack.isEmpty() && token.operatorLevel() >= operatorStack.peek().operatorLevel() && !operatorStack.peek().equals(Token.LEFT_BRACKET)) {
                        middleResultStack.push(operatorStack.pop());
                    }
                    operatorStack.push(token);
                }
            }
            RuleExpressionCalcUtil.printStack(middleResultStack, operatorStack);
        }
        while (!operatorStack.isEmpty()) {
            middleResultStack.push((Token)operatorStack.pop());
        }
        Stack<Token> resultStack = new Stack<Token>();
        while (!middleResultStack.isEmpty()) {
            resultStack.push((Token)middleResultStack.pop());
        }
        return resultStack;
    }

    private static void printStack(Stack<Token> middleResultStack, Stack<Token> operatorStack) {
    }
}

