/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.util.compile;

import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.rule.enums.TokenTypeEnum;
import com.peak.prd.common.rule.util.RuleStringUtil;
import com.peak.prd.enums.BcResponseStatusEnum;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Token {
    public static final Token LEFT_BRACKET = new Token("(");
    public static final Token RIGHT_BRACKET = new Token(")");
    public static final Token AND = new Token("&&");
    public static final Token OR = new Token("||");
    public static final Token NOT = new Token("!");
    private String text;
    private TokenTypeEnum type;

    public String text() {
        return this.text;
    }

    public boolean isTrue() {
        return this.type.equals((Object)TokenTypeEnum.TEXT) && RuleStringUtil.standardEqual(this.text, "true");
    }

    public boolean isFalse() {
        return this.type.equals((Object)TokenTypeEnum.TEXT) && RuleStringUtil.standardEqual(this.text, "false");
    }

    public boolean isValue() {
        return this.isTrue() || this.isFalse();
    }

    public boolean booleanValue() {
        if (this.isTrue()) {
            return true;
        }
        if (this.isFalse()) {
            return false;
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_NOT_EXIST_OR_STATUS_OFF);
        return false;
    }

    public boolean isOperator() {
        return this.equals(AND) || this.equals(OR) || this.equals(NOT);
    }

    public void calc(Stack<Token> stack) {
        if (this.equals(NOT)) {
            this.calcUnary(bool -> bool == false, stack);
        } else if (this.equals(AND)) {
            this.calcLogic((a, b) -> a != false && b != false, stack);
        } else if (this.equals(OR)) {
            this.calcLogic((a, b) -> a != false || b != false, stack);
        } else {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_TOKEN_ERROR);
        }
    }

    private void calcUnary(Function<Boolean, Boolean> calcFunc, Stack<Token> stack) {
        Token token = stack.pop();
        stack.push(new Token(String.valueOf(calcFunc.apply(token.booleanValue()))));
    }

    private void calcLogic(BiFunction<Boolean, Boolean, Boolean> calcFunc, Stack<Token> stack) {
        Token token2 = stack.pop();
        Token token1 = stack.pop();
        stack.push(new Token(String.valueOf(calcFunc.apply(token1.booleanValue(), token2.booleanValue()))));
    }

    public Integer operatorLevel() {
        if (this.equals(NOT)) {
            return 3;
        }
        if (this.equals(AND)) {
            return 12;
        }
        if (this.equals(OR)) {
            return 13;
        }
        return null;
    }

    public TokenTypeEnum type() {
        return this.type;
    }

    Token(String text) {
        switch (RuleStringUtil.standard(text)) {
            case "(": {
                this.text = "(";
                this.type = TokenTypeEnum.BRACKET;
                break;
            }
            case ")": {
                this.text = ")";
                this.type = TokenTypeEnum.BRACKET;
                break;
            }
            case "!": 
            case "NOT": {
                this.text = "!";
                this.type = TokenTypeEnum.OPERATOR;
                break;
            }
            case "&&": 
            case "AND": {
                this.text = "&&";
                this.type = TokenTypeEnum.OPERATOR;
                break;
            }
            case "||": 
            case "OR": {
                this.text = "||";
                this.type = TokenTypeEnum.OPERATOR;
                break;
            }
            default: {
                this.text = RuleStringUtil.trim(text);
                this.type = RuleStringUtil.isInteger(text) ? TokenTypeEnum.RULE : TokenTypeEnum.TEXT;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.text.equals(((Token)o).text);
    }

    public String toString() {
        return this.text;
    }
}

