/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.rule.util.outer;

import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.rule.enums.RuleconfigEnum;
import com.peak.prd.common.rule.enums.RuleconfigTypeEnum;
import com.peak.prd.common.rule.util.outer.OuterRuleCalculator;
import com.peak.prd.config.OuterRuleConfig;
import com.peak.prd.enums.BcResponseStatusEnum;
import com.peak.prd.enums.TracelogLevelEnum;
import com.peak.prd.sys.tracelog.service.ITracelogPlusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OuterRuleCalculatorManager {
    private static final Logger log = LoggerFactory.getLogger(OuterRuleCalculatorManager.class);

    public static OuterRuleCalculator getOuterRuleCalculator(RuleconfigEnum ruleconfigEnum) {
        if (ruleconfigEnum == null || !ruleconfigEnum.type().equals((Object)RuleconfigTypeEnum.OUTER)) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
        }
        OuterRuleConfig outerRuleConfig = (OuterRuleConfig)SpringUtil.getBean(OuterRuleConfig.class);
        switch (ruleconfigEnum) {
            case prj1: {
                return OuterRuleCalculatorManager.getOuterRuleCalculator(outerRuleConfig.getPrj1());
            }
            case prj2: {
                return OuterRuleCalculatorManager.getOuterRuleCalculator(outerRuleConfig.getPrj2());
            }
            case prj3: {
                return OuterRuleCalculatorManager.getOuterRuleCalculator(outerRuleConfig.getPrj3());
            }
        }
        ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
        return null;
    }

    private static OuterRuleCalculator getOuterRuleCalculator(String fullName) {
        if (StringUtil.isNullorEmptyStr((String)fullName)) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
        }
        Class<?> clazz = null;
        try {
            clazz = OuterRuleCalculatorManager.class.getClassLoader().loadClass(fullName);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6OuterRuleCalculator\u5931\u8d25:" + fullName);
            log.error(e.getMessage(), (Throwable)e);
            OuterRuleCalculatorManager.getTracelogPlusService().insert("rule", "\u83b7\u53d6OuterRuleCalculator\u5931\u8d25:" + fullName, TracelogLevelEnum.TRACELOG_LEVEL_ERROR);
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
            return null;
        }
        Object outerRuleCalculatorObj = null;
        try {
            outerRuleCalculatorObj = clazz.newInstance();
        }
        catch (Exception e) {
            log.error("\u751f\u6210OuterRuleCalculator\u5b9e\u4f8b\u5931\u8d25\uff1a" + fullName);
            log.error(e.getMessage(), (Throwable)e);
            OuterRuleCalculatorManager.getTracelogPlusService().insert("rule", "\u751f\u6210OuterRuleCalculator\u5b9e\u4f8b\u5931\u8d25:" + fullName, TracelogLevelEnum.TRACELOG_LEVEL_ERROR);
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
            return null;
        }
        if (!(outerRuleCalculatorObj instanceof OuterRuleCalculator)) {
            log.error("\u83b7\u53d6\u7684OuterRuleCalculator\u6ca1\u6709\u5b9e\u73b0OuterRuleCalculator\u63a5\u53e3, OuterRuleCalculator:" + fullName);
            OuterRuleCalculatorManager.getTracelogPlusService().insert("rule", "\u751f\u6210OuterRuleCalculator\u5b9e\u4f8b\u5931\u8d25:" + fullName, TracelogLevelEnum.TRACELOG_LEVEL_ERROR);
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.RULE_OUTER_GET_ERROR);
            return null;
        }
        return outerRuleCalculatorObj;
    }

    private static ITracelogPlusService getTracelogPlusService() {
        return (ITracelogPlusService)SpringUtil.getBean(ITracelogPlusService.class);
    }
}

