/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.webpage.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.webpage.dao.IUserwebpagePlusDao;
import com.peak.prd.common.webpage.model.Userwebpage;
import com.peak.prd.common.webpage.service.IUserwebpagePlusService;
import com.peak.prd.common.webpage.service.IWebpagePlusService;
import com.peak.prd.common.webpage.vo.UserwebpageQuery;
import com.peak.prd.common.webpage.vo.UserwebpageVO;
import com.peak.prd.common.webpage.vo.WebpageVO;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserwebpagePlusService
extends PrdBaseService<Userwebpage, Long, UserwebpageQuery>
implements IUserwebpagePlusService {
    @Resource
    private IUserwebpagePlusDao userwebpagePlusDao;
    @Resource
    private IWebpagePlusService webpagePlusService;

    public IEntityDao<Userwebpage, Long, UserwebpageQuery> getEntityDao() {
        return this.userwebpagePlusDao;
    }

    @Override
    @Transactional
    public void enter(Long userId, Long webpageId) {
        Date now = new Date();
        Userwebpage userwebpage = new Userwebpage();
        userwebpage.setUserId(userId);
        userwebpage.setWebpageId(webpageId);
        userwebpage.setLasttime(now);
        Integer updatenum = this.userwebpagePlusDao.updateViews(userwebpage);
        if (updatenum == 0) {
            userwebpage.setUserwebpageId(IdUtil.getSequence((String)"COMMON_USERWEBPAGE"));
            userwebpage.setFirsttime(now);
            userwebpage.setViews(1);
            this.userwebpagePlusDao.insert((BaseEntity)userwebpage);
            JSONObject msgObj = new JSONObject();
            msgObj.put("userId", (Object)userId);
            msgObj.put("webpageId", (Object)webpageId);
            MessageQHelper.send((String)"userwebpage", (Long)userwebpage.getUserwebpageId(), (String)"enterpass", (Object)msgObj);
        }
    }

    @Override
    public UserwebpageVO getVOInfo(Long userId, Long webpageId) {
        Userwebpage userwebpage = this.userwebpagePlusDao.getByUserIdWebpageId(userId, webpageId);
        UserwebpageVO userwebpageVO = (UserwebpageVO)ConvertUtil.convert((Object)userwebpage, UserwebpageVO.class);
        if (userwebpageVO == null) {
            userwebpageVO = new UserwebpageVO();
        }
        WebpageVO webpageVO = this.webpagePlusService.getStuInfo(webpageId);
        userwebpageVO.setWebpageVO(webpageVO);
        return userwebpageVO;
    }

    @Override
    public Long getViewsCount(Long webpageId) {
        UserwebpageQuery query = new UserwebpageQuery();
        query.setWebpageId(webpageId);
        return this.userwebpagePlusDao.count(query);
    }
}

