/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.webpage.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.webpage.bo.WebpageBO;
import com.peak.prd.common.webpage.bo.WebpageQueryBO;
import com.peak.prd.common.webpage.dao.IWebpagePlusDao;
import com.peak.prd.common.webpage.model.Webpage;
import com.peak.prd.common.webpage.service.IWebpagePlusService;
import com.peak.prd.common.webpage.vo.WebpageQuery;
import com.peak.prd.common.webpage.vo.WebpageVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class WebpagePlusService
extends PrdBaseService<Webpage, Long, WebpageQuery>
implements IWebpagePlusService {
    @Resource
    private IWebpagePlusDao webpagePlusDao;

    public IEntityDao<Webpage, Long, WebpageQuery> getEntityDao() {
        return this.webpagePlusDao;
    }

    @Override
    public Long insert(Long userId, WebpageBO webpageBO) {
        Webpage webpage = (Webpage)ConvertUtil.convert((Object)webpageBO, Webpage.class);
        Long webpageId = IdUtil.getSequence((String)"COMMON_WEBPAGE");
        webpage.setWebpageId(webpageId);
        Date now = new Date();
        webpage.setCreatorId(userId);
        webpage.setCreatedate(now);
        webpage.setUpdaterId(userId);
        webpage.setUpdatedate(now);
        webpage.setDeleted(0);
        this.webpagePlusDao.insert((BaseEntity)webpage);
        return webpageId;
    }

    @Override
    @ClearCache(value="#webpageBO.webpageId")
    public Integer update(Long userId, WebpageBO webpageBO) {
        Webpage webpage = (Webpage)ConvertUtil.convert((Object)webpageBO, Webpage.class);
        webpage.setUpdaterId(userId);
        webpage.setUpdatedate(new Date());
        return this.webpagePlusDao.update(webpage);
    }

    @Override
    @ClearCache(value="#webpageId")
    public Integer delete(Long userId, Long webpageId) {
        Date now = new Date();
        Webpage webpage = new Webpage(webpageId);
        webpage.setUpdaterId(userId);
        webpage.setUpdatedate(now);
        webpage.setDeleted(1);
        webpage.setDeletedate(now);
        return this.webpagePlusDao.updateSelective(webpage);
    }

    @Override
    public WebpageVO getMngInfo(Long webpageId) {
        Webpage webpage = (Webpage)this.getById(webpageId);
        return (WebpageVO)ConvertUtil.convert((Object)webpage, WebpageVO.class);
    }

    @Override
    public WebpageVO getByBusinessIdBusinessType(Long businessId, Integer businessType) {
        Webpage webpage = this.webpagePlusDao.getByBusinessIdBusinessType(businessId, businessType);
        return (WebpageVO)ConvertUtil.convert((Object)webpage, WebpageVO.class);
    }

    @Override
    public List<WebpageVO> getVOList(WebpageQueryBO webpageQueryBO) {
        WebpageQuery query = new WebpageQuery(webpageQueryBO.getPageNumber(), webpageQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)webpageQueryBO), (Object)query);
        query.getPage().setSortColumns("cwep.CREATEDATE DESC");
        List webpageList = this.webpagePlusDao.findList(query);
        return ConvertUtil.convert((List)webpageList, WebpageVO.class);
    }

    @Override
    @Cacheable
    public List<WebpageVO> findVOList(WebpageQueryBO webpageQueryBO) {
        return this.getVOList(webpageQueryBO);
    }

    @Override
    @Cacheable
    public WebpageVO getStuInfo(Long webpageId) {
        return this.getMngInfo(webpageId);
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'WebpagePlusService:' + #webpageId"), @CacheEvict(cacheNames={"prd"}, key="'WebpagePlusService:WebpageVO:' + #webpageId")})
    public void clearCache(Long webpageId) {
    }
}

