/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.enroll.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.busiaudi.service.IBusiaudiPlusService;
import com.peak.prd.enroll.enroll.bo.EnrollEnrollBO;
import com.peak.prd.enroll.enroll.dao.IEnrollEnrollPlusDao;
import com.peak.prd.enroll.enroll.model.EnrollEnroll;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollMngVO;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollQuery;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollStuVO;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollVO;
import com.peak.prd.enroll.enroll.vo.EnrollingVO;
import com.peak.prd.enroll.scope.service.IEnrollScopePlusService;
import com.peak.prd.enroll.scope.vo.EnrollScopeVO;
import com.peak.prd.enroll.user.model.EnrollUser;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enroll.user.vo.EnrollUserVO;
import com.peak.prd.enums.BcResponseStatusEnum;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.inc.IncPublishScope;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class EnrollEnrollPlusService
extends PrdBaseService<EnrollEnroll, Long, EnrollEnrollQuery>
implements IEnrollEnrollPlusService {
    @Resource
    private IEnrollScopePlusService enrollScopePlusService;
    @Resource
    private IBusiaudiPlusService busiaudiPlusService;
    @Resource
    private IEnrollUserPlusService enrollUserPlusService;
    @Resource
    @Lazy
    private IEnrollEnrollPlusService self;
    private IEnrollEnrollPlusDao enrollEnrollPlusDao;

    public void setEnrollEnrollPlusDao(IEnrollEnrollPlusDao dao) {
        this.enrollEnrollPlusDao = dao;
    }

    public IEnrollEnrollPlusDao getEnrollEnrollPlusDao() {
        return this.enrollEnrollPlusDao;
    }

    public IEntityDao<EnrollEnroll, Long, EnrollEnrollQuery> getEntityDao() {
        return this.enrollEnrollPlusDao;
    }

    @Override
    public Long txInsert(Long userId, Long domianId, EnrollEnrollBO enrollEnrollBO) {
        EnrollEnroll enrollEnroll = (EnrollEnroll)ConvertUtil.convert((Object)enrollEnrollBO, EnrollEnroll.class);
        Long enrollId = IdUtil.getSequence((String)"ENROLL_ENROLL");
        enrollEnroll.setEnrollId(enrollId);
        enrollEnroll.setDomainId(domianId);
        enrollEnroll.setCreatorId(userId);
        enrollEnroll.setCreatedate(new Date());
        this.enrollEnrollPlusDao.insertSelective((BaseEntity)enrollEnroll);
        if (ListUtil.notNullorEmpty(enrollEnrollBO.getEnrollScopeBOList())) {
            this.enrollScopePlusService.insertBatch(userId, domianId, enrollId, enrollEnrollBO.getEnrollScopeBOList());
        }
        this.sendEnrollPublishMessage(enrollEnroll);
        return enrollId;
    }

    @Override
    public Long txUpdate(EnrollEnrollBO enrollEnrollBO, Long userId, Long mngDomainId) {
        if (enrollEnrollBO.getEnrollId() == null) {
            return this.txInsert(userId, mngDomainId, enrollEnrollBO);
        }
        this.clearCache(enrollEnrollBO.getEnrollId(), enrollEnrollBO.getRelativeId(), enrollEnrollBO.getType());
        EnrollEnroll enrollEnroll = (EnrollEnroll)ConvertUtil.convert((Object)enrollEnrollBO, EnrollEnroll.class);
        if (ListUtil.notNullorEmpty(enrollEnrollBO.getEnrollScopeBOList())) {
            EnrollEnroll enroll = (EnrollEnroll)this.getById(enrollEnroll.getEnrollId());
            this.enrollScopePlusService.updateBatch(enroll.getCreatorId(), enroll.getDomainId(), enrollEnroll.getEnrollId(), enrollEnrollBO.getEnrollScopeBOList());
        }
        int updateNum = this.enrollEnrollPlusDao.updateSelective(enrollEnroll);
        this.sendEnrollPublishMessage(enrollEnroll);
        return updateNum;
    }

    private void sendEnrollPublishMessage(EnrollEnroll enrollEnroll) {
        this.sendEnrollPublishMessage(enrollEnroll.getRelativeId(), enrollEnroll.getType(), enrollEnroll.getStatus());
    }

    private void sendEnrollPublishMessage(Long businessId, Integer businesstype, Integer status) {
        if (businessId == null || businesstype == null || status == null) {
            return;
        }
        if (status == 1) {
            JSONObject jObj = new JSONObject();
            jObj.put("businessId", (Object)businessId);
            jObj.put("businesstype", (Object)businesstype);
            MessageQHelper.send((String)"enroll", (Long)businessId, (String)"publish", (Object)jObj);
        }
    }

    @Override
    public EnrollEnrollVO getInfo(Long relativeId, Integer type) {
        EnrollEnrollQuery query = new EnrollEnrollQuery(1, 1);
        query.setType(type);
        query.setRelativeId(relativeId);
        EnrollEnroll enrollEnroll = (EnrollEnroll)this.enrollEnrollPlusDao.findOne(query);
        if (enrollEnroll == null) {
            return new EnrollEnrollVO();
        }
        EnrollEnrollVO enrollEnrollVO = (EnrollEnrollVO)ConvertUtil.convert((Object)enrollEnroll, EnrollEnrollVO.class);
        List<EnrollScopeVO> enrollScopeVOList = this.enrollScopePlusService.getVOList(enrollEnroll.getEnrollId());
        enrollEnrollVO.setEnrollScopeVOList(enrollScopeVOList);
        return enrollEnrollVO;
    }

    @Override
    @Cacheable(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':EnrollEnrollVO:' + #relativeId + ':' + #type")
    public EnrollEnrollVO findInfo(Long relativeId, Integer type) {
        return this.getInfo(relativeId, type);
    }

    @Override
    public List<EnrollingVO> getEnrollingList(Integer type, Long userId) {
        EnrollEnrollQuery enrollEnrollQuery = new EnrollEnrollQuery();
        enrollEnrollQuery.setType(type);
        enrollEnrollQuery.setUserId(userId);
        IncPublishScope incPublishScope = new IncPublishScope();
        incPublishScope.setIncOrgIds(UserCoreUtil.getAllDomainIdsAndFullOrgIds((Long)userId));
        incPublishScope.setIncbusinesstype(Integer.valueOf(BusinessOrigin.ENROLL.getIndex()));
        enrollEnrollQuery.setIncPublishScope(incPublishScope);
        enrollEnrollQuery.getPage().setSortColumns("ee.begintime desc");
        enrollEnrollQuery.getPage().setPageNumber(1);
        enrollEnrollQuery.getPage().setPageSize(Integer.MAX_VALUE);
        List enrollingVOList = this.getEnrollEnrollPlusDao().findList(enrollEnrollQuery, "findEnrollingList", EnrollingVO.class);
        this.fillEnrollingVOList(enrollingVOList, userId);
        return enrollingVOList;
    }

    @Override
    public List<EnrollingVO> getTpEnrollingList(Long userId, String statuses) {
        EnrollEnrollQuery enrollEnrollQuery = new EnrollEnrollQuery();
        enrollEnrollQuery.setType(BusinessOrigin.TRAINPROJECT.getIndex());
        if (!StringUtil.isNullorEmptyStr((String)statuses)) {
            enrollEnrollQuery.setTpStatusList(StringUtil.splitToIntList((String)statuses, (String)","));
        } else {
            enrollEnrollQuery.setTpStatusList(Arrays.asList(4));
        }
        enrollEnrollQuery.setUserId(userId);
        IncPublishScope incPublishScope = new IncPublishScope();
        incPublishScope.setIncOrgIds(UserCoreUtil.getAllDomainIdsAndFullOrgIds((Long)userId));
        incPublishScope.setIncbusinesstype(Integer.valueOf(BusinessOrigin.ENROLL.getIndex()));
        enrollEnrollQuery.setIncPublishScope(incPublishScope);
        enrollEnrollQuery.getPage().setSortColumns("ee.begintime desc");
        enrollEnrollQuery.getPage().setPageNumber(1);
        enrollEnrollQuery.getPage().setPageSize(Integer.MAX_VALUE);
        List enrollingVOList = this.getEnrollEnrollPlusDao().findList(enrollEnrollQuery, "findTpEnrollingList", EnrollingVO.class);
        this.fillEnrollingVOList(enrollingVOList, userId);
        return enrollingVOList;
    }

    private void fillEnrollingVOList(List<EnrollingVO> enrollingVOList, Long userId) {
        List<EnrollUser> enrollUserList = this.enrollUserPlusService.getListByUserId(userId);
        Map<Long, List<EnrollUser>> enrollUserMap = enrollUserList.stream().collect(Collectors.groupingBy(EnrollUser::getEnrollId));
        for (EnrollingVO enrollingVO : enrollingVOList) {
            List<EnrollUser> enrollUsers = enrollUserMap.get(enrollingVO.getEnrollEnrollVO().getEnrollId());
            if (ListUtil.isNullorEmpty(enrollUsers)) continue;
            EnrollUserVO enrollUserVO = new EnrollUserVO();
            enrollUserVO.setUserId(userId);
            enrollUserVO.setStatus(enrollUsers.get(0).getStatus());
            enrollingVO.setEnrollUserVO(enrollUserVO);
        }
    }

    @Override
    public List<EnrollingVO> getEnrollSuccessList(Integer type, Long userId) {
        EnrollEnrollQuery enrollEnrollQuery = new EnrollEnrollQuery();
        enrollEnrollQuery.setType(type);
        enrollEnrollQuery.setUserId(userId);
        enrollEnrollQuery.setEndtimeBegin(DateUtils.addYears((Date)new Date(), (int)-1));
        IncPublishScope incPublishScope = new IncPublishScope();
        incPublishScope.setIncOrgIds(UserCoreUtil.getAllDomainIdsAndFullOrgIds((Long)userId));
        incPublishScope.setIncbusinesstype(Integer.valueOf(BusinessOrigin.ENROLL.getIndex()));
        enrollEnrollQuery.setIncPublishScope(incPublishScope);
        enrollEnrollQuery.getPage().setSortColumns("ee.begintime desc");
        enrollEnrollQuery.getPage().setPageNumber(1);
        enrollEnrollQuery.getPage().setPageSize(Integer.MAX_VALUE);
        List enrollingVOList = this.getEnrollEnrollPlusDao().findList(enrollEnrollQuery, "findEnrollSuccessList", EnrollingVO.class);
        return enrollingVOList;
    }

    @Override
    @Cacheable(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':EnrollEnrollStuVO:' + #businessId + ':' + #businessType")
    public EnrollEnrollStuVO findStuVOInfo(Long businessId, Integer businessType) {
        EnrollEnrollQuery query = new EnrollEnrollQuery(1, 1);
        query.setType(businessType);
        query.setRelativeId(businessId);
        return (EnrollEnrollStuVO)ConvertUtil.convert((Object)this.enrollEnrollPlusDao.findOne(query), EnrollEnrollStuVO.class);
    }

    @Override
    public Integer rename(Long businessId, Integer businesstype, String title) {
        EnrollEnrollVO enrollEnrollVO = this.getInfo(businessId, businesstype);
        if (enrollEnrollVO == null || enrollEnrollVO.getEnrollId() == null) {
            return 0;
        }
        this.clearCache(enrollEnrollVO.getEnrollId(), businessId, businesstype);
        EnrollEnroll enrollEnroll = new EnrollEnroll();
        enrollEnroll.setEnrollId(enrollEnrollVO.getEnrollId());
        enrollEnroll.setTitle(title);
        return this.getEnrollEnrollPlusDao().updateSelective(enrollEnroll);
    }

    @Override
    public Long txCopy(Long enrollId, Long businessId, String title, Integer status, Long creatorId, Long domainId) {
        EnrollEnroll enrollEnrollOld = (EnrollEnroll)this.getEnrollEnrollPlusDao().getById(enrollId);
        if (enrollEnrollOld == null) {
            return null;
        }
        EnrollEnrollVO enrollEnrollVO = this.getInfo(businessId, enrollEnrollOld.getType());
        if (enrollEnrollVO != null && enrollEnrollVO.getEnrollId() != null) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_COPY_EXISTS);
        }
        EnrollEnroll enrollEnroll = (EnrollEnroll)ConvertUtil.convert((Object)enrollEnrollOld, EnrollEnroll.class);
        enrollEnroll.setEnrollId(IdUtil.getSequence((String)"ENROLL_ENROLL"));
        if (domainId != null) {
            enrollEnroll.setDomainId(domainId);
        }
        enrollEnroll.setRelativeId(businessId);
        if (!StringUtil.isNullorEmptyStr((String)title)) {
            enrollEnroll.setTitle(title);
        }
        if (status != null) {
            enrollEnroll.setStatus(status);
        }
        if (creatorId != null) {
            enrollEnroll.setCreatorId(creatorId);
        }
        enrollEnroll.setCreatedate(new Date());
        this.getEnrollEnrollPlusDao().insertSelective((BaseEntity)enrollEnroll);
        this.enrollScopePlusService.copy(enrollId, enrollEnroll.getEnrollId(), businessId, creatorId);
        this.sendEnrollPublishMessage(enrollEnroll);
        this.busiaudiPlusService.copy(enrollEnrollOld.getEnrollId(), BusinessOrigin.ENROLL.getIndex(), enrollEnroll.getEnrollId(), creatorId);
        this.busiaudiPlusService.sendBusiaudiChangeMesssage(enrollEnroll.getEnrollId(), BusinessOrigin.ENROLL.getIndex());
        return enrollEnroll.getEnrollId();
    }

    @Override
    public EnrollEnroll getByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        EnrollEnrollQuery query = new EnrollEnrollQuery(1, 1);
        query.setType(businesstype);
        query.setRelativeId(businessId);
        EnrollEnroll enrollEnroll = (EnrollEnroll)this.enrollEnrollPlusDao.findOne(query);
        return enrollEnroll;
    }

    @Override
    public Integer deleteByBusinessIdAndBusinesstype(Long businessId, Integer businesstype) {
        EnrollEnroll enrollEnroll = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (enrollEnroll == null) {
            return 0;
        }
        this.clearCache(enrollEnroll.getEnrollId(), businessId, businesstype);
        return this.getEnrollEnrollPlusDao().deleteById(enrollEnroll.getEnrollId());
    }

    @Override
    public List<EnrollEnroll> getValidEnrollList() {
        Date now = new Date();
        EnrollEnrollQuery enrollEnrollQuery = new EnrollEnrollQuery();
        enrollEnrollQuery.setBegintimeEnd(now);
        enrollEnrollQuery.setEndtimeBegin(now);
        enrollEnrollQuery.setRegistration(0);
        enrollEnrollQuery.setStatus(1);
        List enrollEnrollList = this.getEnrollEnrollPlusDao().findAll(enrollEnrollQuery);
        if (ListUtil.isNullorEmpty((List)enrollEnrollList)) {
            return new ArrayList<EnrollEnroll>();
        }
        return enrollEnrollList;
    }

    @Override
    public Integer closeEnroll(Long businessId, Integer businesstype) {
        EnrollEnroll enrollEnrollOri = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (enrollEnrollOri == null) {
            return 0;
        }
        this.clearCache(enrollEnrollOri.getEnrollId(), businessId, businesstype);
        EnrollEnroll enrollEnroll = new EnrollEnroll();
        enrollEnroll.setEnrollId(enrollEnrollOri.getEnrollId());
        enrollEnroll.setStatus(0);
        int updateNum = this.getEnrollEnrollPlusDao().updateSelective(enrollEnroll);
        this.sendEnrollPublishMessage(enrollEnrollOri.getRelativeId(), enrollEnrollOri.getType(), enrollEnroll.getStatus());
        return updateNum;
    }

    @Override
    public Integer updateStatusByBusinessNotSendMessage(Long businessId, Integer businesstype, Integer status) {
        EnrollEnroll enrollEnrollOri = this.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (enrollEnrollOri == null) {
            return 0;
        }
        EnrollEnroll enrollEnroll = new EnrollEnroll();
        enrollEnroll.setEnrollId(enrollEnrollOri.getEnrollId());
        enrollEnroll.setStatus(status);
        int updateNum = this.getEnrollEnrollPlusDao().updateSelective(enrollEnroll);
        return updateNum;
    }

    private void clearCache(Long enrollId, Long businessId, Integer businesstype) {
        this.self.clearCache(enrollId);
        this.self.clearCacheByBusiness(businessId, businesstype);
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':EnrollEnrollVO:' + #businessId + ':' + #businesstype"), @CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':EnrollEnrollStuVO:' + #businessId + ':' + #businesstype")})
    public void clearCacheByBusiness(Long businessId, Integer businesstype) {
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':' + #id"), @CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':EnrollEnrollMngVO:' + #id")})
    public void clearCache(Long id) {
    }

    public <VO> VO getVOById(Long enrollId, Class<VO> clazz) {
        EnrollEnroll enrollEnroll = (EnrollEnroll)this.findById(enrollId);
        if (enrollEnroll == null) {
            return null;
        }
        Object vo = ConvertUtil.convert((Object)enrollEnroll, clazz);
        if (clazz.equals(EnrollEnrollMngVO.class)) {
            ((EnrollEnrollMngVO)vo).setDomainName(OrgUtil.getOrgVO((Long)((EnrollEnrollMngVO)vo).getDomainId()).getOrgname());
        }
        return (VO)vo;
    }
}

