/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.scope.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.org.model.Org;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enroll.enroll.model.EnrollEnroll;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollMngVO;
import com.peak.prd.enroll.scope.bo.EnrollScopeBO;
import com.peak.prd.enroll.scope.bo.EnrollScopeQueryBO;
import com.peak.prd.enroll.scope.dao.IEnrollScopePlusDao;
import com.peak.prd.enroll.scope.imp.model.EnrollScopeImportExcelModel;
import com.peak.prd.enroll.scope.model.EnrollScope;
import com.peak.prd.enroll.scope.service.IEnrollScopePlusService;
import com.peak.prd.enroll.scope.vo.EnrollScopeExcelResultVO;
import com.peak.prd.enroll.scope.vo.EnrollScopeMngVO;
import com.peak.prd.enroll.scope.vo.EnrollScopeQuery;
import com.peak.prd.enroll.scope.vo.EnrollScopeVO;
import com.peak.prd.enums.BcResponseStatusEnum;
import com.peak.prd.enums.EnrollScopeEnum;
import com.peak.prd.exception.PrdBaseException;
import com.peak.tools.easyexcel.model.ExcelResultVO;
import com.peak.tools.easyexcel.util.ExcelReadUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EnrollScopePlusService
extends PrdBaseService<EnrollScope, Long, EnrollScopeQuery>
implements IEnrollScopePlusService {
    @Autowired
    @Lazy
    private IEnrollEnrollPlusService enrollEnrollPlusService;
    @Autowired
    private IOrgPlusService orgPlusService;
    private IEnrollScopePlusDao enrollScopePlusDao;

    public void setEnrollScopePlusDao(IEnrollScopePlusDao dao) {
        this.enrollScopePlusDao = dao;
    }

    public IEnrollScopePlusDao getEnrollScopePlusDao() {
        return this.enrollScopePlusDao;
    }

    public IEntityDao<EnrollScope, Long, EnrollScopeQuery> getEntityDao() {
        return this.enrollScopePlusDao;
    }

    @Override
    public Long insert(@NotNull Long userId, @NotNull Long domainId, @NotNull Long enrollId, @NotNull EnrollScopeBO enrollScopeBO) {
        EnrollScope enrollScope = this.getEnrollScope(userId, domainId, enrollId, enrollScopeBO);
        this.enrollScopePlusDao.insert((BaseEntity)enrollScope);
        return enrollScope.getEnrollscopeId();
    }

    @Override
    public Integer insertBatch(@NotNull Long userId, @NotNull Long domainId, @NotNull Long enrollId, @NotEmpty List<EnrollScopeBO> enrollScopeBOList) {
        ArrayList<EnrollScope> enrollScopeList = new ArrayList<EnrollScope>();
        for (EnrollScopeBO enrollScopeBO : enrollScopeBOList) {
            enrollScopeList.add(this.getEnrollScope(userId, domainId, enrollId, enrollScopeBO));
        }
        return this.insertBatch(enrollScopeList);
    }

    @Override
    public Integer updateBatch(@NotNull Long userId, @NotNull Long domainId, @NotNull Long enrollId, @NotEmpty List<EnrollScopeBO> enrollScopeBOList) {
        this.enrollScopePlusDao.deleteByEnrollId(enrollId);
        return this.insertBatch(userId, domainId, enrollId, enrollScopeBOList);
    }

    private EnrollScope getEnrollScope(Long userId, Long domainId, Long enrollId, EnrollScopeBO enrollScopeBO) {
        EnrollScope enrollScope = (EnrollScope)ConvertUtil.convert((Object)enrollScopeBO, EnrollScope.class);
        enrollScope.setEnrollscopeId(IdUtil.getSequence((String)"ENROLL_SCOPE"));
        enrollScope.setEnrollId(enrollId);
        enrollScope.setCreatordomainId(domainId);
        enrollScope.setCreatorId(userId);
        enrollScope.setCreatedate(new Date());
        return enrollScope;
    }

    @Override
    public List<EnrollScopeVO> getVOList(@NotNull Long enrollId) {
        EnrollScopeQuery query = new EnrollScopeQuery();
        query.setEnrollId(enrollId);
        query.getPage().setSortColumns(" es.CREATEDATE ");
        List enrollScopeList = this.enrollScopePlusDao.findAll(query);
        if (ListUtil.isNullorEmpty((List)enrollScopeList)) {
            return new ArrayList<EnrollScopeVO>();
        }
        List enrollScopeVOList = ConvertUtil.convert((List)enrollScopeList, EnrollScopeVO.class);
        OrgUtil.setOrgName((List)enrollScopeVOList, EnrollScopeVO::getEntityId, EnrollScopeVO::setEntityName);
        UserCoreUtil.setUserVO((List)enrollScopeVOList, EnrollScopeVO::getCreatorId, EnrollScopeVO::setUserVO);
        return enrollScopeVOList;
    }

    @Override
    public Paging<EnrollScopeMngVO> getMngVOList(EnrollScopeQueryBO enrollScopeQueryBO, Long domainId) {
        EnrollScopeQuery enrollScopeQuery = (EnrollScopeQuery)ConvertUtil.convert((Object)((Object)enrollScopeQueryBO), EnrollScopeQuery.class);
        enrollScopeQuery.setDomainId(domainId);
        enrollScopeQuery.getPage().setSortColumns("ee.begintime desc");
        Paging enrollScopeMngVOPaging = this.getEnrollScopePlusDao().findPaging(enrollScopeQuery, "getMngVOList", EnrollScopeMngVO.class);
        if (ListUtil.isNullorEmpty((List)enrollScopeMngVOPaging.getList())) {
            return enrollScopeMngVOPaging;
        }
        for (EnrollScopeMngVO enrollScopeMngVO : enrollScopeMngVOPaging.getList()) {
            EnrollEnrollMngVO enrollEnrollMngVO = (EnrollEnrollMngVO)this.enrollEnrollPlusService.findVOById(enrollScopeMngVO.getEnrollId(), EnrollEnrollMngVO.class);
            enrollScopeMngVO.setEnrollEnrollMngVO(enrollEnrollMngVO);
        }
        return enrollScopeMngVOPaging;
    }

    @Override
    public EnrollScope getByEnrollIdAndEntityIdAndEntityTypes(Long enrollId, Long entityId, List<Integer> entitytypeList) {
        EnrollScopeQuery enrollScopeQuery = new EnrollScopeQuery();
        enrollScopeQuery.setEnrollId(enrollId);
        enrollScopeQuery.setEntityId(entityId);
        enrollScopeQuery.setEntitytypeList(entitytypeList);
        List enrollScopeList = this.getEnrollScopePlusDao().findAll(enrollScopeQuery);
        if (ListUtil.isNullorEmpty((List)enrollScopeList)) {
            return null;
        }
        return (EnrollScope)enrollScopeList.get(0);
    }

    @Override
    public List<EnrollScope> getListByEnrollIdAndEntityTypes(Long enrollId, List<Integer> entitytypeList) {
        EnrollScopeQuery enrollScopeQuery = new EnrollScopeQuery();
        enrollScopeQuery.setEnrollId(enrollId);
        enrollScopeQuery.setEntitytypeList(entitytypeList);
        List enrollScopeList = this.getEnrollScopePlusDao().findAll(enrollScopeQuery);
        return enrollScopeList;
    }

    @Override
    public Integer updateEnrollednumAndFinished(EnrollScope enrollScopeOri, Integer changeNum) {
        int limitnum = enrollScopeOri.getLimitnum() == null ? 0 : enrollScopeOri.getLimitnum();
        int enrollednum = enrollScopeOri.getEnrollednum() == null ? 0 : enrollScopeOri.getEnrollednum();
        EnrollScope enrollScope = new EnrollScope();
        enrollScope.setEnrollscopeId(enrollScopeOri.getEnrollscopeId());
        enrollScope.setEnrollednum(enrollednum + changeNum < 0 ? 0 : enrollednum + changeNum);
        enrollScope.setFinished(enrollednum + changeNum < limitnum ? 0 : 1);
        return this.getEnrollScopePlusDao().updateSelective(enrollScope);
    }

    @Override
    public EnrollScopeExcelResultVO txImportList(Long enrollId, String excelfilepath, Long userId, Long domainId) {
        ExcelReadUtil excelReadUtil = new ExcelReadUtil();
        EnrollEnroll enrollEnroll = null;
        List<EnrollScope> enrollScopeList = null;
        List existOrgIdList = null;
        if (enrollId != null) {
            enrollEnroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollId);
            if (enrollEnroll == null) {
                ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_EXISTS);
            }
            enrollScopeList = this.getListByEnrollIdAndEntityTypes(enrollId, Arrays.asList(EnrollScopeEnum.ORG.getValue()));
            existOrgIdList = IdUtil.getIds(enrollScopeList, EnrollScope::getEntityId);
        }
        List validOrgVOList = this.orgPlusService.findSon(domainId);
        List<Org> validOrgList = validOrgVOList.stream().map(orgVO -> (Org)this.orgPlusService.findById((Object)orgVO.getOrgId())).collect(Collectors.toList());
        ArrayList<EnrollScopeVO> enrollScopeVOList = new ArrayList<EnrollScopeVO>();
        ArrayList<Long> importOrgList = new ArrayList<Long>();
        try {
            List readDataList;
            int firstDataRowIndex = 2;
            for (int pageNumber = 1; (readDataList = excelReadUtil.getExcelReadData(excelfilepath, EnrollScopeImportExcelModel.class, firstDataRowIndex, pageNumber)) != null && readDataList.size() != 0 && pageNumber <= 5000; ++pageNumber) {
                Date now = new Date();
                for (int rowIndex = 0; rowIndex < readDataList.size(); ++rowIndex) {
                    EnrollScopeImportExcelModel enrollScopeImportExcelModel = (EnrollScopeImportExcelModel)((Object)readDataList.get(rowIndex));
                    try {
                        EnrollScope enrollScope = this.validateExcelData(enrollScopeImportExcelModel, enrollId, userId, domainId, now, existOrgIdList, validOrgList, importOrgList, excelReadUtil, pageNumber, rowIndex);
                        if (enrollScope == null) continue;
                        enrollScopeVOList.add((EnrollScopeVO)ConvertUtil.convert((Object)enrollScope, EnrollScopeVO.class));
                        importOrgList.add(enrollScope.getEntityId());
                        continue;
                    }
                    catch (Exception e) {
                        enrollScopeImportExcelModel.setExcelImportErrorMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff01\uff01");
                        excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber, rowIndex);
                    }
                }
            }
        }
        catch (PrdBaseException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        ExcelResultVO excelResultVO = excelReadUtil.getExcelResultVO(EnrollScopeImportExcelModel.class);
        EnrollScopeExcelResultVO enrollScopeExcelResultVO = (EnrollScopeExcelResultVO)ConvertUtil.convert((Object)excelResultVO, EnrollScopeExcelResultVO.class);
        OrgUtil.setOrgName(enrollScopeVOList, EnrollScopeVO::getEntityId, EnrollScopeVO::setEntityName);
        UserCoreUtil.setUserVO(enrollScopeVOList, EnrollScopeVO::getCreatorId, EnrollScopeVO::setUserVO);
        enrollScopeExcelResultVO.setEnrollScopeVOList(enrollScopeVOList);
        return enrollScopeExcelResultVO;
    }

    @Override
    public Integer copy(Long enrollId, Long copyEnrollId, Long businessId, Long creatorId) {
        if (businessId == null) {
            EnrollEnroll copyEnrollEnroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(copyEnrollId);
            if (copyEnrollEnroll == null) {
                return 0;
            }
            businessId = copyEnrollEnroll.getRelativeId();
            if (creatorId == null) {
                creatorId = copyEnrollEnroll.getCreatorId();
            }
        }
        EnrollScopeQuery enrollScopeQuery = new EnrollScopeQuery();
        enrollScopeQuery.setEnrollId(enrollId);
        List enrollScopeList = this.getEnrollScopePlusDao().findAll(enrollScopeQuery);
        if (ListUtil.isNullorEmpty((List)enrollScopeList)) {
            return 0;
        }
        List insertList = ConvertUtil.convert((List)enrollScopeList, EnrollScope.class);
        Date now = new Date();
        for (EnrollScope enrollScope : insertList) {
            enrollScope.setEnrollscopeId(IdUtil.getSequence((String)"ENROLL_SCOPE"));
            enrollScope.setEnrollId(copyEnrollId);
            enrollScope.setEntityId(businessId);
            if (creatorId != null) {
                enrollScope.setCreatorId(creatorId);
            }
            enrollScope.setCreatedate(now);
            enrollScope.setEnrollednum(0);
            enrollScope.setFinished(0);
        }
        return this.getEnrollScopePlusDao().insertBatch(insertList);
    }

    private EnrollScope validateExcelData(EnrollScopeImportExcelModel enrollScopeImportExcelModel, Long enrollId, Long userId, Long domainId, Date now, List<Long> existOrgIdList, List<Org> validOrgList, List<Long> importOrgList, ExcelReadUtil excelReadUtil, Integer pageNumber, Integer rowIndex) {
        if (StringUtil.isNullorEmptyStr((String)enrollScopeImportExcelModel.getOrgcode()) && StringUtil.isNullorEmptyStr((String)enrollScopeImportExcelModel.getOrgname())) {
            enrollScopeImportExcelModel.setExcelImportErrorMessage("\u8bf7\u586b\u5199\u673a\u6784\u7f16\u53f7\u6216\u673a\u6784\u540d\u79f0");
            excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
            return null;
        }
        Org importOrg = null;
        if (!StringUtil.isNullorEmptyStr((String)enrollScopeImportExcelModel.getOrgcode())) {
            importOrg = this.findByOrgcode(enrollScopeImportExcelModel.getOrgcode(), validOrgList);
            if (importOrg == null) {
                enrollScopeImportExcelModel.setExcelImportErrorMessage("\u5f53\u524d\u57df\u7684\u4e0b\u4e00\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u6b64\u673a\u6784\u7f16\u53f7");
                excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
                return null;
            }
            if (!StringUtil.isNullorEmptyStr((String)enrollScopeImportExcelModel.getOrgname()) && !enrollScopeImportExcelModel.getOrgname().trim().equals(importOrg.getOrgname().trim())) {
                enrollScopeImportExcelModel.setExcelImportErrorMessage("\u673a\u6784\u540d\u79f0\u4e0d\u6b63\u786e");
                excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
                return null;
            }
        } else {
            importOrg = this.findByOrgname(enrollScopeImportExcelModel.getOrgname(), validOrgList);
            if (importOrg == null) {
                enrollScopeImportExcelModel.setExcelImportErrorMessage("\u5f53\u524d\u57df\u7684\u4e0b\u4e00\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u6b64\u673a\u6784\u540d\u79f0");
                excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
                return null;
            }
        }
        if (!ListUtil.isNullorEmpty(existOrgIdList) && existOrgIdList.contains(importOrg.getOrgId())) {
            enrollScopeImportExcelModel.setExcelImportErrorMessage("\u673a\u6784\u5728\u62a5\u540d\u4e2d\u5df2\u5b58\u5728");
            excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
            return null;
        }
        if (importOrgList.contains(importOrg.getOrgId())) {
            enrollScopeImportExcelModel.setExcelImportErrorMessage("excel\u4e2d\u5df2\u7ecf\u6709\u8fd9\u4e2a\u673a\u6784\u4e86");
            excelReadUtil.addReadErrorData((Object)enrollScopeImportExcelModel, pageNumber.intValue(), rowIndex.intValue());
            return null;
        }
        EnrollScope enrollScope = new EnrollScope();
        enrollScope.setEnrollId(enrollId);
        enrollScope.setCreatorId(userId);
        enrollScope.setEntityId(importOrg.getOrgId());
        enrollScope.setEntitytype(2);
        enrollScope.setLimitnum(enrollScopeImportExcelModel.getLimitnum());
        enrollScope.setCreatordomainId(domainId);
        enrollScope.setFinished(0);
        return enrollScope;
    }

    private Org findByOrgcode(String orgcode, List<Org> validOrgList) {
        if (ListUtil.isNullorEmpty(validOrgList) || StringUtil.isNullorEmptyStr((String)orgcode)) {
            return null;
        }
        for (Org org : validOrgList) {
            if (!orgcode.equals(org.getOrgcode())) continue;
            return org;
        }
        return null;
    }

    private Org findByOrgname(String orgname, List<Org> validOrgList) {
        if (ListUtil.isNullorEmpty(validOrgList) || StringUtil.isNullorEmptyStr((String)orgname)) {
            return null;
        }
        for (Org org : validOrgList) {
            if (!orgname.equals(org.getOrgname())) continue;
            return org;
        }
        return null;
    }
}

