/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.scopeuser.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.busiaudi.service.IBusiaudiPlusService;
import com.peak.prd.common.busiaudi.util.BusiaudiUtil;
import com.peak.prd.enroll.enroll.model.EnrollEnroll;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.scopeuser.dao.IEnrollScopeUserPlusDao;
import com.peak.prd.enroll.scopeuser.model.EnrollScopeUser;
import com.peak.prd.enroll.scopeuser.service.IEnrollScopeUserPlusService;
import com.peak.prd.enroll.scopeuser.vo.EnrollScopeUserQuery;
import com.peak.prd.enroll.scopeuser.vo.EnrollScopeUserVO;
import com.peak.prd.enroll.user.model.EnrollUser;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enums.BusinessOrigin;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class EnrollScopeUserPlusService
extends PrdBaseService<EnrollScopeUser, Map<String, Object>, EnrollScopeUserQuery>
implements IEnrollScopeUserPlusService {
    @Resource
    private IBusiaudiPlusService busiaudiPlusService;
    @Resource
    private IEnrollEnrollPlusService enrollEnrollPlusService;
    @Resource
    private IEnrollUserPlusService enrollUserPlusService;
    private IEnrollScopeUserPlusDao enrollScopeUserPlusDao;

    public void setEnrollScopeUserPlusDao(IEnrollScopeUserPlusDao dao) {
        this.enrollScopeUserPlusDao = dao;
    }

    public IEnrollScopeUserPlusDao getEnrollScopeUserPlusDao() {
        return this.enrollScopeUserPlusDao;
    }

    public IEntityDao<EnrollScopeUser, Map<String, Object>, EnrollScopeUserQuery> getEntityDao() {
        return this.enrollScopeUserPlusDao;
    }

    @Override
    public boolean isExistByBusiIdBusitypeUserId(Long businessId, Integer businesstype, Long userId) {
        EnrollEnroll enrollEnroll = this.enrollEnrollPlusService.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (enrollEnroll == null) {
            return false;
        }
        return BusiaudiUtil.isInScope(userId, enrollEnroll.getEnrollId(), BusinessOrigin.ENROLL.getIndex());
    }

    @Override
    public EnrollScopeUserVO canEnroll(Long businessId, Integer businesstype, Long userId) {
        EnrollEnroll enrollEnroll = this.enrollEnrollPlusService.getByBusinessIdAndBusinesstype(businessId, businesstype);
        if (enrollEnroll == null || enrollEnroll.getStatus() == null || enrollEnroll.getStatus() != 1) {
            return null;
        }
        EnrollScopeUserVO enrollScopeUserVO = (EnrollScopeUserVO)ConvertUtil.convert((Object)enrollEnroll, EnrollScopeUserVO.class);
        if (enrollEnroll.getRegistration() == null || enrollEnroll.getRegistration() != 0) {
            enrollScopeUserVO.setCanEnroll(0);
            return enrollScopeUserVO;
        }
        EnrollUser enrollUser = this.enrollUserPlusService.getByEnrollIdAndUserId(enrollEnroll.getEnrollId(), userId);
        if (BusiaudiUtil.isInScope(userId, enrollEnroll.getEnrollId(), BusinessOrigin.ENROLL.getIndex())) {
            if (enrollUser == null) {
                enrollScopeUserVO.setCanEnroll(1);
            } else {
                enrollScopeUserVO.setCanEnroll(0);
                enrollScopeUserVO.setEnrollStatus(enrollUser.getStatus());
            }
        } else {
            enrollScopeUserVO.setCanEnroll(0);
        }
        return enrollScopeUserVO;
    }
}

