/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.user.dao.imple;

import com.peak.common.util.ListUtil;
import com.peak.prd.base.dao.imple.PrdBaseDao;
import com.peak.prd.enroll.user.dao.IEnrollUserPlusDao;
import com.peak.prd.enroll.user.model.EnrollUser;
import com.peak.prd.enroll.user.vo.EnrollUserQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class EnrollUserPlusDao
extends PrdBaseDao<EnrollUser, Long, EnrollUserQuery>
implements IEnrollUserPlusDao {
    @Override
    public List<Long> getUserIdsByEnrollId(Long enrollId) {
        if (enrollId == null) {
            return new ArrayList<Long>();
        }
        EnrollUserQuery enrollUserQuery = new EnrollUserQuery();
        enrollUserQuery.setEnrollId(enrollId);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserIdsByEnrollId", (Object)enrollUserQuery);
    }

    @Override
    public Integer batchDeleteByEnrollIdAndUserIds(Long enrollId, List<Long> userIdList) {
        if (enrollId == null || ListUtil.isNullorEmpty(userIdList)) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enrollId", enrollId);
        params.put("userIdList", userIdList);
        return this.getSqlSessionTemplate().delete(this.getNamespace() + ".batchDeleteByEnrollIdAndUserIds", params);
    }

    @Override
    public Integer updateAuditInfoByEnrollIdAndUserId(Long enrollId, Long userId, Integer status, Long auditorId, Date auditdate, String auditnote) {
        if (enrollId == null || userId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enrollId", enrollId);
        params.put("userId", userId);
        params.put("status", status);
        params.put("auditorId", auditorId);
        params.put("auditdate", auditdate);
        params.put("auditnote", auditnote);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".updateAuditInfoByEnrollIdAndUserId", params);
    }
}

