/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.user.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.rule.util.RuleUtil;
import com.peak.prd.enroll.enroll.model.EnrollEnroll;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollVO;
import com.peak.prd.enroll.scope.model.EnrollScope;
import com.peak.prd.enroll.scope.service.IEnrollScopePlusService;
import com.peak.prd.enroll.user.bo.EnrollUserAuditBO;
import com.peak.prd.enroll.user.bo.EnrollUserBO;
import com.peak.prd.enroll.user.bo.EnrollUserQueryBO;
import com.peak.prd.enroll.user.dao.IEnrollUserPlusDao;
import com.peak.prd.enroll.user.model.EnrollUser;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enroll.user.vo.EnrollUserQuery;
import com.peak.prd.enroll.user.vo.EnrollUserVO;
import com.peak.prd.enums.BcResponseStatusEnum;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.enums.EnrollEnum;
import com.peak.prd.enums.EnrollScopeEnum;
import com.peak.prd.inc.IncUser;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EnrollUserPlusService
extends PrdBaseService<EnrollUser, Long, EnrollUserQuery>
implements IEnrollUserPlusService {
    @Autowired
    private IEnrollScopePlusService enrollScopePlusService;
    private IEnrollUserPlusDao enrollUserPlusDao;
    @Autowired
    @Lazy
    IEnrollEnrollPlusService enrollEnrollPlusService;

    public void setEnrollUserPlusDao(IEnrollUserPlusDao dao) {
        this.enrollUserPlusDao = dao;
    }

    public IEnrollUserPlusDao getEnrollUserPlusDao() {
        return this.enrollUserPlusDao;
    }

    public IEntityDao<EnrollUser, Long, EnrollUserQuery> getEntityDao() {
        return this.enrollUserPlusDao;
    }

    @Override
    public Long getPassAuditNum(@NotNull Long enrollId) {
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        query.setStatusList(Arrays.asList(EnrollEnum.USER_AUDIT_STATUS_PASS.getValue(), EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue()));
        return this.enrollUserPlusDao.count(query);
    }

    @Override
    public Long getPassAuditNum(Long enrollId, List<Long> notIdUserIdList) {
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        query.setStatusList(Arrays.asList(EnrollEnum.USER_AUDIT_STATUS_PASS.getValue(), EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue()));
        query.setNotInUserIdList(notIdUserIdList);
        return this.enrollUserPlusDao.count(query);
    }

    @Override
    public Paging<EnrollUserVO> getVOList(@NotNull EnrollUserQueryBO queryBO) {
        EnrollUserQuery query = new EnrollUserQuery(queryBO.getPageNumber(), queryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)queryBO), (Object)query);
        query.getPage().setSortColumns("eu.CREATEDATE DESC");
        Paging euVOPaging = this.enrollUserPlusDao.findPaging(query, "getList", EnrollUserVO.class);
        List euVOList = euVOPaging.getList();
        if (ListUtil.isNullorEmpty((List)euVOList)) {
            return euVOPaging;
        }
        UserCoreUtil.setUserVO((List)euVOList, EnrollUserVO::getUserId, EnrollUserVO::setUserVO);
        return euVOPaging;
    }

    @Override
    public Paging<EnrollUserVO> getDomainEnrollList(EnrollUserQueryBO queryBO, Long domainId) {
        EnrollUserQuery query = (EnrollUserQuery)ConvertUtil.convert((Object)((Object)queryBO), EnrollUserQuery.class);
        if (query.getIncUser() == null) {
            query.setIncUser(new IncUser());
        }
        query.getIncUser().setOrgId(domainId);
        query.setStatus(null);
        query.setStatusList(Arrays.asList(EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue(), EnrollEnum.USER_AUDIT_STATUS_PASS.getValue()));
        query.getPage().setSortColumns("eu.CREATEDATE DESC");
        Paging euVOPaging = this.enrollUserPlusDao.findPaging(query, "getList", EnrollUserVO.class);
        List euVOList = euVOPaging.getList();
        if (ListUtil.isNullorEmpty((List)euVOList)) {
            return euVOPaging;
        }
        UserCoreUtil.setUserVO((List)euVOList, EnrollUserVO::getUserId, EnrollUserVO::setUserVO);
        return euVOPaging;
    }

    @Override
    public Long getCount(@NotNull Long enrollId) {
        EnrollEnroll enroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollId);
        if (enroll == null) {
            return 0L;
        }
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        query.setStatusList(Arrays.asList(EnrollEnum.USER_AUDIT_STATUS_PASS.getValue(), EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue()));
        return this.count(query);
    }

    @Override
    public Long getCount(Long enrollId, Long domainId) {
        EnrollEnroll enroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollId);
        if (enroll == null) {
            return 0L;
        }
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        IncUser incUser = new IncUser();
        incUser.setOrgId(domainId);
        query.setIncUser(incUser);
        if (enroll.getAudittype() != null && enroll.getAudittype() == 1) {
            query.setStatus(EnrollEnum.USER_AUDIT_STATUS_PASS.getValue());
        } else {
            query.setStatus(EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue());
        }
        return this.getEnrollUserPlusDao().count(query, "getList.count");
    }

    @Override
    public Long getRefusedCount(Long enrollId) {
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        query.setStatus(EnrollEnum.USER_AUDIT_STATUS_NOTPASS.getValue());
        return this.count(query);
    }

    @Override
    public Long getAssignedCount(Long enrollId) {
        EnrollUserQuery query = new EnrollUserQuery();
        query.setEnrollId(enrollId);
        query.setAssigned(1);
        return this.count(query);
    }

    @Override
    public Integer updateStatus(@NotNull Long auditorId, @NotNull Long enrolluserId, @NotNull Integer status) {
        EnrollUser enrollUser = (EnrollUser)this.getById(enrolluserId);
        if (enrollUser == null) {
            return 0;
        }
        EnrollEnroll enroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollUser.getEnrollId());
        this.validatedMaxNum(enroll, Arrays.asList(enrollUser.getUserId()));
        enrollUser.setStatus(status);
        enrollUser.setAuditorId(auditorId);
        enrollUser.setAuditdate(new Date());
        int updateNum = this.enrollUserPlusDao.updateSelective(enrollUser);
        this.auditMQSend(enroll, Arrays.asList(enrollUser.getUserId()), status);
        return updateNum;
    }

    @Override
    public Integer updateBatchStatus(@NotNull Long auditorId, @NotNull EnrollUserAuditBO euaBO) {
        EnrollEnroll enroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(euaBO.getEnrollId());
        if (euaBO.getStatus().intValue() != EnrollEnum.USER_AUDIT_STATUS_NOTPASS.getValue()) {
            this.validatedMaxNum(enroll, euaBO.getUserIds());
        }
        int updateNum = 0;
        Date nowdate = new Date();
        for (Long enrolluserId : euaBO.getEnrolluserIds()) {
            EnrollUser enrollUser = new EnrollUser(enrolluserId);
            enrollUser.setStatus(euaBO.getStatus());
            enrollUser.setAuditorId(auditorId);
            enrollUser.setAuditdate(nowdate);
            updateNum += this.updateSelective(enrollUser);
        }
        this.auditMQSend(enroll, euaBO.getUserIds(), euaBO.getStatus());
        return updateNum;
    }

    @Override
    public Integer insertBatch(@NotNull Long creatorId, @NotNull EnrollUserBO enrollUserBO) {
        EnrollEnroll enroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollUserBO.getEnrollId());
        List<Long> existUserIdList = this.getUserIdsByEnrollId(enrollUserBO.getEnrollId());
        List<Long> notExistUserIdList = enrollUserBO.getUserIds().stream().filter(userId -> userId != null && !existUserIdList.contains(userId)).collect(Collectors.toList());
        enrollUserBO.setUserIds(notExistUserIdList);
        this.validatedMaxNum(enroll, enrollUserBO.getUserIds().size());
        ArrayList<EnrollUser> enrollUserList = new ArrayList<EnrollUser>();
        Date nowdate = new Date();
        for (Long userId2 : enrollUserBO.getUserIds()) {
            if (enroll.getUserule() != null && enroll.getUserule() == 1 && !RuleUtil.isValidByUserId(enroll.getEnrollId(), BusinessOrigin.ENROLL.getIndex(), userId2)) {
                ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_USER_RULE_NOT_SATISFY);
            }
            EnrollUser enrollUser = new EnrollUser();
            enrollUser.setEnrolluserId(IdUtil.getSequence((String)"ENROLL_USER"));
            enrollUser.setEnrollId(enrollUserBO.getEnrollId());
            enrollUser.setUserId(userId2);
            enrollUser.setCreatorId(creatorId);
            enrollUser.setCreatedate(nowdate);
            if (enroll.getAudittype() != null && enroll.getAudittype() == 0) {
                enrollUser.setStatus(EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue());
            } else {
                enrollUser.setStatus(EnrollEnum.USER_AUDIT_STATUS_PASS.getValue());
                enrollUser.setAuditorId(creatorId);
                enrollUser.setAuditdate(nowdate);
            }
            enrollUserList.add(enrollUser);
        }
        int insertNum = this.enrollUserPlusDao.insertBatch(enrollUserList);
        this.auditMQSend(enroll, enrollUserBO.getUserIds(), EnrollEnum.USER_AUDIT_STATUS_PASS.getValue());
        return insertNum;
    }

    @Override
    public Integer insertBatchDomain(Long creatorId, EnrollUserBO enrollUserBO, Long domainId) {
        int enrollednum;
        EnrollScope enrollScopeOri;
        EnrollEnroll enrollEnroll = (EnrollEnroll)this.enrollEnrollPlusService.getById(enrollUserBO.getEnrollId());
        Date now = new Date();
        if (enrollEnroll.getBegintime() != null && enrollEnroll.getBegintime().compareTo(now) > 0 || enrollEnroll.getEndtime() != null && enrollEnroll.getEndtime().compareTo(now) < 0) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_IN_VALID_TIME);
        }
        if ((enrollScopeOri = this.enrollScopePlusService.getByEnrollIdAndEntityIdAndEntityTypes(enrollUserBO.getEnrollId(), domainId, Arrays.asList(EnrollScopeEnum.ORG.getValue()))) == null) {
            enrollScopeOri = this.enrollScopePlusService.getByEnrollIdAndEntityIdAndEntityTypes(enrollUserBO.getEnrollId(), domainId, Arrays.asList(EnrollScopeEnum.DOMAIN.getValue()));
        }
        if (enrollScopeOri == null) {
            return 0;
        }
        List<Long> existUserIdList = this.getUserIdsByEnrollId(enrollUserBO.getEnrollId());
        List<Long> notExistUserIdList = enrollUserBO.getUserIds().stream().filter(userId -> userId != null && !existUserIdList.contains(userId)).collect(Collectors.toList());
        enrollUserBO.setUserIds(notExistUserIdList);
        int limitnum = enrollScopeOri.getLimitnum() == null ? 0 : enrollScopeOri.getLimitnum();
        int n = enrollednum = enrollScopeOri.getEnrollednum() == null ? 0 : enrollScopeOri.getEnrollednum();
        if (enrollednum + enrollUserBO.getUserIds().size() > limitnum) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLLUSER_LIMITNUM_MAXERROR);
        }
        int insertNum = this.insertBatch(creatorId, enrollUserBO);
        this.enrollScopePlusService.updateEnrollednumAndFinished(enrollScopeOri, insertNum);
        return insertNum;
    }

    @Override
    public Integer deleteBatchDomain(EnrollUserBO enrollUserBO, Long domainId) {
        EnrollEnroll enrollEnroll = (EnrollEnroll)this.enrollEnrollPlusService.findById(enrollUserBO.getEnrollId());
        EnrollScope enrollScope = this.enrollScopePlusService.getByEnrollIdAndEntityIdAndEntityTypes(enrollUserBO.getEnrollId(), domainId, Arrays.asList(EnrollScopeEnum.ORG.getValue()));
        if (enrollEnroll == null) {
            enrollScope = this.enrollScopePlusService.getByEnrollIdAndEntityIdAndEntityTypes(enrollUserBO.getEnrollId(), domainId, Arrays.asList(EnrollScopeEnum.DOMAIN.getValue()));
        }
        if (enrollEnroll == null || enrollScope == null) {
            return 0;
        }
        int deleteNum = this.getEnrollUserPlusDao().batchDeleteByEnrollIdAndUserIds(enrollUserBO.getEnrollId(), enrollUserBO.getUserIds());
        this.enrollScopePlusService.updateEnrollednumAndFinished(enrollScope, -deleteNum);
        this.auditMQSend(enrollEnroll, enrollUserBO.getUserIds(), EnrollEnum.USER_AUDIT_STATUS_NOTPASS.getValue());
        return deleteNum;
    }

    @Override
    public Integer insert(@NotNull Long userId, @NotNull Long businessId, @NotNull Integer businessType) {
        EnrollEnrollVO enrollVO = this.enrollEnrollPlusService.findInfo(businessId, businessType);
        if (enrollVO.getUserule() != null && enrollVO.getUserule() == 1 && !RuleUtil.isValidByUserId(enrollVO.getEnrollId(), BusinessOrigin.ENROLL.getIndex(), userId)) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_USER_RULE_NOT_SATISFY);
        }
        this.validateEnrollDate((EnrollEnroll)ConvertUtil.convert((Object)enrollVO, EnrollEnroll.class));
        Integer enrollSuccessStatus = null;
        enrollSuccessStatus = enrollVO.getAudittype() != null && enrollVO.getAudittype() == 0 ? Integer.valueOf(EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue()) : Integer.valueOf(EnrollEnum.USER_AUDIT_STATUS_ENROLL.getValue());
        this.validatedMaxNum((EnrollEnroll)ConvertUtil.convert((Object)enrollVO, EnrollEnroll.class), 1);
        EnrollUserQuery enrollUserQuery = new EnrollUserQuery();
        enrollUserQuery.setEnrollId(enrollVO.getEnrollId());
        enrollUserQuery.setUserId(userId);
        EnrollUser existEnrollUser = (EnrollUser)this.getEnrollUserPlusDao().findOne(enrollUserQuery);
        if (existEnrollUser != null) {
            if (existEnrollUser.getStatus().intValue() == EnrollEnum.USER_AUDIT_STATUS_CANCEL.getValue()) {
                this.getEnrollUserPlusDao().updateAuditInfoByEnrollIdAndUserId(enrollVO.getEnrollId(), userId, enrollSuccessStatus, null, null, null);
                this.auditMQSend(enrollVO.getEnrollId(), enrollVO.getRelativeId(), enrollVO.getType(), Arrays.asList(userId), enrollSuccessStatus);
                return enrollSuccessStatus;
            }
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_REPEATED);
        }
        EnrollUser enrollUser = new EnrollUser();
        enrollUser.setEnrolluserId(IdUtil.getSequence((String)"ENROLL_USER"));
        enrollUser.setEnrollId(enrollVO.getEnrollId());
        enrollUser.setUserId(userId);
        enrollUser.setCreatorId(userId);
        enrollUser.setCreatedate(new Date());
        enrollUser.setStatus(enrollSuccessStatus);
        this.getEnrollUserPlusDao().insertSelective((BaseEntity)enrollUser);
        this.auditMQSend(enrollVO.getEnrollId(), enrollVO.getRelativeId(), enrollVO.getType(), Arrays.asList(userId), enrollSuccessStatus);
        return enrollUser.getStatus();
    }

    @Override
    public Integer delete(Long userId, Long businessId, Integer businessType) {
        EnrollEnrollVO enrollVO = this.enrollEnrollPlusService.findInfo(businessId, businessType);
        if (enrollVO == null || enrollVO.getEnrollId() == null) {
            return 0;
        }
        EnrollUser enrollUser = this.getByEnrollIdAndUserId(enrollVO.getEnrollId(), userId);
        if (enrollUser == null) {
            return 0;
        }
        int cancelNum = this.getEnrollUserPlusDao().updateAuditInfoByEnrollIdAndUserId(enrollVO.getEnrollId(), userId, EnrollEnum.USER_AUDIT_STATUS_CANCEL.getValue(), null, null, null);
        JSONObject jObj = new JSONObject();
        jObj.put("userIds", Arrays.asList(userId));
        jObj.put("status", (Object)enrollUser.getStatus());
        jObj.put("businessId", (Object)businessId);
        jObj.put("businessType", (Object)businessType);
        MessageQHelper.send((String)"enrolluser", (Long)enrollVO.getEnrollId(), (String)"usercancel", (Object)jObj);
        return cancelNum;
    }

    @Override
    public EnrollUserVO getVOByEnrollIdAndUserId(Long businessId, Integer businesstype, Long userId) {
        EnrollEnrollVO enrollEnrollVO = this.enrollEnrollPlusService.findInfo(businessId, businesstype);
        if (enrollEnrollVO == null || enrollEnrollVO.getEnrollId() == null) {
            return new EnrollUserVO();
        }
        EnrollUserQuery enrollUserQuery = new EnrollUserQuery();
        enrollUserQuery.setEnrollId(enrollEnrollVO.getEnrollId());
        enrollUserQuery.setUserId(userId);
        EnrollUser enrollUser = (EnrollUser)this.getEnrollUserPlusDao().findOne(enrollUserQuery);
        return (EnrollUserVO)ConvertUtil.convert((Object)enrollUser, EnrollUserVO.class);
    }

    @Override
    public EnrollUser getByEnrollIdAndUserId(Long enrollId, Long userId) {
        EnrollUserQuery enrollUserQuery = new EnrollUserQuery();
        enrollUserQuery.setEnrollId(enrollId);
        enrollUserQuery.setUserId(userId);
        return (EnrollUser)this.getEnrollUserPlusDao().findOne(enrollUserQuery);
    }

    @Override
    public List<Long> getUserIdsByEnrollId(Long enrollId) {
        return this.getEnrollUserPlusDao().getUserIdsByEnrollId(enrollId);
    }

    @Override
    public List<EnrollUser> getListByUserId(Long userId) {
        EnrollUserQuery enrollUserQuery = new EnrollUserQuery();
        enrollUserQuery.setUserId(userId);
        enrollUserQuery.getPage().setSortColumns("eu.CREATEDATE desc");
        List enrollUserList = this.getEnrollUserPlusDao().findAll(enrollUserQuery);
        if (ListUtil.isNullorEmpty((List)enrollUserList)) {
            return new ArrayList<EnrollUser>();
        }
        return enrollUserList;
    }

    private void auditMQSend(EnrollEnroll enroll, List<Long> userIds, int auditStatus) {
        if (enroll == null) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_EXISTS);
        }
        this.auditMQSend(enroll.getEnrollId(), enroll.getRelativeId(), enroll.getType(), userIds, auditStatus);
    }

    private void auditMQSend(Long enrollId, Long businessId, Integer businesstype, List<Long> userIds, int auditStatus) {
        JSONObject jObj = new JSONObject();
        jObj.put("userIds", userIds);
        jObj.put("businessId", (Object)businessId);
        jObj.put("businessType", (Object)businesstype);
        if (auditStatus == EnrollEnum.USER_AUDIT_STATUS_PASS.getValue() || auditStatus == EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue()) {
            MessageQHelper.send((String)"enrolluser", (Long)enrollId, (String)"auditpass", (Object)jObj);
        } else if (auditStatus == EnrollEnum.USER_AUDIT_STATUS_NOTPASS.getValue()) {
            MessageQHelper.send((String)"enrolluser", (Long)enrollId, (String)"auditnotpass", (Object)jObj);
        } else if (auditStatus == EnrollEnum.USER_AUDIT_STATUS_ENROLL.getValue()) {
            MessageQHelper.send((String)"enrolluser", (Long)enrollId, (String)"enroll", (Object)jObj);
        }
    }

    private void validatedMaxNum(EnrollEnroll enroll, int addUserNum) {
        int limitnum;
        if (enroll == null || enroll.getEnrollId() == null) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_EXISTS);
        }
        int passAuditNum = this.getPassAuditNum(enroll.getEnrollId()).intValue();
        int n = limitnum = enroll.getLimitnum() != null ? enroll.getLimitnum() : 0;
        if (limitnum > 0 && passAuditNum + addUserNum > limitnum) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLLUSER_LIMITNUM_MAXERROR);
        }
    }

    private void validatedMaxNum(EnrollEnroll enroll, List<Long> userIdList) {
        int limitnum;
        if (enroll == null || enroll.getEnrollId() == null) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_EXISTS);
        }
        int passAuditNum = this.getPassAuditNum(enroll.getEnrollId(), userIdList).intValue();
        int n = limitnum = enroll.getLimitnum() != null ? enroll.getLimitnum() : 0;
        if (limitnum > 0 && passAuditNum + userIdList.size() > limitnum) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLLUSER_LIMITNUM_MAXERROR);
        }
    }

    private void validateEnrollDate(EnrollEnroll enroll) {
        Date now = new Date();
        if (enroll.getBegintime() != null && now.compareTo(enroll.getBegintime()) < 0 || enroll.getEndtime() != null && now.compareTo(enroll.getEndtime()) > 0) {
            ExceptionUtil.handle((IRespStatusEnum)BcResponseStatusEnum.ENROLL_NOT_IN_VALID_TIME);
        }
    }
}

