/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.lms.resourcecategory.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.enums.ResourcecategoryEnum;
import com.peak.prd.enums.ResourcecategoryTypeEnum;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryBO;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryOrderNumBO;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryRootBO;
import com.peak.prd.lms.resourcecategory.dao.IResourcecategoryPlusDao;
import com.peak.prd.lms.resourcecategory.model.Resourcecategory;
import com.peak.prd.lms.resourcecategory.service.IResourcecategoryPlusService;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryDetailMngVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryMiniVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryMngVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryQuery;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategorySelectedVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class ResourcecategoryPlusService
extends PrdBaseService<Resourcecategory, Long, ResourcecategoryQuery>
implements IResourcecategoryPlusService {
    private IResourcecategoryPlusDao resourcecategoryPlusDao;
    @Autowired
    @Lazy
    IResourcecategoryPlusService self;

    public void setResourcecategoryPlusDao(IResourcecategoryPlusDao dao) {
        this.resourcecategoryPlusDao = dao;
    }

    public IResourcecategoryPlusDao getResourcecategoryPlusDao() {
        return this.resourcecategoryPlusDao;
    }

    public IEntityDao<Resourcecategory, Long, ResourcecategoryQuery> getEntityDao() {
        return this.resourcecategoryPlusDao;
    }

    @Override
    public List<ResourcecategoryVO> getChildrenVOsByParentId(@NotNull Long parentId, @NotEmpty List<Long> domainIds) {
        ResourcecategoryVO resourcecategoryVO = this.getVO(parentId, domainIds);
        return resourcecategoryVO == null ? null : resourcecategoryVO.getChildren();
    }

    @Override
    public List<ResourcecategoryVO> getLessonResourcecategoryVOs(@NotEmpty List<Long> domainIds) {
        return this.getChildrenVOsByParentId(ResourcecategoryEnum.LESSON.getValue(), domainIds);
    }

    @Override
    public List<ResourcecategoryVO> getRespkgResourcecategoryVOs(@NotEmpty List<Long> domainIds) {
        return this.getChildrenVOsByParentId(ResourcecategoryEnum.RESPKG.getValue(), domainIds);
    }

    @Override
    public List<ResourcecategoryVO> getTagResourcecategoryVOs(@NotNull Long domainId) {
        ArrayList<Long> domainIds = new ArrayList<Long>();
        domainIds.add(domainId);
        return this.getChildrenVOsByParentId(ResourcecategoryEnum.TAG.getValue(), domainIds);
    }

    @Override
    @Cacheable
    public ResourcecategoryVO getVO(@NotNull Long resourcecategoryId, @NotEmpty List<Long> domainIds) {
        Resourcecategory resourcecategory = (Resourcecategory)this.findById(resourcecategoryId);
        ResourcecategoryVO resourcecategoryVO = (ResourcecategoryVO)ConvertUtil.convert((Object)resourcecategory, ResourcecategoryVO.class);
        if (resourcecategoryVO == null || resourcecategoryVO.getRescategoryId() == null || resourcecategoryVO.getType() == null) {
            return null;
        }
        ResourcecategoryQuery query = new ResourcecategoryQuery();
        query.setDomainIds(domainIds);
        query.setFullpath(",," + resourcecategoryVO.getRescategoryId() + ",,");
        query.setDeleted(0);
        query.setStatus(1);
        query.getPage().setSortColumns("rcy.ORDERNUM, rcy.CREATEDATE");
        List resourcecategoryList = this.resourcecategoryPlusDao.findAll(query);
        if (ListUtil.isNullorEmpty((List)resourcecategoryList)) {
            return resourcecategoryVO;
        }
        List resourcecategoryVOTempList = ConvertUtil.convert((List)resourcecategoryList, ResourcecategoryVO.class);
        List resourcecategoryVOList = ListUtil.convertToTree((List)resourcecategoryVOTempList, (Long)resourcecategoryVO.getRescategoryId(), ResourcecategoryVO::getRescategoryId, ResourcecategoryVO::getParentId, ResourcecategoryVO::getChildren, ResourcecategoryVO::setChildren);
        resourcecategoryVO.setChildren(resourcecategoryVOList);
        return resourcecategoryVO;
    }

    @Override
    public List<ResourcecategoryVO> getDocumentResourcecategoryVOs(@NotEmpty List<Long> domainIds) {
        return this.getChildrenVOsByParentId(ResourcecategoryEnum.DOCUMENT.getValue(), domainIds);
    }

    @Override
    public int refreshRespkgResourceviews() {
        return this.resourcecategoryPlusDao.refreshRespkgResourceviews();
    }

    public <VO> VO getVOById(Long rescategoryId, Class<VO> clazz) {
        Resourcecategory resourcecategory = (Resourcecategory)this.findById(rescategoryId);
        Object vo = ConvertUtil.convert((Object)resourcecategory, clazz);
        return (VO)vo;
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findVOList(@NotNull Long lessonId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListBylessonId(lessonId);
        List ids = IdUtil.getIds(resourcecategoryList, e -> e.getRescategoryId());
        return this.findVOsByIds(ids, ResourcecategoryVO.class);
    }

    @Override
    public List<ResourcecategoryVO> findVOList(Long lessonId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListBylessonId(lessonId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        List ids = IdUtil.getIds(resourcecategoryList, e -> e.getRescategoryId());
        return this.findVOsByIds(ids, ResourcecategoryVO.class);
    }

    @Override
    public List<ResourcecategoryVO> getVOList(@NotNull Long lessonId) {
        return this.getVOList(lessonId, ResourcecategoryTypeEnum.LESSON, null);
    }

    @Override
    public List<ResourcecategoryVO> getVOList(Long lessonId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListBylessonId(lessonId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        return ConvertUtil.convert(resourcecategoryList, ResourcecategoryVO.class);
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findVOListByRespkgId(@NotNull Long respkgId) {
        return this.findVOListByRespkgId(respkgId, ResourcecategoryTypeEnum.RESPKG, null);
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findVOListByRespkgId(Long respkgId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListByrespkgId(respkgId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        List ids = IdUtil.getIds(resourcecategoryList, e -> e.getRescategoryId());
        return this.findVOsByIds(ids, ResourcecategoryVO.class);
    }

    @Override
    public List<ResourcecategoryVO> getVOListByRespkgId(@NotNull Long respkgId) {
        return this.getVOListByRespkgId(respkgId, ResourcecategoryTypeEnum.RESPKG, null);
    }

    @Override
    public List<ResourcecategoryVO> getVOListByRespkgId(Long respkgId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListByrespkgId(respkgId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        return ConvertUtil.convert(resourcecategoryList, ResourcecategoryVO.class);
    }

    @Override
    public List<ResourcecategoryVO> getVOListByOfflessonId(@NotNull Long offlessonId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListByOfflessonId(offlessonId);
        return ConvertUtil.convert(resourcecategoryList, ResourcecategoryVO.class);
    }

    @Override
    public List<ResourcecategoryMiniVO> getMngVOList(@NotNull Long lessonId) {
        return this.getMngVOList(lessonId, ResourcecategoryTypeEnum.LESSON, null);
    }

    @Override
    public List<ResourcecategoryMiniVO> getMngVOList(Long lessonId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListBylessonId(lessonId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        return ConvertUtil.convert(resourcecategoryList, ResourcecategoryMiniVO.class);
    }

    @Override
    public List<ResourcecategoryMiniVO> getVOListByParentId(@NotNull Long parentId, @NotNull Long domainId, boolean isIncUp) {
        return this.getVOListByParentId(parentId, domainId, isIncUp, null);
    }

    @Override
    public List<ResourcecategoryMiniVO> getVOListByParentId(Long parentId, Long domainId, boolean isIncUp, String type) {
        ResourcecategoryQuery query = new ResourcecategoryQuery();
        query.setParentId(parentId);
        query.setDeleted(0);
        query.setStatus(1);
        query.setDomainId(domainId);
        query.setDomainIdIncUp(isIncUp);
        if (type != null) {
            query.setType(type);
        }
        query.getPage().setSortColumns("rcy.ORDERNUM, rcy.CREATEDATE DESC");
        List resourcecategoryList = this.resourcecategoryPlusDao.findAll(query);
        return ConvertUtil.convert((List)resourcecategoryList, ResourcecategoryMiniVO.class);
    }

    @Override
    public List<ResourcecategoryMiniVO> getVOListByParentId(@NotNull Long parentId, @NotEmpty List<Long> domainIds) {
        ResourcecategoryQuery query = new ResourcecategoryQuery();
        query.setDeleted(0);
        query.setStatus(1);
        query.setFullpath(",," + parentId + ",,");
        query.setDomainIds(domainIds);
        query.getPage().setSortColumns("rcy.ORDERNUM, rcy.CREATEDATE DESC");
        List resourcecategoryList = this.resourcecategoryPlusDao.findAll(query);
        return ConvertUtil.convert((List)resourcecategoryList, ResourcecategoryMiniVO.class);
    }

    @Override
    public Long insert(@NotNull Long userId, @NotNull Long domainId, @NotNull ResourcecategoryBO resourcecategoryBO) {
        Resourcecategory resourcecategory = (Resourcecategory)ConvertUtil.convert((Object)resourcecategoryBO, Resourcecategory.class);
        Long rescategoryId = IdUtil.getSequence((String)"LMS_RESOURCECATEGORY");
        resourcecategory.setRescategoryId(rescategoryId);
        resourcecategory.setDomainId(domainId);
        resourcecategory.setGkey(IdUtil.getGkey());
        resourcecategory.setCreatorId(userId);
        resourcecategory.setCreatedate(new Date());
        resourcecategory.setDeleted(0);
        resourcecategory.setIsroot(0);
        resourcecategory.setDeleteable(0);
        resourcecategory.setUserange(1);
        resourcecategory.setIsmobilelesson(0);
        resourcecategory.setResourceviews(0L);
        Resourcecategory parent = (Resourcecategory)this.getById(resourcecategoryBO.getParentId());
        resourcecategory.setFullpath(parent.getFullpath() + rescategoryId + ",,");
        this.insert((BaseEntity)resourcecategory);
        return rescategoryId;
    }

    @Override
    public Long insertRoot(Long userId, Long domainId, ResourcecategoryRootBO resourcecategoryRootBO) {
        Resourcecategory resourcecategory = (Resourcecategory)ConvertUtil.convert((Object)resourcecategoryRootBO, Resourcecategory.class);
        Long rescategoryId = -resourcecategoryRootBO.getRescategoryId().longValue();
        resourcecategory.setRescategoryId(-resourcecategoryRootBO.getRescategoryId().longValue());
        resourcecategory.setDomainId(domainId);
        resourcecategory.setGkey(IdUtil.getGkey());
        resourcecategory.setCreatorId(userId);
        resourcecategory.setCreatedate(new Date());
        resourcecategory.setDeleted(0);
        resourcecategory.setIsroot(1);
        resourcecategory.setDeleteable(0);
        resourcecategory.setUserange(1);
        resourcecategory.setIsmobilelesson(0);
        resourcecategory.setResourceviews(0L);
        resourcecategory.setParentId(-1L);
        resourcecategory.setStatus(1);
        resourcecategory.setFullpath(",," + rescategoryId + ",,");
        this.insert((BaseEntity)resourcecategory);
        return rescategoryId;
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'IResourcecategoryPlusService:' + #resourcecategoryBO.rescategoryId")
    public int txUpdate(@NotNull ResourcecategoryBO resourcecategoryBO) {
        Resourcecategory oldResourcecategory = (Resourcecategory)this.getById(resourcecategoryBO.getRescategoryId());
        if (oldResourcecategory == null) {
            return 0;
        }
        Resourcecategory resourcecategory = (Resourcecategory)ConvertUtil.convert((Object)resourcecategoryBO, Resourcecategory.class);
        if (oldResourcecategory.getParentId().longValue() != resourcecategoryBO.getParentId().longValue()) {
            Resourcecategory parent = (Resourcecategory)this.getById(resourcecategoryBO.getParentId());
            resourcecategory.setFullpath(parent.getFullpath() + resourcecategory.getRescategoryId() + ",,");
            this.resourcecategoryPlusDao.updateChildrenFullpath(oldResourcecategory.getFullpath(), resourcecategory.getFullpath());
        }
        return this.resourcecategoryPlusDao.updateInfo(resourcecategory);
    }

    @Override
    public int updateOrderNum(@NotEmpty List<ResourcecategoryOrderNumBO> resOrderNumBOList) {
        int updateNum = 0;
        for (ResourcecategoryOrderNumBO resOrderNumBO : resOrderNumBOList) {
            Resourcecategory resourcecategory = (Resourcecategory)ConvertUtil.convert((Object)resOrderNumBO, Resourcecategory.class);
            updateNum += this.resourcecategoryPlusDao.updateInfo(resourcecategory).intValue();
        }
        return updateNum;
    }

    @Override
    @CacheEvict(cacheNames={"prd"}, key="'IResourcecategoryPlusService:' + #rescategoryId")
    public int delete(@NotNull Long rescategoryId) {
        return this.resourcecategoryPlusDao.deleteAndChildren(rescategoryId);
    }

    @Override
    public ResourcecategoryDetailMngVO getMngInfo(@NotNull Long rescategoryId) {
        Resourcecategory resourcecategory = (Resourcecategory)this.getById(rescategoryId);
        if (resourcecategory == null) {
            return new ResourcecategoryDetailMngVO();
        }
        ResourcecategoryDetailMngVO rdDetailMngVO = (ResourcecategoryDetailMngVO)ConvertUtil.convert((Object)resourcecategory, ResourcecategoryDetailMngVO.class);
        Resourcecategory parentResourcecategory = (Resourcecategory)this.getById(resourcecategory.getParentId());
        if (parentResourcecategory != null) {
            ResourcecategoryMiniVO parentMiniVO = new ResourcecategoryMiniVO();
            parentMiniVO.setRescategoryId(parentResourcecategory.getRescategoryId());
            parentMiniVO.setName(parentResourcecategory.getName());
            rdDetailMngVO.setParentMiniVO(parentMiniVO);
        }
        return rdDetailMngVO;
    }

    @Override
    public List<ResourcecategoryMngVO> getMngTreeVOList(@NotNull Long domainId, @NotNull Long rootId, boolean isIncUp) {
        return this.getMngTreeVOList(domainId, rootId, isIncUp, null);
    }

    @Override
    public List<ResourcecategoryMngVO> getMngTreeVOList(Long domainId, Long rootId, boolean isIncUp, String type) {
        List<Resourcecategory> resourcecategoryList = this.getList(domainId, rootId, isIncUp, null, type);
        if (resourcecategoryList == null || resourcecategoryList.size() == 0) {
            return new ArrayList<ResourcecategoryMngVO>();
        }
        List resourcecategoryVOList = ConvertUtil.convert(resourcecategoryList, ResourcecategoryMngVO.class);
        UserCoreUtil.setUserVO((List)resourcecategoryVOList, ResourcecategoryMngVO::getCreatorId, ResourcecategoryMngVO::setUserVO);
        resourcecategoryVOList = ListUtil.convertToTree((List)resourcecategoryVOList, (Long)rootId, ResourcecategoryMngVO::getRescategoryId, ResourcecategoryMngVO::getParentId, ResourcecategoryMngVO::getChildren, ResourcecategoryMngVO::setChildren);
        return resourcecategoryVOList;
    }

    @Override
    public List<ResourcecategorySelectedVO> getSelectedVOList(@NotNull Long domainId, @NotNull Long rootId, boolean isIncUp) {
        return this.getSelectedVOList(domainId, rootId, isIncUp, null);
    }

    @Override
    public List<ResourcecategorySelectedVO> getSelectedVOList(Long domainId, Long rootId, boolean isIncUp, String type) {
        List<Resourcecategory> resourcecategoryList = this.getList(domainId, rootId, isIncUp, 1, type);
        if (resourcecategoryList == null || resourcecategoryList.size() == 0) {
            return new ArrayList<ResourcecategorySelectedVO>();
        }
        List resourcecategorySelectVOList = ConvertUtil.convert(resourcecategoryList, ResourcecategorySelectedVO.class);
        for (ResourcecategorySelectedVO resourcecategorySelectedVO : resourcecategorySelectVOList) {
            String fullpath = resourcecategorySelectedVO.getFullpath();
            List resourcecategoryFullpathList = this.findByIds(IdUtil.getIds((String)fullpath, (String)",,"));
            StringBuffer fullname = new StringBuffer();
            resourcecategoryFullpathList.forEach(resourcecategory -> {
                if (fullname.toString().length() == 0) {
                    fullname.append(resourcecategory.getName());
                } else {
                    fullname.append("-" + resourcecategory.getName());
                }
            });
            resourcecategorySelectedVO.setFullPathName(fullname.toString());
        }
        resourcecategorySelectVOList = ListUtil.convertToTree((List)resourcecategorySelectVOList, (Long)rootId, ResourcecategorySelectedVO::getRescategoryId, ResourcecategorySelectedVO::getParentId, ResourcecategorySelectedVO::getChildren, ResourcecategorySelectedVO::setChildren);
        return resourcecategorySelectVOList;
    }

    @Override
    public List<ResourcecategoryVO> getSpzVOList(Long rootId, String type) {
        ResourcecategoryQuery query = new ResourcecategoryQuery(1, 1);
        query.setParentId(-rootId.longValue());
        query.setType(type);
        query.setStatus(1);
        query.getPage().setSortColumns(" rcy.CREATEDATE DESC ");
        Resourcecategory esourcecategory = (Resourcecategory)this.resourcecategoryPlusDao.findOne(query);
        if (esourcecategory == null) {
            return new ArrayList<ResourcecategoryVO>();
        }
        List<Resourcecategory> resourcecategoryList = this.getList(null, esourcecategory.getRescategoryId(), false, 1, type);
        if (resourcecategoryList == null || resourcecategoryList.size() == 0) {
            return new ArrayList<ResourcecategoryVO>();
        }
        List resourcecategoryVOList = ConvertUtil.convert(resourcecategoryList, ResourcecategoryVO.class);
        resourcecategoryVOList = ListUtil.convertToTree((List)resourcecategoryVOList, (Long)esourcecategory.getRescategoryId(), ResourcecategoryVO::getRescategoryId, ResourcecategoryVO::getParentId, ResourcecategoryVO::getChildren, ResourcecategoryVO::setChildren);
        return resourcecategoryVOList;
    }

    private List<Resourcecategory> getList(Long domainId, Long rootId, boolean isIncUp, Integer status, String type) {
        ResourcecategoryQuery query = new ResourcecategoryQuery();
        query.setDeleted(0);
        if (domainId != null) {
            query.setDomainId(domainId);
        }
        query.setDomainIdIncUp(isIncUp);
        query.setStatus(status);
        query.setFullpath(",," + rootId + ",,");
        if (type != null) {
            query.setType(type);
        }
        query.getPage().setSortColumns("rcy.ORDERNUM, rcy.CREATEDATE");
        List resourcecategoryList = this.resourcecategoryPlusDao.findAll(query);
        return resourcecategoryList;
    }

    @Override
    public List<ResourcecategoryMiniVO> getMiniVOList(@NotNull Long businessId, @NotNull Integer businessType) {
        ArrayList<ResourcecategoryMiniVO> resourcecategoryMiniVos = new ArrayList<ResourcecategoryMiniVO>();
        List<ResourcecategoryVO> resourcecategoryVOList = null;
        if (businessType.intValue() == BusinessOrigin.LESSON.getIndex()) {
            resourcecategoryVOList = this.getVOList(businessId);
        } else if (businessType.intValue() == BusinessOrigin.RESPKG.getIndex()) {
            resourcecategoryVOList = this.getVOListByRespkgId(businessId);
        } else if (businessType.intValue() == BusinessOrigin.OFFLESSON.getIndex()) {
            resourcecategoryVOList = this.getVOListByOfflessonId(businessId);
        } else if (businessType.intValue() == BusinessOrigin.DOCUMENT.getIndex()) {
            resourcecategoryVOList = this.getVOListByDocumentId(businessId);
        }
        if (resourcecategoryVOList == null) {
            return new ArrayList<ResourcecategoryMiniVO>();
        }
        for (ResourcecategoryVO resourcecategoryVO : resourcecategoryVOList) {
            String fullpath = resourcecategoryVO.getFullpath();
            List resourcecategoryList = this.findByIds(IdUtil.getIds((String)fullpath, (String)",,"));
            StringBuffer fullname = new StringBuffer();
            resourcecategoryList.forEach(resourcecategory -> {
                if (fullname.toString().length() == 0) {
                    fullname.append(resourcecategory.getName());
                } else {
                    fullname.append("-" + resourcecategory.getName());
                }
            });
            ResourcecategoryMiniVO rctMiniMngVO = (ResourcecategoryMiniVO)ConvertUtil.convert((Object)resourcecategoryVO, ResourcecategoryMiniVO.class);
            rctMiniMngVO.setFullname(fullname.toString());
            resourcecategoryMiniVos.add(rctMiniMngVO);
        }
        return resourcecategoryMiniVos;
    }

    @Override
    public List<ResourcecategoryMiniVO> getMiniVOList(Long businessId, Integer businessType, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        ArrayList<ResourcecategoryMiniVO> resourcecategoryMiniVos = new ArrayList<ResourcecategoryMiniVO>();
        List<ResourcecategoryVO> resourcecategoryVOList = null;
        if (businessType.intValue() == BusinessOrigin.LESSON.getIndex()) {
            resourcecategoryVOList = this.getVOList(businessId, resourcecategoryTypeEnum, specialzoneId);
        } else if (businessType.intValue() == BusinessOrigin.RESPKG.getIndex()) {
            resourcecategoryVOList = this.getVOListByRespkgId(businessId, resourcecategoryTypeEnum, specialzoneId);
        } else if (businessType.intValue() == BusinessOrigin.OFFLESSON.getIndex()) {
            resourcecategoryVOList = this.getVOListByOfflessonId(businessId);
        } else if (businessType.intValue() == BusinessOrigin.DOCUMENT.getIndex()) {
            resourcecategoryVOList = this.getVOListByDocumentId(businessId, resourcecategoryTypeEnum, specialzoneId);
        }
        if (resourcecategoryVOList == null) {
            return new ArrayList<ResourcecategoryMiniVO>();
        }
        for (ResourcecategoryVO resourcecategoryVO : resourcecategoryVOList) {
            String fullpath = resourcecategoryVO.getFullpath();
            List resourcecategoryList = this.findByIds(IdUtil.getIds((String)fullpath, (String)",,"));
            StringBuffer fullname = new StringBuffer();
            resourcecategoryList.forEach(resourcecategory -> {
                if (fullname.toString().length() == 0) {
                    fullname.append(resourcecategory.getName());
                } else {
                    fullname.append("-" + resourcecategory.getName());
                }
            });
            ResourcecategoryMiniVO rctMiniMngVO = (ResourcecategoryMiniVO)ConvertUtil.convert((Object)resourcecategoryVO, ResourcecategoryMiniVO.class);
            rctMiniMngVO.setFullname(fullname.toString());
            resourcecategoryMiniVos.add(rctMiniMngVO);
        }
        return resourcecategoryMiniVos;
    }

    @Override
    public List<Long> getCategoryIdListByCode(@NotBlank String code, @NotNull Long domainId) {
        ResourcecategoryQuery query = new ResourcecategoryQuery();
        query.setDeleted(0);
        query.setEqualCode(code);
        query.setColumns("rcy.RESCATEGORY_ID");
        query.getPage().setSortColumns("rcy.ORDERNUM, rcy.CREATEDATE");
        List rclist = this.resourcecategoryPlusDao.findAll(query);
        return IdUtil.getIds((List)rclist, e -> e.getRescategoryId());
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzLessonRescategory(Long specialzoneId) {
        return this.findSpzLessonRescategory(specialzoneId, ResourcecategoryTypeEnum.LESSON);
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzLessonRescategory(Long specialzoneId, ResourcecategoryTypeEnum resourcecategoryTypeEnum) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.getSpzLessonRescategoryList(specialzoneId, resourcecategoryTypeEnum != null ? resourcecategoryTypeEnum.getValue() : null);
        if (ListUtil.isNullorEmpty(resourcecategoryList)) {
            return null;
        }
        return this.getSpzResourcecategoryVOList(resourcecategoryList, resourcecategoryTypeEnum.equals((Object)ResourcecategoryTypeEnum.SPZ_LESSON) ? -specialzoneId.longValue() : ResourcecategoryEnum.LESSON.getValue());
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzRespkgRescategory(Long specialzoneId) {
        return this.findSpzRespkgRescategory(specialzoneId, ResourcecategoryTypeEnum.RESPKG);
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzRespkgRescategory(Long specialzoneId, ResourcecategoryTypeEnum resourcecategoryTypeEnum) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.getSpzRespkgRescategoryList(specialzoneId, resourcecategoryTypeEnum != null ? resourcecategoryTypeEnum.getValue() : null);
        if (ListUtil.isNullorEmpty(resourcecategoryList)) {
            return null;
        }
        return this.getSpzResourcecategoryVOList(resourcecategoryList, resourcecategoryTypeEnum.equals((Object)ResourcecategoryTypeEnum.SPZ_RESPKG) ? -specialzoneId.longValue() : ResourcecategoryEnum.RESPKG.getValue());
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzDocumentRescategory(Long specialzoneId) {
        return this.findSpzDocumentRescategory(specialzoneId, ResourcecategoryTypeEnum.DOCUMENT);
    }

    @Override
    @Cacheable
    public List<ResourcecategoryVO> findSpzDocumentRescategory(Long specialzoneId, ResourcecategoryTypeEnum resourcecategoryTypeEnum) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.getSpzDocumentRescategoryList(specialzoneId, resourcecategoryTypeEnum != null ? resourcecategoryTypeEnum.getValue() : null);
        if (ListUtil.isNullorEmpty(resourcecategoryList)) {
            return null;
        }
        return this.getSpzResourcecategoryVOList(resourcecategoryList, resourcecategoryTypeEnum.equals((Object)ResourcecategoryTypeEnum.SPZ_DOCUMENT) ? -specialzoneId.longValue() : ResourcecategoryEnum.DOCUMENT.getValue());
    }

    @Override
    public int deleteBySpzIdAndLessonId(Long specialzoneId, Long lessonId) {
        return this.resourcecategoryPlusDao.deleteBySpzIdAndLessonId(specialzoneId, lessonId);
    }

    @Override
    public int deleteBySpzIdAndRespkgId(Long specialzoneId, Long respkgId) {
        return this.resourcecategoryPlusDao.deleteBySpzIdAndRespkgId(specialzoneId, respkgId);
    }

    @Override
    public List<ResourcecategoryVO> getVOListByDocumentId(Long documentId) {
        return this.getVOListByRespkgId(documentId, ResourcecategoryTypeEnum.DOCUMENT, null);
    }

    @Override
    public List<ResourcecategoryVO> getVOListByDocumentId(Long documentId, ResourcecategoryTypeEnum resourcecategoryTypeEnum, Long specialzoneId) {
        List<Resourcecategory> resourcecategoryList = this.resourcecategoryPlusDao.findResourcecategoryListByDocumentId(documentId, resourcecategoryTypeEnum.getValue(), specialzoneId);
        return ConvertUtil.convert(resourcecategoryList, ResourcecategoryVO.class);
    }

    private List<ResourcecategoryVO> getSpzResourcecategoryVOList(List<Resourcecategory> resourcecategoryList, Long rootId) {
        List fullpathList = resourcecategoryList.stream().map(Resourcecategory::getFullpath).collect(Collectors.toList());
        List resourcecategoryIds = new ArrayList();
        for (String fullpath : fullpathList) {
            String newfullpath = fullpath.replaceAll("^,+|,+$", "");
            resourcecategoryIds.addAll(StringUtil.splitToLongList((String)newfullpath, (String)",,"));
        }
        resourcecategoryIds = ListUtil.removeDuplicate(resourcecategoryIds);
        List spzRescategoryList = this.findByIds(resourcecategoryIds);
        List spzRescategoryVOList = ConvertUtil.convert((List)spzRescategoryList, ResourcecategoryVO.class);
        return ListUtil.convertToTree((List)spzRescategoryVOList, (Long)rootId, ResourcecategoryVO::getRescategoryId, ResourcecategoryVO::getParentId, ResourcecategoryVO::getChildren, ResourcecategoryVO::setChildren);
    }
}

