/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.point.busevent.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.point.busevent.bo.BusinessEventBO;
import com.peak.prd.point.busevent.bo.BusinessEventInsertBO;
import com.peak.prd.point.busevent.bo.BusinessEventQueryBO;
import com.peak.prd.point.busevent.bo.BusinessEventUpdateBO;
import com.peak.prd.point.busevent.dao.IBusinesseventPlusDao;
import com.peak.prd.point.busevent.model.Businessevent;
import com.peak.prd.point.busevent.service.IBusinesseventPlusService;
import com.peak.prd.point.busevent.vo.BusinessEventMngVO;
import com.peak.prd.point.busevent.vo.BusinesseventQuery;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class BusinesseventPlusService
extends PrdBaseService<Businessevent, Long, BusinesseventQuery>
implements IBusinesseventPlusService {
    @Resource
    private IBusinesseventPlusDao businesseventPlusDao;

    public IEntityDao<Businessevent, Long, BusinesseventQuery> getEntityDao() {
        return this.businesseventPlusDao;
    }

    @Override
    public Paging<BusinessEventMngVO> getMngVOList(@NotNull BusinessEventQueryBO businessEventQueryBO) {
        BusinesseventQuery query = new BusinesseventQuery(businessEventQueryBO.getPageNumber(), businessEventQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)businessEventQueryBO), (Object)query);
        query.setDeleted(0);
        query.getPage().setSortColumns("BUET.CREATEDATE");
        Paging businessEventMngVOListPaging = this.businesseventPlusDao.findPaging(query, BusinessEventMngVO.class);
        List businessEventMngVOList = businessEventMngVOListPaging.getList();
        if (businessEventMngVOList == null || businessEventMngVOList.isEmpty()) {
            return businessEventMngVOListPaging;
        }
        UserCoreUtil.setUserVO((List)businessEventMngVOList, BusinessEventMngVO::getCreatorId, BusinessEventMngVO::setUserVO);
        return businessEventMngVOListPaging;
    }

    @Override
    public Integer insertEvent(@NotNull Long userId, @NotNull BusinessEventBO businessEventBO) throws Exception {
        List<BusinessEventInsertBO> eventList = businessEventBO.getEventList();
        if (eventList == null || eventList.size() == 0) {
            return null;
        }
        List pointEventList = ConvertUtil.convert(eventList, Businessevent.class);
        for (Businessevent pointEvent : pointEventList) {
            Long pointEventId = IdUtil.getSequence((String)"POINT_BUSINESSEVENT");
            pointEvent.setBuseventId(pointEventId);
            pointEvent.setBusinesstype(businessEventBO.getBusinesstype());
            pointEvent.setBusinessId(businessEventBO.getBusinessId());
            pointEvent.setDeleted(0);
            pointEvent.setCreatorId(userId);
            pointEvent.setCreatedate(new Date());
        }
        return this.businesseventPlusDao.insertBatch(pointEventList);
    }

    @Override
    public Integer updateEvent(@NotNull BusinessEventUpdateBO businessEventUpdateBO) throws Exception {
        Businessevent pointevent = new Businessevent();
        ConvertUtil.copyProperties((Object)businessEventUpdateBO, (Object)pointevent);
        return this.updateSelective(pointevent);
    }

    @Override
    public Integer deleteBatch(@NotEmpty List<Long> buseventIds) {
        return this.businesseventPlusDao.deleteBatch(buseventIds);
    }

    @Override
    public Businessevent getPointeventByEventcode(@NotNull String eventCode, @NotNull Integer businessType, @NotNull Long businessId) {
        BusinesseventQuery query = new BusinesseventQuery();
        query.setCode(eventCode);
        query.setBusinesstype(businessType);
        query.setBusinessId(businessId);
        query.setDeleted(0);
        List businesseventList = this.businesseventPlusDao.findList(query);
        if (ListUtil.isNullorEmpty((List)businesseventList)) {
            return null;
        }
        return (Businessevent)businesseventList.get(0);
    }
}

