/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.point.busrank.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.BusPointUploadFileEnum;
import com.peak.prd.point.busrank.bo.BusinessrankBO;
import com.peak.prd.point.busrank.bo.BusinessrankQueryBO;
import com.peak.prd.point.busrank.dao.IBusinessrankPlusDao;
import com.peak.prd.point.busrank.model.Businessrank;
import com.peak.prd.point.busrank.service.IBusinessrankPlusService;
import com.peak.prd.point.busrank.vo.BusinessrankMngVO;
import com.peak.prd.point.busrank.vo.BusinessrankQuery;
import com.peak.prd.point.busrank.vo.BusinessrankVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class BusinessrankPlusService
extends PrdBaseService<Businessrank, Long, BusinessrankQuery>
implements IBusinessrankPlusService {
    @Resource
    private IBusinessrankPlusDao businessrankPlusDao;

    public IEntityDao<Businessrank, Long, BusinessrankQuery> getEntityDao() {
        return this.businessrankPlusDao;
    }

    @Override
    public Paging<BusinessrankMngVO> getMngVOList(@NotNull BusinessrankQueryBO businessrankQueryBO) {
        BusinessrankQuery query = new BusinessrankQuery(businessrankQueryBO.getPageNumber(), businessrankQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)businessrankQueryBO), (Object)query);
        query.setDeleted(0);
        query.getPage().setSortColumns("BURK.RANKING");
        Paging pointrankMngVOPaging = this.businessrankPlusDao.findPaging(query, BusinessrankMngVO.class);
        List pointrankMngVOList = pointrankMngVOPaging.getList();
        if (pointrankMngVOList == null || pointrankMngVOList.isEmpty()) {
            return pointrankMngVOPaging;
        }
        UserCoreUtil.setUserVO((List)pointrankMngVOList, BusinessrankMngVO::getCreatorId, BusinessrankMngVO::setUserVO);
        return pointrankMngVOPaging;
    }

    @Override
    public Long insertRank(@NotNull Long userId, @NotNull BusinessrankBO businessrankBO) throws Exception {
        Businessrank pointrank = (Businessrank)ConvertUtil.convert((Object)businessrankBO, Businessrank.class);
        Long rankId = IdUtil.getSequence((String)"POINT_BUSINESSRANK");
        pointrank.setBusrankId(rankId);
        pointrank.setRanking(businessrankBO.getRank());
        String iconBase64 = businessrankBO.getPicBase64();
        if (iconBase64 != null) {
            UploadFile iconFile = UploadFileUtil.upload((String)iconBase64, (String)BusPointUploadFileEnum.BUSPOINT_POINTRANKPIC.getPath());
            pointrank.setPicfile(iconFile.getFullpath());
        }
        pointrank.setDeleted(0);
        pointrank.setCreatorId(userId);
        pointrank.setCreatedate(new Date());
        this.businessrankPlusDao.insertSelective((BaseEntity)pointrank);
        return rankId;
    }

    @Override
    public Integer updateRank(@NotNull BusinessrankBO businessrankBO) throws Exception {
        Businessrank oldPointrank = (Businessrank)this.getById(businessrankBO.getBusrankId());
        if (oldPointrank == null) {
            return 0;
        }
        Businessrank pointrank = (Businessrank)ConvertUtil.convert((Object)businessrankBO, Businessrank.class);
        pointrank.setRanking(businessrankBO.getRank());
        String iconBase64 = businessrankBO.getPicBase64();
        if (iconBase64 != null) {
            UploadFile iconFile = UploadFileUtil.upload((String)iconBase64, (String)BusPointUploadFileEnum.BUSPOINT_POINTRANKPIC.getPath());
            pointrank.setPicfile(iconFile.getFullpath());
        }
        return this.businessrankPlusDao.updateSelective(pointrank);
    }

    @Override
    public Integer deleteBatch(@NotEmpty List<Long> busrankIds) {
        return this.businessrankPlusDao.deleteBatch(busrankIds);
    }

    @Override
    public BusinessrankVO findRankByScore(@NotNull Integer busType, @NotNull Long busId, @NotNull Double score) {
        List<BusinessrankVO> businessrankVOS = this.findRankVOList(busType, busId);
        BusinessrankVO busRank = null;
        BusinessrankVO tmpBusRank = null;
        int listSize = 0;
        if (businessrankVOS != null) {
            listSize = businessrankVOS.size();
            for (int i = 0; i < businessrankVOS.size(); ++i) {
                tmpBusRank = businessrankVOS.get(i);
                if (score >= tmpBusRank.getStartvalue().doubleValue() && score <= tmpBusRank.getEndvalue().doubleValue()) {
                    busRank = businessrankVOS.get(i);
                    break;
                }
                if (i != businessrankVOS.size() - 1 || busRank != null) continue;
                busRank = businessrankVOS.get(listSize - 1);
            }
        }
        return busRank;
    }

    @Override
    @Cacheable
    public List<BusinessrankVO> findRankVOList(@NotNull Integer busType, @NotNull Long busId) {
        BusinessrankQuery query = new BusinessrankQuery();
        query.setBusinesstype(busType);
        query.setBusinessId(busId);
        query.setDeleted(0);
        query.setColumns("BURK.BUSRANK_ID");
        query.getPage().setSortColumns("BURK.STARTVALUE,BURK.CREATEDATE");
        List businessRankList = this.businessrankPlusDao.findAll(query);
        List randIds = IdUtil.getIds((List)businessRankList, e -> e.getBusrankId());
        return this.findVOsByIds(randIds, BusinessrankVO.class);
    }

    @Override
    public List<BusinessrankVO> findVOList(@NotNull Integer busType, @NotNull Long busId) {
        BusinessrankQuery query = new BusinessrankQuery();
        query.setBusinesstype(busType);
        query.setBusinessId(busId);
        query.setDeleted(0);
        query.getPage().setSortColumns("BURK.STARTVALUE,BURK.CREATEDATE");
        List businessRankList = this.businessrankPlusDao.findAll(query);
        return ConvertUtil.convert((List)businessRankList, BusinessrankVO.class);
    }
}

