/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.point.bususerinfo.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.inc.IncUser;
import com.peak.prd.point.busrank.service.IBusinessrankPlusService;
import com.peak.prd.point.busrank.vo.BusinessrankVO;
import com.peak.prd.point.bususerinfo.bo.BusinessuserRankQueryBO;
import com.peak.prd.point.bususerinfo.bo.BusinessuserinfoQueryBO;
import com.peak.prd.point.bususerinfo.dao.IBusinessuserinfoPlusDao;
import com.peak.prd.point.bususerinfo.model.Businessuserinfo;
import com.peak.prd.point.bususerinfo.service.IBusinessuserinfoPlusService;
import com.peak.prd.point.bususerinfo.vo.BusinessuserRankMngVO;
import com.peak.prd.point.bususerinfo.vo.BusinessuserRankingListVO;
import com.peak.prd.point.bususerinfo.vo.BusinessuserRankingVO;
import com.peak.prd.point.bususerinfo.vo.BusinessuserinfoMngVO;
import com.peak.prd.point.bususerinfo.vo.BusinessuserinfoQuery;
import com.peak.prd.point.bususerinfo.vo.ExportBusinessuserRankMngVO;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.stereotype.Service;

@Service
public class BusinessuserinfoPlusService
extends PrdBaseService<Businessuserinfo, Long, BusinessuserinfoQuery>
implements IBusinessuserinfoPlusService {
    @Resource
    private IBusinessuserinfoPlusDao businessuserinfoPlusDao;
    @Resource
    private IBusinessrankPlusService businessrankPlusService;

    public IEntityDao<Businessuserinfo, Long, BusinessuserinfoQuery> getEntityDao() {
        return this.businessuserinfoPlusDao;
    }

    @Override
    public void updateUserTotalscoreAndRank(@NotNull Long userId, @NotNull Integer busType, @NotNull Long busId, @NotNull Double addscore) {
        BusinessuserinfoQuery query = new BusinessuserinfoQuery();
        query.setUserId(userId);
        query.setBusinesstype(busType);
        query.setBusinessId(busId);
        Businessuserinfo businessuserinfo = (Businessuserinfo)this.businessuserinfoPlusDao.findOne(query);
        if (businessuserinfo == null) {
            Long bususerinfoId = IdUtil.getSequence((String)"POINT_BUSINESSUSERINFO");
            businessuserinfo = new Businessuserinfo();
            businessuserinfo.setBususerinfoId(bususerinfoId);
            businessuserinfo.setBusinesstype(busType);
            businessuserinfo.setBusinessId(busId);
            businessuserinfo.setUserId(userId);
            businessuserinfo.setTotalscore(addscore);
            businessuserinfo.setCreatedate(new Date());
            this.businessuserinfoPlusDao.insert((BaseEntity)businessuserinfo);
        } else {
            Businessuserinfo businessuserinfoUpdate = new Businessuserinfo();
            businessuserinfoUpdate.setBususerinfoId(businessuserinfo.getBususerinfoId());
            businessuserinfoUpdate.setTotalscore(businessuserinfo.getTotalscore() == null ? addscore : businessuserinfo.getTotalscore() + addscore);
            this.businessuserinfoPlusDao.updateSelective(businessuserinfoUpdate);
        }
        businessuserinfo = (Businessuserinfo)this.businessuserinfoPlusDao.findOne(query);
        Double totalscore = businessuserinfo.getTotalscore();
        BusinessrankVO rank = this.businessrankPlusService.findRankByScore(busType, busId, totalscore);
        if (rank != null) {
            Businessuserinfo upBusinessuserinfo = new Businessuserinfo(businessuserinfo.getBususerinfoId());
            upBusinessuserinfo.setBusrankId(rank.getBusrankId());
            this.businessuserinfoPlusDao.updateSelective(upBusinessuserinfo);
        }
    }

    @Override
    public Paging<BusinessuserinfoMngVO> getMngVOList(@NotNull BusinessuserinfoQueryBO businessuserinfoQueryBO) {
        BusinessuserinfoQuery query = new BusinessuserinfoQuery(businessuserinfoQueryBO.getPageNumber(), businessuserinfoQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)businessuserinfoQueryBO), (Object)query);
        query.getPage().setSortColumns("BUUIF.CREATEDATE");
        Paging userinfoVOListPaging = this.businessuserinfoPlusDao.findPaging(query, "findUserPage", BusinessuserinfoMngVO.class);
        List userinfoVOList = userinfoVOListPaging.getList();
        if (userinfoVOList == null || userinfoVOList.isEmpty()) {
            return userinfoVOListPaging;
        }
        UserCoreUtil.setUserVO((List)userinfoVOList, BusinessuserinfoMngVO::getUserId, BusinessuserinfoMngVO::setUserVO);
        List busrankIdList = IdUtil.getIds((List)userinfoVOList, BusinessuserinfoMngVO::getBusrankId);
        List businessrankVOList = this.businessrankPlusService.findVOsByIds(busrankIdList, BusinessrankVO.class);
        ConvertUtil.setProperties((List)userinfoVOList, (List)businessrankVOList, (s, p) -> s.setBusinessrankVO((BusinessrankVO)p));
        return userinfoVOListPaging;
    }

    @Override
    public Paging<BusinessuserRankMngVO> getUserRankMngVOList(BusinessuserRankQueryBO businessuserRankQueryBO) {
        BusinessuserinfoQuery query = new BusinessuserinfoQuery(businessuserRankQueryBO.getPageNumber(), businessuserRankQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)businessuserRankQueryBO), (Object)query);
        query.getPage().setSortColumns("TOTALSCORE DESC");
        Paging businessuserRankListPaging = this.businessuserinfoPlusDao.findPaging(query, "findUserPage", BusinessuserRankMngVO.class);
        List businessuserRankVOList = businessuserRankListPaging.getList();
        if (businessuserRankVOList == null || businessuserRankVOList.isEmpty()) {
            return businessuserRankListPaging;
        }
        UserCoreUtil.setUserVO((List)businessuserRankVOList, BusinessuserRankMngVO::getUserId, BusinessuserRankMngVO::setUserVO);
        Integer lastordernum = businessuserRankQueryBO.getLastordernum();
        Integer[] integerArray = new Integer[1];
        integerArray[0] = businessuserRankQueryBO.getPageNumber() == 1 ? (lastordernum != null ? lastordernum : 0) : (lastordernum != null ? lastordernum : businessuserRankQueryBO.getPageNumber() * businessuserRankQueryBO.getPageSize());
        Integer[] ordernum = integerArray;
        Double[] lastscore = new Double[]{businessuserRankQueryBO.getPageNumber() == 1 ? 0.0 : (businessuserRankQueryBO.getLastscore() == null ? 0.0 : businessuserRankQueryBO.getLastscore())};
        businessuserRankVOList.forEach(up -> {
            if (up.getTotalscore().doubleValue() != lastscore[0].doubleValue()) {
                ordernum[0] = ordernum[0] + 1;
            }
            lastscore[0] = up.getTotalscore();
            up.setOrdernum(ordernum[0]);
        });
        return businessuserRankListPaging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportInfoVO asynExportUserRankList(BusinessuserRankQueryBO businessuserRankQueryBO) {
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(ExportBusinessuserRankMngVO.class);
        try {
            for (int pageNumber = 1; pageNumber < 5000; ++pageNumber) {
                businessuserRankQueryBO.setPageNumber(pageNumber);
                businessuserRankQueryBO.setPageSize(200);
                Map<String, Object> tpuserExcelModelMap = this.getUserRankListExcelWriteDataList(businessuserRankQueryBO);
                Long totalCount = (Long)tpuserExcelModelMap.get("totalCount");
                List writeDataList = (List)tpuserExcelModelMap.get("excelWriteModelList");
                excelWriteUtil.excelWrite("\u5b66\u5458\u79ef\u5206\u6392\u540d\u5217\u8868", writeDataList);
                if (!ListUtil.isNullorEmpty((List)writeDataList)) {
                    if ((long)(pageNumber * businessuserRankQueryBO.getPageSize()) <= totalCount) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (excelWriteUtil != null) {
                excelWriteUtil.finishWrite();
            }
        }
        ExportInfoVO exportInfoVO = new ExportInfoVO();
        exportInfoVO.setFilepath(excelWriteUtil.getExcelWritePath());
        return exportInfoVO;
    }

    private Map<String, Object> getUserRankListExcelWriteDataList(BusinessuserRankQueryBO businessuserRankQueryBO) {
        HashedMap tptemMap = new HashedMap();
        Paging<BusinessuserRankMngVO> businessuserRankMngVOPaging = this.getUserRankMngVOList(businessuserRankQueryBO);
        List businessuserRankMngVOList = businessuserRankMngVOPaging.getList();
        if (ListUtil.isNullorEmpty((List)businessuserRankMngVOList)) {
            tptemMap.put("excelWriteModelList", new ArrayList());
            tptemMap.put("totalCount", businessuserRankMngVOPaging.getTotalCount());
            return tptemMap;
        }
        ArrayList<ExportBusinessuserRankMngVO> exportBusinessuserRankMngVOList = new ArrayList<ExportBusinessuserRankMngVO>();
        for (BusinessuserRankMngVO businessuserRankMngVO : businessuserRankMngVOList) {
            ExportBusinessuserRankMngVO exportBusinessuserRankMngVO = (ExportBusinessuserRankMngVO)ConvertUtil.convert((Object)businessuserRankMngVO, ExportBusinessuserRankMngVO.class);
            ConvertUtil.copyProperties((Object)businessuserRankMngVO.getUserVO(), (Object)exportBusinessuserRankMngVO);
            exportBusinessuserRankMngVOList.add(exportBusinessuserRankMngVO);
        }
        tptemMap.put("excelWriteModelList", exportBusinessuserRankMngVOList);
        tptemMap.put("totalCount", businessuserRankMngVOPaging.getTotalCount());
        return tptemMap;
    }

    @Override
    public BusinessuserRankingListVO getCropUserScoreRanking(@NotNull Long userId, @NotNull Integer busType, @NotNull Long busId, @NotNull Long domainId, @NotNull Integer pageNumber, @NotNull Integer pageSize) {
        BusinessuserRankingListVO businessuserRankingListVO = new BusinessuserRankingListVO();
        businessuserRankingListVO.setRankingVOList(this.getUserScoreRankingList(busType, busId, domainId, pageNumber, pageSize));
        BusinessuserRankingVO userRankingVO = null;
        List<BusinessuserRankingVO> rankingVOList = businessuserRankingListVO.getRankingVOList();
        for (BusinessuserRankingVO businessuserRankingVO : rankingVOList) {
            if (!businessuserRankingVO.getUserId().equals(userId)) continue;
            userRankingVO = businessuserRankingVO;
        }
        if (userRankingVO == null && rankingVOList.size() > 0) {
            userRankingVO = this.getUserScoreRankingByList(userId, busType, busId, domainId);
        }
        businessuserRankingListVO.setUserRankingVO(userRankingVO);
        return businessuserRankingListVO;
    }

    private BusinessuserRankingVO getUserScoreRankingByList(@NotNull Long userId, @NotNull Integer busType, @NotNull Long busId, @NotNull Long domainId) {
        BusinessuserRankingVO userRankingVO = new BusinessuserRankingVO();
        for (int i = 0; i < 3; ++i) {
            List<BusinessuserRankingVO> rankingVOList = this.getUserScoreRankingList(busType, busId, domainId, i + 1, 100);
            for (BusinessuserRankingVO userprojectRankingVO : rankingVOList) {
                if (!userprojectRankingVO.getUserId().equals(userId)) continue;
                userRankingVO = userprojectRankingVO;
                userRankingVO.setUserVO(UserCoreUtil.getUserStuVO((Long)userId));
                return userRankingVO;
            }
        }
        userRankingVO = this.getUserScoreRankingByQuery(userId, busType, busId, domainId);
        return userRankingVO;
    }

    private List<BusinessuserRankingVO> getUserScoreRankingList(@NotNull Integer busType, @NotNull Long busId, @NotNull Long domainId, Integer pageNumber, Integer pageSize) {
        BusinessuserinfoQuery query = new BusinessuserinfoQuery(pageNumber, pageSize);
        query.setBusinesstype(busType);
        query.setBusinessId(busId);
        IncUser incUser = new IncUser();
        incUser.setOrgId(domainId);
        query.setIncUser(incUser);
        query.getPage().setSortColumns("TOTALSCORE DESC");
        Paging userRankingVOListPaging = this.businessuserinfoPlusDao.findPaging(query, "findUserPage", BusinessuserRankingVO.class);
        List userRankingVOList = userRankingVOListPaging.getList();
        if (userRankingVOList == null || userRankingVOList.isEmpty()) {
            return userRankingVOList;
        }
        int[] ordernum = new int[]{0};
        userRankingVOList.forEach(up -> {
            ordernum[0] = ordernum[0] == 0 ? ordernum[0] + (1 + (pageNumber - 1) * pageSize) : ordernum[0] + 1;
            up.setOrdernum(ordernum[0]);
            up.setUserVO(UserCoreUtil.getUserStuVO((Long)up.getUserId()));
        });
        return userRankingVOList;
    }

    private BusinessuserRankingVO getUserScoreRankingByQuery(@NotNull Long userId, @NotNull Integer busType, @NotNull Long busId, @NotNull Long domainId) {
        BusinessuserinfoQuery query = new BusinessuserinfoQuery();
        query.setBusinesstype(busType);
        query.setBusinessId(busId);
        query.setUserId(userId);
        IncUser incUser = new IncUser();
        incUser.setOrgId(domainId);
        query.setIncUser(incUser);
        query.getPage().setSortColumns("TOTALSCORE DESC");
        BusinessuserRankingVO userRankingVO = (BusinessuserRankingVO)this.businessuserinfoPlusDao.selectOne(query, "findUserScoreRanking");
        if (null == userRankingVO) {
            return null;
        }
        userRankingVO.setUserVO(UserCoreUtil.getUserStuVO((Long)userId));
        return userRankingVO;
    }
}

