/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.point.bususerscore.service.imple;

import com.peak.common.util.DateUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.point.bean.BusinessUserscoreSum;
import com.peak.prd.point.busevent.model.Businessevent;
import com.peak.prd.point.bususerinfo.service.IBusinessuserinfoPlusService;
import com.peak.prd.point.bususerscore.dao.IBusinessuserscorePlusDao;
import com.peak.prd.point.bususerscore.model.Businessuserscore;
import com.peak.prd.point.bususerscore.service.IBusinessuserscorePlusService;
import com.peak.prd.point.bususerscore.vo.BusinessuserscoreQuery;
import java.util.Date;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class BusinessuserscorePlusService
extends PrdBaseService<Businessuserscore, Long, BusinessuserscoreQuery>
implements IBusinessuserscorePlusService {
    @Resource
    private IBusinessuserscorePlusDao businessuserscorePlusDao;
    @Resource
    private IBusinessuserinfoPlusService businessuserinfoPlusService;

    public IEntityDao<Businessuserscore, Long, BusinessuserscoreQuery> getEntityDao() {
        return this.businessuserscorePlusDao;
    }

    @Override
    public Double addBusinessUserSpecifyscore(@NotNull Businessevent businessevent, @NotNull Long userId, @NotNull Integer busType, @NotNull Long busId, @NotNull Integer businessType, @NotNull Long businessId, @NotNull Date gainTime, Double score, String comments, Long scoreBusinessId) throws Exception {
        Double ret = 0.0;
        Long pointeventId = businessevent.getBuseventId();
        if (scoreBusinessId == null) {
            scoreBusinessId = businessId;
        }
        if (!this.needAddBusinessUserscore(businessevent, userId, busType, busId, businessType, scoreBusinessId)) {
            return ret;
        }
        Double pointeventScore = businessevent.getScore();
        Businessuserscore businessuserscore = new Businessuserscore();
        businessuserscore.setBususerscoreId(IPrimaryKey.DEFAULT.getSequence("POINT_BUSINESSUSERSCORE"));
        if (score != null) {
            businessuserscore.setScore(score);
        } else {
            businessuserscore.setScore(pointeventScore);
        }
        businessuserscore.setBusinesstype(busType);
        businessuserscore.setBusinessId(busId);
        businessuserscore.setBuseventId(pointeventId);
        businessuserscore.setUserId(userId);
        businessuserscore.setPointbusinesstype(businessType);
        businessuserscore.setPointbusinessId(scoreBusinessId);
        businessuserscore.setGaindate(gainTime);
        if (!StringUtil.isNullorEmptyStr((String)comments)) {
            businessuserscore.setComments(comments);
        } else {
            businessuserscore.setComments(StringUtil.isNullorEmptyStr((String)businessevent.getComments()) ? businessevent.getName() : businessevent.getComments());
        }
        this.insertBusinessUserscoreUserRank(businessuserscore);
        ret = pointeventScore;
        return ret;
    }

    private boolean needAddBusinessUserscore(Businessevent event, Long userId, Integer busType, Long busId, Integer businessType, Long businessId) {
        Double totaltascore;
        Long pointeventId = event.getBuseventId();
        Integer maxScore = event.getMaxscore();
        Integer cycleMaxscore = event.getCyclicMaxscore();
        Integer cycleMaxnum = event.getCyclicMaxnum();
        Integer limitOnce = event.getLimitonce();
        if ((maxScore == null || maxScore == 0) && this.checkIntegerIsNullOrZero(cycleMaxnum) && this.checkIntegerIsNullOrZero(cycleMaxscore) && this.checkIntegerIsNullOrZero(limitOnce)) {
            this.log.info((Object)"there is no limit");
            return true;
        }
        if (!this.checkIntegerIsNullOrZero(limitOnce)) {
            BusinessuserscoreQuery query = new BusinessuserscoreQuery();
            query.setBusinesstype(busType);
            query.setBusinessId(busId);
            query.setBuseventId(pointeventId);
            query.setUserId(userId);
            query.setPointbusinesstype(businessType);
            query.setPointbusinessId(businessId);
            Long usCount = this.businessuserscorePlusDao.count(query);
            if (usCount != null && usCount.intValue() > 0) {
                return false;
            }
        }
        if (maxScore != null && maxScore != 0 && (totaltascore = this.businessuserscorePlusDao.getTotalScoreByUserIdBusId(userId, busType, busId, pointeventId)) >= maxScore.doubleValue()) {
            return false;
        }
        if (!this.checkIntegerIsNullOrZero(cycleMaxscore) || !this.checkIntegerIsNullOrZero(event.getCyclicMaxnum())) {
            Integer cycleType = event.getCyclictype();
            Date today = DateUtil.toSDate((Date)new Date());
            Date cycleEnd = DateUtil.add((Date)today, (double)1.0);
            Date cycleBegin = null;
            switch (cycleType) {
                case 0: {
                    cycleBegin = DateUtil.minus((Date)cycleEnd, (double)1.0);
                    break;
                }
                case 1: {
                    cycleBegin = DateUtil.getFirstDayOfChineseWeek((Date)today);
                    break;
                }
                case 2: {
                    cycleBegin = DateUtil.getFirstDayOfMonth((Date)today);
                    break;
                }
                default: {
                    this.log.info((Object)"cycleType is null");
                }
            }
            BusinessUserscoreSum businessUserscoreSum = this.businessuserscorePlusDao.getUserScoreInDay(userId, busType, busId, cycleBegin, cycleEnd, pointeventId);
            Double score = businessUserscoreSum.getScore();
            Integer scoreCount = businessUserscoreSum.getScorenum();
            if (!this.checkIntegerIsNullOrZero(cycleMaxscore) && score >= cycleMaxscore.doubleValue()) {
                return false;
            }
            if (!this.checkIntegerIsNullOrZero(cycleMaxnum) && scoreCount >= cycleMaxnum) {
                return false;
            }
        }
        return true;
    }

    public void insertBusinessUserscoreUserRank(Businessuserscore businessuserscore) {
        this.businessuserscorePlusDao.insert((BaseEntity)businessuserscore);
        this.businessuserinfoPlusService.updateUserTotalscoreAndRank(businessuserscore.getUserId(), businessuserscore.getBusinesstype(), businessuserscore.getBusinessId(), businessuserscore.getScore());
    }

    private boolean checkIntegerIsNullOrZero(Integer num) {
        return num == null || num == 0;
    }
}

