/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.point.util;

import com.peak.common.util.SpringUtil;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.point.busevent.model.Businessevent;
import com.peak.prd.point.busevent.service.IBusinesseventPlusService;
import com.peak.prd.point.bususerscore.service.IBusinessuserscorePlusService;
import com.peak.prd.point.bususerscore.vo.BusinessuserscoreQuery;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class BusPointAddUtil {
    private static final Logger logger = LoggerFactory.getLogger(BusPointAddUtil.class);

    public static Double addBusinessScoreByEventRule(Integer busType, Long busId, String eventCode, Long userId, Integer businessType, Long businessId, Double score, Date gainTime, String comments, Long scoreBusinessId) throws Exception {
        Businessevent pointevent;
        Double ret = 0.0;
        if (eventCode == null || userId == null || busType == null || busId == null || businessType == null || businessId == null || gainTime == null) {
            return ret;
        }
        if (scoreBusinessId == null) {
            scoreBusinessId = businessId;
        }
        if ((pointevent = BusPointAddUtil.getBusinesseventPlusService().getPointeventByEventcode(eventCode, businessType, businessId)) == null) {
            return ret;
        }
        if (score == null) {
            score = (double)pointevent.getScore();
        }
        if (businessType.intValue() == BusinessOrigin.LESSON.getIndex()) {
            BusinessuserscoreQuery businessuserscoreQuery = new BusinessuserscoreQuery();
            businessuserscoreQuery.setBuseventId(pointevent.getBuseventId());
            businessuserscoreQuery.setBusinesstype(busType);
            businessuserscoreQuery.setBusinessId(busId);
            businessuserscoreQuery.setUserId(userId);
            businessuserscoreQuery.setBusinesstype(businessType);
            businessuserscoreQuery.setBusinessId(scoreBusinessId);
            Long existNum = BusPointAddUtil.getBusinessuserscorePlusService().count(businessuserscoreQuery);
            if (existNum > 0L) {
                logger.debug("\u7528\u6237 {} \u5f53\u524d\u4e1a\u52a1 {}==={} \u5185\u7684\u8bfe\u7a0b {} \u5df2\u6dfb\u52a0\u8fc7\u79ef\u5206", new Object[]{userId, busType, busId, businessId});
                return ret;
            }
            logger.debug("\u7528\u6237 {} \u5f53\u524d\u4e1a\u52a1 {}==={} \u5185\u7684\u8bfe\u7a0b {} \u6dfb\u52a0\u79ef\u5206 {}", new Object[]{userId, busType, busId, businessId, score});
            return BusPointAddUtil.getBusinessuserscorePlusService().addBusinessUserSpecifyscore(pointevent, userId, busType, busId, businessType, businessId, gainTime, score, comments, scoreBusinessId);
        }
        logger.debug("\u7528\u6237 {} \u5f53\u524d\u4e1a\u52a1 {}==={} \u5185\u7684\u4e1a\u52a1 {}==={} \u6dfb\u52a0\u79ef\u5206 {}", new Object[]{userId, busType, busId, businessType, businessId, score});
        ret = BusPointAddUtil.getBusinessuserscorePlusService().addBusinessUserSpecifyscore(pointevent, userId, busType, busId, businessType, businessId, gainTime, score, comments, scoreBusinessId);
        return ret;
    }

    public static Double addBusinessUserEventMultipleScore(Integer busType, Long busId, String eventCode, Long userId, Integer businessType, Long businessId, Integer multiple, Date gainTime, String comments, Long scoreBusinessId) throws Exception {
        Businessevent pointevent;
        Double ret = 0.0;
        if (eventCode == null || userId == null || busType == null || busId == null || businessType == null || businessId == null || gainTime == null) {
            return ret;
        }
        if (multiple == null) {
            multiple = 1;
        }
        if ((pointevent = BusPointAddUtil.getBusinesseventPlusService().getPointeventByEventcode(eventCode, businessType, businessId)) == null) {
            return ret;
        }
        Double eventScore = pointevent.getScore() * (double)multiple.intValue();
        ret = BusPointAddUtil.getBusinessuserscorePlusService().addBusinessUserSpecifyscore(pointevent, userId, busType, busId, businessType, businessId, gainTime, eventScore, comments, scoreBusinessId);
        return ret;
    }

    static IBusinessuserscorePlusService getBusinessuserscorePlusService() {
        return (IBusinessuserscorePlusService)SpringUtil.getBean(IBusinessuserscorePlusService.class);
    }

    static IBusinesseventPlusService getBusinesseventPlusService() {
        return (IBusinesseventPlusService)SpringUtil.getBean(IBusinesseventPlusService.class);
    }
}

