/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.common.attach.controller;

import com.peak.common.util.UploadFileUtil;
import com.peak.prd.base.annotation.ResPath;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.common.attach.bo.AttachBO;
import com.peak.prd.common.attach.bo.AttachQueryBO;
import com.peak.prd.common.attach.service.IAttachPlusService;
import com.peak.prd.common.attach.vo.AttachDetailVO;
import com.peak.prd.common.attach.vo.AttachVO;
import com.peak.prd.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ba1\u7406\u7aef-\u516c\u5171\u9644\u4ef6\u7ba1\u7406"})
@Validated
@RestController
@RequestMapping(value={"/mng/common/attach"}, produces={"application/json;charset=UTF-8"})
public class AttachMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AttachMngController.class);
    @Resource
    private IAttachPlusService attachPlusService;

    @ApiOperation(value="\u83b7\u5f97\u7ba1\u7406\u7aef\u516c\u5171\u9644\u4ef6\u5217\u8868")
    @PostMapping(value={"/getList"})
    @ResPath(value="attachpath", prefix="web/resource/")
    public ApiResult<Paging<AttachVO>> getList(@RequestBody @Valid AttachQueryBO attachQueryBO, HttpServletRequest request) throws Exception {
        Paging attachVOPaging = this.attachPlusService.getMngVOList(attachQueryBO);
        return ApiResult.okData((Object)attachVOPaging);
    }

    @ApiOperation(value="\u65b0\u589e\u516c\u5171\u9644\u4ef6")
    @PostMapping(value={"/insert"})
    public ApiResult<Long> insert(@Valid AttachBO attachBO, HttpServletRequest request) throws Exception {
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)attachBO.getFile(), (String)"attach/");
        attachBO.setAttachpath(uploadFile.getFullpath());
        return ApiResult.okData((Object)this.attachPlusService.insert(this.getUserId(request), attachBO));
    }

    @ApiOperation(value="\u4fee\u6539\u516c\u5171\u9644\u4ef6")
    @PostMapping(value={"/update"})
    public ApiResult<Integer> update(@Valid AttachBO attachBO, HttpServletRequest request) throws Exception {
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)attachBO.getFile(), (String)"attach/");
        attachBO.setAttachpath(uploadFile.getFullpath());
        return ApiResult.okData((Object)this.attachPlusService.update(attachBO));
    }

    @ApiOperation(value="\u4fee\u6539\u516c\u5171\u9644\u4ef6\u540d\u79f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="attachId", required=true, value="\u9644\u4ef6Id"), @ApiImplicitParam(name="name", required=true, value="\u540d\u79f0")})
    @PostMapping(value={"/updateName"})
    public ApiResult<Integer> updateName(@RequestParam(value="attachId", required=true) Long attachId, @RequestParam(value="name", required=true) String name, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.attachPlusService.updateName(attachId, name));
    }

    @ApiOperation(value="\u5220\u9664\u516c\u5171\u9644\u4ef6")
    @ApiImplicitParam(name="attachId", required=true, value="\u516c\u5171\u9644\u4ef6Id")
    @PostMapping(value={"/delete"})
    public ApiResult<Integer> delete(@RequestParam(value="attachId", required=true) Long attachId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.attachPlusService.delete(attachId));
    }

    @ApiOperation(value="\u83b7\u5f97\u516c\u5171\u9644\u4ef6\u8be6\u60c5")
    @ApiImplicitParam(name="attachId", required=true, value="\u516c\u5171\u9644\u4ef6Id")
    @PostMapping(value={"/getInfo"})
    @ResPath(value="attachpath", prefix="web/resource/")
    public ApiResult<AttachDetailVO> getInfo(@RequestParam(value="attachId", required=true) Long attachId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.attachPlusService.getInfo(attachId));
    }
}

