/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.common.webpage.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.common.webpage.bo.WebpageBO;
import com.peak.prd.common.webpage.bo.WebpageQueryBO;
import com.peak.prd.common.webpage.service.IWebpagePlusService;
import com.peak.prd.common.webpage.vo.WebpageVO;
import com.peak.prd.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ba1\u7406\u7aef-\u7cfb\u7edf\u7f51\u9875"})
@Validated
@RestController
@RequestMapping(value={"/mng/common/webpage"}, produces={"application/json;charset=UTF-8"})
public class WebpageMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(WebpageMngController.class);
    @Resource
    private IWebpagePlusService webpagePlusService;

    @ApiOperation(value="\u65b0\u589e\u7cfb\u7edf\u7f51\u9875")
    @PostMapping(value={"/insert"})
    public ApiResult<Long> insert(@RequestBody @Valid WebpageBO webpageBO, HttpServletRequest request) {
        return ApiResult.okData((Object)this.webpagePlusService.insert(this.getUserId(request), webpageBO));
    }

    @ApiOperation(value="\u4fee\u6539\u7cfb\u7edf\u7f51\u9875")
    @PostMapping(value={"/update"})
    public ApiResult<Integer> update(@RequestBody @Valid WebpageBO webpageBO, HttpServletRequest request) {
        return ApiResult.okData((Object)this.webpagePlusService.update(this.getUserId(request), webpageBO));
    }

    @ApiOperation(value="\u5220\u9664\u7cfb\u7edf\u7f51\u9875")
    @ApiImplicitParam(name="webpageId", required=true, value="\u4e3b\u952eID")
    @PostMapping(value={"/delete"})
    public ApiResult<Integer> delete(@RequestParam(name="webpageId") Long webpageId, HttpServletRequest request) {
        return ApiResult.okData((Object)this.webpagePlusService.delete(this.getUserId(request), webpageId));
    }

    @ApiOperation(value="\u83b7\u5f97\u7cfb\u7edf\u7f51\u9875\u8be6\u60c5")
    @ApiImplicitParam(name="webpageId", required=true, value="\u4e3b\u952eID")
    @PostMapping(value={"/getInfo"})
    public ApiResult<WebpageVO> getInfo(@RequestParam(name="webpageId") Long webpageId, HttpServletRequest request) {
        return ApiResult.okData((Object)this.webpagePlusService.getMngInfo(webpageId));
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1ID\u548c\u7c7b\u578b\u83b7\u5f97\u7cfb\u7edf\u7f51\u9875\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", required=true, value="\u4e1a\u52a1id"), @ApiImplicitParam(name="businesstype", required=true, value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/getMngInfoByBuidButype"})
    public ApiResult<WebpageVO> getMngInfoByBuidButype(@RequestParam(name="businessId") Long businessId, @RequestParam(name="businesstype") Integer businesstype) {
        return ApiResult.okData((Object)this.webpagePlusService.getByBusinessIdBusinessType(businessId, businesstype));
    }

    @ApiOperation(value="\u83b7\u5f97\u7cfb\u7edf\u7f51\u9875\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ApiResult<List<WebpageVO>> getList(@RequestBody @Valid WebpageQueryBO webpageQueryBO, HttpServletRequest request) {
        return ApiResult.okData((Object)this.webpagePlusService.getVOList(webpageQueryBO));
    }
}

