/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.enroll.controller;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.DownloadFileUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.controller.BaseController;
import com.peak.prd.enroll.enroll.bo.EnrollEnrollBO;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollVO;
import com.peak.prd.enroll.scope.service.IEnrollScopePlusService;
import com.peak.prd.enroll.scope.vo.EnrollScopeExcelResultVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ba1\u7406\u7aef-\u62a5\u540d\u7ba1\u7406"})
@RestController(value="mngenrollenrollcontroller")
@Validated
@RequestMapping(value={"/mng/enroll/enroll"}, produces={"application/json;charset=UTF-8"})
public class EnrollEnrollController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EnrollEnrollController.class);
    @Autowired
    private IEnrollEnrollPlusService enrollEnrollPlusService;
    @Autowired
    private IEnrollScopePlusService enrollScopePlusService;

    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u62a5\u540d\u4fe1\u606f\uff0c\u4e0d\u4f20enrollId\u5c31\u662f\u65b0\u589e\uff0c\u8fd4\u56de\u65b0\u589e\u7684\u62a5\u540did\uff0c\u4f20\u4e86enrollId\u5c31\u662f\u66f4\u65b0\uff0c\u8fd4\u56de\u66f4\u65b0\u7684\u884c\u6570")
    @PostMapping(value={"/update"})
    public ApiResult<Long> update(@RequestBody @Valid EnrollEnrollBO enrollEnrollBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollEnrollPlusService.txUpdate(enrollEnrollBO, this.getUserId(request), this.getMngDomainId(request)));
    }

    @ApiOperation(value="\u83b7\u5f97\u62a5\u540d\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", required=true, value="\u4e1a\u52a1Id"), @ApiImplicitParam(name="businessType", required=true, value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/getInfo"})
    public ApiResult<EnrollEnrollVO> getInfo(@RequestParam(value="businessId", required=true) Long businessId, @RequestParam(value="businessType", required=true) Integer businessType, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollEnrollPlusService.getInfo(businessId, businessType));
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5404\u5355\u4f4d\u96c6\u4e2d\u62a5\u540dexcel\u6a21\u677f")
    @GetMapping(value={"/downloadImportEnrollScopeTemplate"})
    public void downloadImportEnrollScopeTemplate(HttpServletResponse response) throws Exception {
        String tmpFilePath = "files/enroll/import_enrollscope_example.xlsx";
        DownloadFileUtil.downloadClassPathFile((String)tmpFilePath, (String)"import_enrollscope_example.xlsx", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5bfc\u5165\u5404\u5355\u4f4d\u96c6\u4e2d\u62a5\u540d\u540d\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrollId", required=false, value="\u62a5\u540did"), @ApiImplicitParam(name="enrollscopeExcelFile", required=true, value="\u8ba1\u5212\u57f9\u8bad\u73ed\u5bfc\u5165excel")})
    @PostMapping(value={"/importEnrollScopeList"})
    @ResponseBody
    public ApiResult<EnrollScopeExcelResultVO> importEnrollScopeList(@RequestParam(value="enrollId", required=false) Long enrollId, @RequestPart(value="enrollscopeExcelFile") MultipartFile enrollscopeExcelFile, HttpServletRequest request) throws Exception {
        UploadFile uploadFile = UploadFileUtil.upload((MultipartFile)enrollscopeExcelFile, (String)"enrollscopeimportexcel/", (boolean)true);
        String excelfilepath = AppPathUtil.getTempLocalPath() + uploadFile.getFullpath();
        EnrollScopeExcelResultVO enrollScopeExcelResultVO = this.enrollScopePlusService.txImportList(enrollId, excelfilepath, this.getUserId(request), this.getMngDomainId(request));
        return ApiResult.okData((Object)enrollScopeExcelResultVO);
    }
}

