/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.enroll.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.controller.BaseController;
import com.peak.prd.enroll.user.bo.EnrollUserAuditBO;
import com.peak.prd.enroll.user.bo.EnrollUserBO;
import com.peak.prd.enroll.user.bo.EnrollUserQueryBO;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enroll.user.vo.EnrollUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ba1\u7406\u7aef-\u62a5\u540d\u7ba1\u7406"})
@RestController(value="mngenrollusercontroller")
@Validated
@RequestMapping(value={"/mng/enroll/enrollUser"}, produces={"application/json;charset=UTF-8"})
public class EnrollUserController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EnrollUserController.class);
    @Autowired
    private IEnrollUserPlusService enrollUserPlusService;

    @ApiOperation(value="\u6279\u91cf\u7528\u6237\u62a5\u540d")
    @PostMapping(value={"/insertBatch"})
    public ApiResult<Integer> insertBatch(@RequestBody @Valid EnrollUserBO enrollUserBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.insertBatch(this.getUserId(request), enrollUserBO));
    }

    @ApiOperation(value="\u83b7\u5f97\u62a5\u540d\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ApiResult<Paging<EnrollUserVO>> getList(@RequestBody EnrollUserQueryBO enrollUserQueryBO, HttpServletRequest request) throws Exception {
        Paging euVOPaging = this.enrollUserPlusService.getVOList(enrollUserQueryBO);
        return ApiResult.okData((Object)euVOPaging);
    }

    @ApiOperation(value="\u83b7\u5f97\u672c\u57df\u96c6\u4e2d\u62a5\u540d\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/getDomainEnrollList"})
    public ApiResult<Paging<EnrollUserVO>> getDomainEnrollList(@RequestBody EnrollUserQueryBO enrollUserQueryBO, HttpServletRequest request) {
        Paging euVOPaging = this.enrollUserPlusService.getDomainEnrollList(enrollUserQueryBO, this.getMngDomainId(request));
        return ApiResult.okData((Object)euVOPaging);
    }

    @ApiOperation(value="\u65b0\u589e\u672c\u57df\u96c6\u4e2d\u62a5\u540d\u7528\u6237")
    @PostMapping(value={"/insertBatchDomain"})
    public ApiResult<Integer> insertBatchDomain(@RequestBody @Valid EnrollUserBO enrollUserBO, HttpServletRequest request) {
        return ApiResult.okData((Object)this.enrollUserPlusService.insertBatchDomain(this.getUserId(request), enrollUserBO, this.getMngDomainId(request)));
    }

    @ApiOperation(value="\u5220\u9664\u672c\u57df\u96c6\u4e2d\u62a5\u540d\u7528\u6237")
    @PostMapping(value={"/deleteBatchDomain"})
    public ApiResult<Integer> deleteBatchDomain(@RequestBody @Valid EnrollUserBO enrollUserBO, HttpServletRequest request) {
        return ApiResult.okData((Object)this.enrollUserPlusService.deleteBatchDomain(enrollUserBO, this.getMngDomainId(request)));
    }

    @ApiOperation(value="\u83b7\u5f97\u6210\u529f\u62a5\u540d\u7528\u6237\u6570\u91cf")
    @ApiImplicitParam(name="enrollId", required=true, value="\u62a5\u540dId")
    @PostMapping(value={"/getCount"})
    public ApiResult<Long> getCount(@RequestParam(value="enrollId", required=true) Long enrollId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.getCount(enrollId));
    }

    @ApiOperation(value="\u83b7\u5f97domainId\u57df\u6210\u529f\u62a5\u540d\u7528\u6237\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrollId", required=true, value="\u62a5\u540dId"), @ApiImplicitParam(name="domainId", required=false, value="\u57dfid\uff0c\u975e\u5fc5\u4f20\uff0c\u9ed8\u8ba4\u4e3a\u5f53\u524d\u57dfid")})
    @PostMapping(value={"/getDomainCount"})
    public ApiResult<Long> getDomainCount(@RequestParam(value="enrollId", required=true) Long enrollId, @RequestParam(value="domainId", required=false) Long domainId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.getCount(enrollId, domainId == null ? this.getMngDomainId(request) : domainId));
    }

    @ApiOperation(value="\u83b7\u5f97\u62a5\u540d\u88ab\u62d2\u7edd\u7528\u6237\u6570\u91cf")
    @ApiImplicitParam(name="enrollId", required=true, value="\u62a5\u540dId")
    @PostMapping(value={"/getRefusedCount"})
    public ApiResult<Long> getRefusedCount(@RequestParam(value="enrollId", required=true) Long enrollId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.getRefusedCount(enrollId));
    }

    @ApiOperation(value="\u83b7\u5f97\u88ab\u6307\u6d3e\u62a5\u540d\uff08\u4ee3\u62a5\u540d\uff09\u7684\u7528\u6237\u6570\u91cf")
    @ApiImplicitParam(name="enrollId", required=true, value="\u62a5\u540dId")
    @PostMapping(value={"/getAssignedCount"})
    public ApiResult<Long> getAssignedCount(@RequestParam(value="enrollId", required=true) Long enrollId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.getAssignedCount(enrollId));
    }

    @ApiOperation(value="\u4fee\u6539\u62a5\u540d\u7528\u6237\u5ba1\u6838\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="enrolluserId", required=true, value="\u62a5\u540d\u7528\u6237Id"), @ApiImplicitParam(name="status", required=true, value="\u5ba1\u6838\u72b6\u6001~2\uff1a\u62d2\u7edd\uff0c3\uff1a\u901a\u8fc7")})
    @PostMapping(value={"/updateStatus"})
    public ApiResult<Integer> updateStatus(@RequestParam(value="enrolluserId", required=true) Long enrolluserId, @RequestParam(value="status", required=true) Integer status, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.updateStatus(this.getUserId(request), enrolluserId, status));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u62a5\u540d\u7528\u6237\u5ba1\u6838\u72b6\u6001")
    @PostMapping(value={"/updateBatchStatus"})
    public ApiResult<Integer> updateBatchStatus(@RequestBody @Valid EnrollUserAuditBO enrollUserAuditBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.updateBatchStatus(this.getUserId(request), enrollUserAuditBO));
    }
}

