/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.lms.resourcecategory.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.controller.BaseController;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryBO;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryOrderNumBO;
import com.peak.prd.lms.resourcecategory.bo.ResourcecategoryRootBO;
import com.peak.prd.lms.resourcecategory.service.IResourcecategoryPlusService;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryDetailMngVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryMiniVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryMngVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategorySelectedVO;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ba1\u7406\u7aef-\u8d44\u6e90\u5206\u7c7b\u7ba1\u7406"})
@RestController(value="mngresourcecategorycontroller")
@Validated
@RequestMapping(value={"/mng/lms/resourcecategory/resourcecategory"}, produces={"application/json;charset=UTF-8"})
public class ResourcecategoryController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ResourcecategoryController.class);
    @Autowired
    private IResourcecategoryPlusService resourcecategoryPlusService;

    @ApiOperation(value="\u6839\u636e\u7236ID\u83b7\u5f97\u4e0b\u7ea7\u8d44\u6e90\u5206\u7c7b\u5217\u8868\u4fe1\u606f", notes="parentId=\u7c7b\u578b\uff0c1000\uff1a\u8bfe\u7a0b\uff0c1001\uff1a\u6587\u6863")
    @GetMapping(value={"/getListByParentId"})
    public ApiResult<List<ResourcecategoryVO>> getListByParentId(@RequestParam(value="parentId", defaultValue="1000") Long parentId, HttpServletRequest request) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Long domainId = this.getMngDomainId(request);
        ArrayList<Long> domainList = new ArrayList<Long>();
        domainList.add(domainId);
        List list = this.resourcecategoryPlusService.getChildrenVOsByParentId(parentId, domainList);
        return ApiResult.okData((Object)list);
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u5206\u7c7b")
    @PostMapping(value={"/insert"})
    public ApiResult<Long> insert(@RequestBody @Valid ResourcecategoryBO resourcecategoryBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.insert(this.getUserId(request), this.getMngDomainId(request), resourcecategoryBO));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u6839\u5206\u7c7b-\u7528\u4e8e\u4e13\u533a\u8bfe\u7a0b\u3001\u4e13\u533a\u4e13\u9898\u5206\u7c7b\u4f7f\u7528")
    @PostMapping(value={"/insertRoot"})
    public ApiResult<Long> insertRoot(@RequestBody @Valid ResourcecategoryRootBO resourcecategoryRootBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.insertRoot(this.getUserId(request), this.getMngDomainId(request), resourcecategoryRootBO));
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b")
    @PostMapping(value={"/update"})
    public ApiResult<Integer> update(@RequestBody @Valid ResourcecategoryBO resourcecategoryBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.txUpdate(resourcecategoryBO));
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u5206\u7c7b")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/delete"})
    public ApiResult<Integer> delete(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.delete(rescategoryId));
    }

    @ApiOperation(value="\u83b7\u5f97\u7ba1\u7406\u7aef\u8d44\u6e90\u5206\u7c7b\u8be6\u60c5")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getInfo"})
    public ApiResult<ResourcecategoryDetailMngVO> getInfo(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.getMngInfo(rescategoryId));
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getTreeList"})
    public ApiResult<List<ResourcecategoryMngVO>> getTreeList(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getMngTreeVOList(this.getMngDomainId(request), rescategoryRootId, true);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getTreeListByType"})
    public ApiResult<List<ResourcecategoryMngVO>> getTreeListByType(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getMngTreeVOList(this.getMngDomainId(request), rescategoryRootId, true, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getTreeListNoIncUp"})
    public ApiResult<List<ResourcecategoryMngVO>> getTreeListNoIncUp(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getMngTreeVOList(this.getMngDomainId(request), rescategoryRootId, false);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getTreeListNoIncUpByType"})
    public ApiResult<List<ResourcecategoryMngVO>> getTreeListNoIncUpByType(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getMngTreeVOList(this.getMngDomainId(request), rescategoryRootId, false, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u9009\u62e9\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getSelectedListNoIncUp"})
    public ApiResult<List<ResourcecategorySelectedVO>> getSelectedListNoIncUp(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getSelectedVOList(this.getMngDomainId(request), rescategoryRootId, false);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u9009\u62e9\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getSelectedListNoIncUpBytype"})
    public ApiResult<List<ResourcecategorySelectedVO>> getSelectedListNoIncUpBytype(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getSelectedVOList(this.getMngDomainId(request), rescategoryRootId, false, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u9009\u62e9\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getSelectedList"})
    public ApiResult<List<ResourcecategorySelectedVO>> getSelectedList(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getSelectedVOList(this.getMngDomainId(request), rescategoryRootId, true);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u8d44\u6e90\u5206\u7c7b\u9009\u62e9\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getSelectedListByType"})
    public ApiResult<List<ResourcecategorySelectedVO>> getSelectedListByType(@RequestParam(value="rescategoryId", required=true) Long rescategoryRootId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getSelectedVOList(this.getMngDomainId(request), rescategoryRootId, true, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u5b50\u8d44\u6e90\u5206\u7c7bmini\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e\uff0c\u4e0d\u5305\u542b\u5b50\u5b50\u5206\u7c7b")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getChildrenList"})
    public ApiResult<List<ResourcecategoryMiniVO>> getChildrenList(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getVOListByParentId(rescategoryId, this.getMngDomainId(request), true);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u5b50\u8d44\u6e90\u5206\u7c7bmini\u5217\u8868\uff0c\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e\uff0c\u4e0d\u5305\u542b\u5b50\u5b50\u5206\u7c7b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getChildrenListByType"})
    public ApiResult<List<ResourcecategoryMiniVO>> getChildrenListByType(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getVOListByParentId(rescategoryId, this.getMngDomainId(request), true, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u5b50\u8d44\u6e90\u5206\u7c7bmini\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e\uff0c\u4e0d\u5305\u542b\u5b50\u5b50\u5206\u7c7b")
    @ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID")
    @PostMapping(value={"/getChildrenListNoIncUp"})
    public ApiResult<List<ResourcecategoryMiniVO>> getChildrenListNoIncUp(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getVOListByParentId(rescategoryId, this.getMngDomainId(request), false);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u83b7\u5f97\u5b50\u8d44\u6e90\u5206\u7c7bmini\u5217\u8868\uff0c\u4e0d\u5305\u542b\u4e0a\u7ea7\u57df\u6570\u636e\uff0c\u4e0d\u5305\u542b\u5b50\u5b50\u5206\u7c7b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rescategoryId", required=true, value="\u8d44\u6e90\u5206\u7c7bID"), @ApiImplicitParam(name="type", required=false, value="\u8d44\u6e90\u7c7b\u578b")})
    @PostMapping(value={"/getChildrenListNoIncUpByType"})
    public ApiResult<List<ResourcecategoryMiniVO>> getChildrenListNoIncUpByType(@RequestParam(value="rescategoryId", required=true) Long rescategoryId, @RequestParam(value="type", required=false) String type, HttpServletRequest request) throws Exception {
        List resourcecategoryListVO = this.resourcecategoryPlusService.getVOListByParentId(rescategoryId, this.getMngDomainId(request), false, type);
        return ApiResult.okData((Object)resourcecategoryListVO);
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b\u6392\u5e8f\u6570\u636e")
    @PostMapping(value={"/updateOrderNum"})
    public ApiResult<Integer> updateOrderNum(@RequestBody @NotEmpty List<ResourcecategoryOrderNumBO> resourcecategoryOrderNumBOList, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.resourcecategoryPlusService.updateOrderNum(resourcecategoryOrderNumBOList));
    }
}

