/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.point.busevent.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.controller.BaseController;
import com.peak.prd.point.busevent.bo.BusinessEventBO;
import com.peak.prd.point.busevent.bo.BusinessEventQueryBO;
import com.peak.prd.point.busevent.bo.BusinessEventUpdateBO;
import com.peak.prd.point.busevent.service.IBusinesseventPlusService;
import com.peak.prd.point.busevent.vo.BusinessEventMngVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ba1\u7406\u7aef-\u516c\u5171\u79ef\u5206-\u4e1a\u52a1\u79ef\u5206\u8bbe\u7f6e-\u79ef\u5206\u89c4\u5219"})
@RestController
@Validated
@RequestMapping(value={"/mng/buspoint/pointevent"}, produces={"application/json;charset=UTF-8"})
public class BusinesseventMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BusinesseventMngController.class);
    @Resource
    private IBusinesseventPlusService businesseventPlusService;

    @ApiOperation(value="\u83b7\u5f97\u516c\u5171\u79ef\u5206\u89c4\u5219\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ApiResult<Paging<BusinessEventMngVO>> getList(@RequestBody BusinessEventQueryBO businessEventQueryBO, HttpServletRequest request) throws Exception {
        Paging pointeventPaging = this.businesseventPlusService.getMngVOList(businessEventQueryBO);
        return ApiResult.okData((Object)pointeventPaging);
    }

    @ApiOperation(value="\u65b0\u589e\u516c\u5171\u79ef\u5206\u89c4\u5219")
    @PostMapping(value={"/insert"})
    public ApiResult insert(@RequestBody @Valid BusinessEventBO businessEventBO, HttpServletRequest request) throws Exception {
        Integer ret = this.businesseventPlusService.insertEvent(this.getUserId(request), businessEventBO);
        if (ret == null) {
            return ApiResult.errMsg((String)"\u65b0\u589e\u79ef\u5206\u89c4\u5219\u5931\u8d25");
        }
        return ApiResult.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u516c\u5171\u79ef\u5206\u89c4\u5219")
    @PostMapping(value={"/update"})
    @ResponseBody
    public ApiResult<Integer> update(@RequestBody @Valid BusinessEventUpdateBO businessEventUpdateBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.businesseventPlusService.updateEvent(businessEventUpdateBO));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u516c\u5171\u79ef\u5206\u89c4\u5219")
    @ApiImplicitParam(name="buseventIds", required=true, value="\u516c\u5171\u79ef\u5206\u89c4\u5219Id\u5217\u8868")
    @PostMapping(value={"/deleteBatch"})
    public ApiResult<Integer> deleteBatch(@RequestBody @NotEmpty List<Long> buseventIds, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.businesseventPlusService.deleteBatch(buseventIds));
    }
}

