/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.point.busrank.controller;

import com.peak.prd.base.annotation.ResPath;
import com.peak.prd.base.annotation.ResPaths;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.controller.BaseController;
import com.peak.prd.point.busrank.bo.BusinessrankBO;
import com.peak.prd.point.busrank.bo.BusinessrankQueryBO;
import com.peak.prd.point.busrank.service.IBusinessrankPlusService;
import com.peak.prd.point.busrank.vo.BusinessrankMngVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ba1\u7406\u7aef-\u516c\u5171\u79ef\u5206-\u4e1a\u52a1\u79ef\u5206\u8bbe\u7f6e-\u79ef\u5206\u7b49\u7ea7"})
@RestController
@Validated
@RequestMapping(value={"/mng/buspoint/pointrank"}, produces={"application/json;charset=UTF-8"})
public class BusinessrankMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BusinessrankMngController.class);
    @Resource
    private IBusinessrankPlusService businessrankPlusService;

    @ApiOperation(value="\u83b7\u5f97\u516c\u5171\u79ef\u5206\u7b49\u7ea7\u5217\u8868")
    @PostMapping(value={"/getList"})
    @ResPaths(value={@ResPath(value="picfile", prefix="web/resource/"), @ResPath(value="userVO.photo")})
    public ApiResult<Paging<BusinessrankMngVO>> getList(@RequestBody BusinessrankQueryBO businessrankQueryBO, HttpServletRequest request) throws Exception {
        Paging pointrankPaging = this.businessrankPlusService.getMngVOList(businessrankQueryBO);
        return ApiResult.okData((Object)pointrankPaging);
    }

    @ApiOperation(value="\u65b0\u589e\u516c\u5171\u79ef\u5206\u7b49\u7ea7")
    @PostMapping(value={"/insert"})
    public ApiResult insert(@RequestBody @Valid BusinessrankBO businessrankBO, HttpServletRequest request) throws Exception {
        Long rankId = this.businessrankPlusService.insertRank(this.getUserId(request), businessrankBO);
        if (rankId == null) {
            return ApiResult.errMsg((String)"\u65b0\u589e\u79ef\u5206\u7b49\u7ea7\u5931\u8d25");
        }
        return ApiResult.okData((Object)rankId);
    }

    @ApiOperation(value="\u4fee\u6539\u516c\u5171\u79ef\u5206\u7b49\u7ea7")
    @PostMapping(value={"/update"})
    public ApiResult<Integer> update(@RequestBody @Valid BusinessrankBO businessrankBO, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.businessrankPlusService.updateRank(businessrankBO));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79ef\u5206\u7b49\u7ea7")
    @ApiImplicitParam(name="busrankIds", required=true, value="\u79ef\u5206\u7b49\u7ea7Id\u5217\u8868")
    @PostMapping(value={"/deleteBatch"})
    public ApiResult<Integer> deleteBatch(@RequestBody @NotEmpty List<Long> busrankIds, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.businessrankPlusService.deleteBatch(busrankIds));
    }
}

