/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.enroll.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.controller.BaseController;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollingVO;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enroll.user.vo.EnrollUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b66\u5458\u7aef-\u7528\u6237\u62a5\u540d"})
@RestController
@Validated
@RequestMapping(value={"/enroll/enrollUser"}, produces={"application/json;charset=UTF-8"})
public class EnrollUserController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EnrollUserController.class);
    @Autowired
    private IEnrollUserPlusService enrollUserPlusService;
    @Autowired
    private IEnrollEnrollPlusService enrollEnrollPlusService;

    @ApiOperation(value="\u67e5\u8be2\u5f85\u62a5\u540d\u5217\u8868\uff0c\u4e00\u6b21\u67e5\u51fa\u6240\u6709\u6570\u636e")
    @ApiImplicitParam(name="businessType", required=true, value="\u4e1a\u52a1\u7c7b\u578b")
    @PostMapping(value={"/getEnrollingList"})
    public ApiResult<List<EnrollingVO>> getEnrollingList(@RequestParam(name="businessType") Integer businessType, HttpServletRequest request) {
        return ApiResult.okData((Object)this.enrollEnrollPlusService.getEnrollingList(businessType, this.getUserId(request)));
    }

    @ApiOperation(value="\u67e5\u8be2\u57f9\u8bad\u73ed\u5f85\u62a5\u540d\u5217\u8868\uff0c\u4e00\u6b21\u67e5\u51fa\u6240\u6709\u6570\u636e")
    @ApiImplicitParam(name="statuses", required=false, value="\u57f9\u8bad\u73edstatus\u96c6\u5408\uff0c\u9017\u53f7\u5206\u9694\uff0c\u9ed8\u8ba4\u4e3a4")
    @PostMapping(value={"/getTpEnrollingList"})
    public ApiResult<List<EnrollingVO>> getTpEnrollingList(@RequestParam(name="statuses", required=false) String statuses, HttpServletRequest request) {
        return ApiResult.okData((Object)this.enrollEnrollPlusService.getTpEnrollingList(this.getUserId(request), statuses));
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u62a5\u540d\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", required=true, value="\u4e1a\u52a1Id"), @ApiImplicitParam(name="businessType", required=true, value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/getEnrollStatus"})
    public ApiResult<EnrollUserVO> getEnrollStatus(@RequestParam(value="businessId") Long businessId, @RequestParam(value="businessType") Integer businessType, HttpServletRequest request) {
        return ApiResult.okData((Object)this.enrollUserPlusService.getVOByEnrollIdAndUserId(businessId, businessType, this.getUserId(request)));
    }

    @ApiOperation(value="\u7528\u6237\u62a5\u540d\uff0c\u8fd4\u56de\u62a5\u540d\u72b6\u6001status, 0:\u5df2\u62a5\u540d,\u672a\u5ba1\u6279,1:\u62a5\u540d\u6210\u529f,2:\u5ba1\u6279\u4e0d\u901a\u8fc7,3:\u5ba1\u6279\u901a\u8fc7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", required=true, value="\u4e1a\u52a1Id"), @ApiImplicitParam(name="businessType", required=true, value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/insert"})
    public ApiResult<Integer> insert(@RequestParam(value="businessId", required=true) Long businessId, @RequestParam(value="businessType", required=true) Integer businessType, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.insert(this.getUserId(request), businessId, businessType));
    }

    @ApiOperation(value="\u64a4\u9500\u7528\u6237\u62a5\u540d\uff0c\u6210\u529f\u8fd4\u56de1\uff0c\u5931\u8d25\u8fd4\u56de0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", required=true, value="\u4e1a\u52a1Id"), @ApiImplicitParam(name="businessType", required=true, value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/delete"})
    public ApiResult<Integer> delete(@RequestParam(value="businessId", required=true) Long businessId, @RequestParam(value="businessType", required=true) Integer businessType, HttpServletRequest request) throws Exception {
        return ApiResult.okData((Object)this.enrollUserPlusService.delete(this.getUserId(request), businessId, businessType));
    }
}

