/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.lms.resourcecategory.controller;

import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.controller.BaseController;
import com.peak.prd.lms.resourcecategory.service.IResourcecategoryPlusService;
import com.peak.prd.lms.resourcecategory.vo.ResourcecategoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u5206\u7c7b"})
@RestController
@RequestMapping(value={"/lms/resourcecategory"}, produces={"application/json;charset=UTF-8"})
public class ResourcecategoryController
extends BaseController {
    @Autowired
    private IResourcecategoryPlusService resourcecategoryPlusService;

    @ApiOperation(value="\u6839\u636e\u7236ID\u83b7\u5f97\u4e0b\u7ea7\u8d44\u6e90\u5206\u7c7b\u5217\u8868\u4fe1\u606f", notes="parentId=\u7c7b\u578b\uff0c1000\uff1a\u8bfe\u7a0b\uff0c1001\uff1a\u6587\u6863")
    @GetMapping(value={"/getListByParentId"})
    public ApiResult<List<ResourcecategoryVO>> getListByParentId(@RequestParam(value="parentId", defaultValue="1000") Long parentId, HttpServletRequest request) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        List list = this.resourcecategoryPlusService.getChildrenVOsByParentId(parentId, UserCoreUtil.getAllDomainIdList((Long)this.getUserId(request)));
        return ApiResult.okData((Object)list);
    }

    @ApiOperation(value="\u83b7\u5f97\u4e13\u533a\u4e0b\u6240\u6709\u8bfe\u7a0b\u5206\u7c7b")
    @ApiImplicitParam(name="specialzoneId", required=true, value="\u4e13\u533aId")
    @PostMapping(value={"/getSpzLessonRescategory"})
    public ApiResult<List<ResourcecategoryVO>> getSpzLessonRescategory(@RequestParam(value="specialzoneId", required=true) Long specialzoneId) throws Exception {
        List resourcecategoryVOList = this.resourcecategoryPlusService.findSpzLessonRescategory(specialzoneId);
        return ApiResult.okData((Object)resourcecategoryVOList);
    }

    @ApiOperation(value="\u83b7\u5f97\u4e13\u533a\u4e0b\u6240\u6709\u4e13\u9898\u5206\u7c7b")
    @ApiImplicitParam(name="specialzoneId", required=true, value="\u4e13\u533aId")
    @PostMapping(value={"/getSpzRespkgRescategory"})
    public ApiResult<List<ResourcecategoryVO>> getSpzRespkgRescategory(@RequestParam(value="specialzoneId", required=true) Long specialzoneId) throws Exception {
        List resourcecategoryVOList = this.resourcecategoryPlusService.findSpzRespkgRescategory(specialzoneId);
        return ApiResult.okData((Object)resourcecategoryVOList);
    }
}

