/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.common.appdate.service.imple;

import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appdate.dao.IAppweekPlusDao;
import com.peak.prd.common.appdate.model.Appweek;
import com.peak.prd.common.appdate.service.IAppweekPlusService;
import com.peak.prd.common.appdate.service.imple.AppdatePlusService;
import com.peak.prd.common.appdate.vo.AppweekQuery;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppweekPlusService
extends PrdBaseService<Appweek, Map<String, Object>, AppweekQuery>
implements IAppweekPlusService {
    @Resource
    private IAppweekPlusDao appweekPlusDao;

    public IEntityDao<Appweek, Map<String, Object>, AppweekQuery> getEntityDao() {
        return this.appweekPlusDao;
    }

    @Override
    public int deleteAll() {
        return this.appweekPlusDao.deleteAll();
    }

    @Override
    public void initAppweek() {
        this.deleteAll();
        this.insertBatch(AppweekPlusService.getInitBatch());
    }

    private static List<Appweek> getInitBatch() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        Date today = AppdatePlusService.truncDay(new Date());
        ArrayList<Appweek> batch = new ArrayList<Appweek>();
        for (int i = -3650; i < 10950; i += 7) {
            Appweek model = new Appweek();
            c.setTime(today);
            c.add(5, i);
            c.setFirstDayOfWeek(2);
            c.set(7, 2);
            model.setWeekbegin(c.getTime());
            model.setWeekbeginymdint(Integer.parseInt(sdf.format(model.getWeekbegin())));
            model.setYearint(c.get(1));
            model.setWeeksn(c.get(3));
            c.add(5, 7);
            model.setWeekendexclude(c.getTime());
            c.add(5, -1);
            model.setWeekend000000(c.getTime());
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            model.setWeekend235959(c.getTime());
            batch.add(model);
        }
        return batch;
    }
}

