/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exam.common.dao.imple;

import com.peak.app.exam.common.dao.IExamResourceRelationDao;
import com.peak.app.exam.common.model.ExamResourceRelation;
import com.peak.app.exam.common.vo.ExamResourceRelationQuery;
import com.peak.framework.common.BaseIbatis3Dao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.exception.PrdBaseException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ExamResourceRelationDao
extends BaseIbatis3Dao<ExamResourceRelation, Long, ExamResourceRelationQuery>
implements IExamResourceRelationDao {
    public String getNamespace() {
        return "ExamResourceRelation";
    }

    private void _deleteByExamResourceID(List<Map> examResourceIDList) {
        for (int i = 0; i < examResourceIDList.size(); ++i) {
            Map params = examResourceIDList.get(i);
            this.getSqlSessionTemplate().delete(this.getNamespace() + ".deleteByExamResourceID", (Object)params);
        }
    }

    @Override
    public void deleteByExamResourceIdAndExamType(List<Long> examResourceIDList, IExamResourceRelationDao.EXAM_TYPE examType, Long resourceType) {
        this.deleteByExamResourceId(examResourceIDList, new Long(examType.value().intValue()), resourceType);
    }

    @Override
    public void deleteByExamResourceId(List<Long> examResourceIDList, Long examType, Long resourceType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("erList", examResourceIDList);
        params.put("examType", examType);
        params.put("resourceType", resourceType);
        this.getSqlSessionTemplate().delete(this.getNamespace() + ".deleteByExamResourceIdsAndExamType", params);
    }

    @Override
    public void deleteByExamResourceId(Long examResourceID, Long examType, Long resourceType) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("examResourceID", examResourceID);
        params.put("examType", examType);
        params.put("resourceType", resourceType);
        this.getSqlSessionTemplate().delete(this.getNamespace() + ".deleteByExamResourceIdAndExamType", params);
    }

    @Override
    public void deleteByExamResourceIdAndExamType(Long examResourceID, IExamResourceRelationDao.EXAM_TYPE examType, Long resourceType) {
        this.deleteByExamResourceId(examResourceID, new Long(examType.value().intValue()), resourceType);
    }

    @Override
    public ExamResourceRelation newRelation(Long examResourceId, Long resourceId, Long createId, IExamResourceRelationDao.EXAM_TYPE examType, IExamResourceRelationDao.RESOURCE_TYPE resourceType) {
        ExamResourceRelation relation = new ExamResourceRelation();
        try {
            relation.setRtId(IPrimaryKey.DEFAULT.getSequence("EXAM_RESOURCE_RELATION"));
        }
        catch (SQLException e) {
            throw new PrdBaseException("newRelation fail", (Exception)e);
        }
        relation.setCreateDate(new Date());
        relation.setCreatorId(createId);
        relation.setResourceType(resourceType.value());
        relation.setResourceId(resourceId);
        relation.setExamType(examType.value());
        relation.setExamResourceId(examResourceId);
        return relation;
    }

    @Override
    public List<Map> loadCateloByExamResourceId(Long examResourceId, Long examType) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("examResourceID", examResourceId);
        params.put("examType", examType);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".loadCategorpMapByExamResourceIDAndExamType", params);
    }

    @Override
    public List<ExamResourceRelation> loadByExamResourceId(Long examResourceId, IExamResourceRelationDao.EXAM_TYPE examType, IExamResourceRelationDao.RESOURCE_TYPE resourceType) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("examResourceID", examResourceId);
        params.put("examType", examType.value());
        params.put("resourceType", resourceType.value());
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".loadByExamResourceIDAndExamType", params);
    }

    @Override
    public Long loadParentIDByExamResourceId(Long examResourceId, IExamResourceRelationDao.EXAM_TYPE examType, IExamResourceRelationDao.RESOURCE_TYPE resourceType) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("examResourceID", examResourceId);
        params.put("examType", examType.value());
        params.put("resourceType", resourceType.value());
        return (Long)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".loadParentIDByExamResourceId", params);
    }

    @Override
    public List<Long> loadParentIdsByExamResourceIDAndExamType(Long examResourceId, IExamResourceRelationDao.EXAM_TYPE examType, IExamResourceRelationDao.RESOURCE_TYPE resourceType) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("examResourceID", examResourceId);
        params.put("examType", examType.value());
        params.put("resourceType", resourceType.value());
        return (List)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".loadParentIdsByExamResourceIDAndExamType", params);
    }
}

