/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exam.exampaper.service.imple;

import com.peak.app.exam.exampaper.dao.IExamPaperDifficultyDao;
import com.peak.app.exam.exampaper.dao.IExamPaperHavequesDao;
import com.peak.app.exam.exampaper.dao.IExamPaperTypeDao;
import com.peak.app.exam.exampaper.model.ExamPaperDifficulty;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.service.IExamPaperDifficultyService;
import com.peak.app.exam.exampaper.vo.ExamPaperDifficultyQuery;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperDifficultyService
extends BaseService<ExamPaperDifficulty, Long, ExamPaperDifficultyQuery>
implements IExamPaperDifficultyService {
    private IExamPaperDifficultyDao examPaperDifficultyDao;
    private IExamPaperTypeDao examPaperTypeDao;
    private IExamPaperHavequesDao examPaperHavequesDao;

    public void setExamPaperHavequesDao(IExamPaperHavequesDao examPaperHavequesDao) {
        this.examPaperHavequesDao = examPaperHavequesDao;
    }

    public void setExamPaperDifficultyDao(IExamPaperDifficultyDao dao) {
        this.examPaperDifficultyDao = dao;
    }

    public IExamPaperDifficultyDao getExamPaperDifficultyDao() {
        return this.examPaperDifficultyDao;
    }

    public IEntityDao<ExamPaperDifficulty, Long, ExamPaperDifficultyQuery> getEntityDao() {
        return this.examPaperDifficultyDao;
    }

    public void setExamPaperTypeDao(IExamPaperTypeDao dao) {
        this.examPaperTypeDao = dao;
    }

    public IExamPaperTypeDao getExamPaperTypeDao() {
        return this.examPaperTypeDao;
    }

    @Override
    public boolean txInsert(List<ExamPaperType> listPaperType, List<ExamPaperDifficulty> listPaperDifficulty, Long paperId, boolean isOneExamPaperType) {
        String typeIds = "";
        if (listPaperType != null && listPaperType.size() > 0) {
            for (int i = 0; i < listPaperType.size(); ++i) {
                ExamPaperType one = new ExamPaperType();
                one = listPaperType.get(i);
                typeIds = typeIds + one.getTypeId() + ",";
            }
            if (typeIds.endsWith(",")) {
                typeIds = typeIds.substring(0, typeIds.length() - 1);
            }
        } else {
            return true;
        }
        HashMap<String, Long> mapDelete = new HashMap<String, Long>();
        mapDelete.put("paperId", paperId);
        if (!isOneExamPaperType) {
            this.examPaperTypeDao.deleteByPaperId(mapDelete);
            this.examPaperDifficultyDao.deleteByPaperId(paperId);
        } else {
            mapDelete.put("typeId", new Long(typeIds));
            this.examPaperTypeDao.deleteByPaperId(mapDelete);
            this.examPaperDifficultyDao.deleteByPaperAndTypeId(paperId, new Long(typeIds));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("typeIds", typeIds);
        map.put("paperId", paperId);
        this.examPaperHavequesDao.deleteByQuestionType(map);
        this.examPaperTypeDao.insert(listPaperType);
        this.examPaperDifficultyDao.insert(listPaperDifficulty);
        return true;
    }

    @Override
    public Map<String, Integer> getPaperTypeDifficultyInfo(Long paperId) {
        List<ExamPaperDifficulty> list = this.examPaperDifficultyDao.getPaperTypeDifficultyInfo(paperId);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExamPaperDifficulty one = list.get(i);
                Long typeId = one.getTypeId();
                Integer diff1Num = one.getDiff1Num();
                Integer diff2Num = one.getDiff2Num();
                Integer diff3Num = one.getDiff3Num();
                Integer diff4Num = one.getDiff4Num();
                Integer diff5Num = one.getDiff5Num();
                if (diff1Num != null) {
                    map.put(typeId + "_1", diff1Num);
                }
                if (diff2Num != null) {
                    map.put(typeId + "_2", diff2Num);
                }
                if (diff3Num != null) {
                    map.put(typeId + "_3", diff3Num);
                }
                if (diff4Num != null) {
                    map.put(typeId + "_4", diff4Num);
                }
                if (diff5Num == null) continue;
                map.put(typeId + "_5", diff5Num);
            }
        }
        return map;
    }

    @Override
    public boolean txDeleteOneExamPaperType(Long paperId, Long typeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("paperId", paperId);
        map.put("typeId", typeId);
        this.examPaperTypeDao.deleteByPaperId(map);
        this.examPaperDifficultyDao.deleteByPaperAndTypeId(paperId, typeId);
        return true;
    }

    @Override
    public void deleteByPaper(Long paperId) {
        this.examPaperDifficultyDao.deleteByPaperId(paperId);
    }
}

