/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exam.exampaper.service.imple;

import com.peak.app.exam.exampaper.dao.IExamPaperKnowledgeDao;
import com.peak.app.exam.exampaper.dao.IExamPaperKnowledgeDiffiDao;
import com.peak.app.exam.exampaper.model.ExamPaperKnowledge;
import com.peak.app.exam.exampaper.model.ExamPaperKnowledgeDiffi;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.model.KnowledgeDiffPercentInfo;
import com.peak.app.exam.exampaper.service.IExamPaperKnowledgeDiffiService;
import com.peak.app.exam.exampaper.vo.ExamPaperKnowledgeDiffiQuery;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperKnowledgeDiffiService
extends BaseService<ExamPaperKnowledgeDiffi, Long, ExamPaperKnowledgeDiffiQuery>
implements IExamPaperKnowledgeDiffiService {
    private IExamPaperKnowledgeDiffiDao examPaperKnowledgeDiffiDao;
    private IExamPaperKnowledgeDao examPaperKnowledgeDao;

    public void setExamPaperKnowledgeDiffiDao(IExamPaperKnowledgeDiffiDao dao) {
        this.examPaperKnowledgeDiffiDao = dao;
    }

    public void setExamPaperKnowledgeDao(IExamPaperKnowledgeDao examPaperKnowledgeDao) {
        this.examPaperKnowledgeDao = examPaperKnowledgeDao;
    }

    public IExamPaperKnowledgeDiffiDao getExamPaperKnowledgeDiffiDao() {
        return this.examPaperKnowledgeDiffiDao;
    }

    public IEntityDao<ExamPaperKnowledgeDiffi, Long, ExamPaperKnowledgeDiffiQuery> getEntityDao() {
        return this.examPaperKnowledgeDiffiDao;
    }

    @Override
    public void txInsert(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi, String paperId, String typeId, List<ExamPaperKnowledge> listExamPaperKnowledge, String selectedKnowledgeIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("paperId", paperId);
        map.put("typeId", typeId);
        map.put("knowledgeIds", selectedKnowledgeIds);
        this.examPaperKnowledgeDiffiDao.delete(map);
        this.examPaperKnowledgeDao.deleteByPaperAndKnowledgeId(new Long(paperId), selectedKnowledgeIds);
        this.examPaperKnowledgeDao.insert(listExamPaperKnowledge);
        this.examPaperKnowledgeDiffiDao.insert(listExamPaperKnowledgeDiffi);
    }

    @Override
    public Map<String, Integer> getExamPaperKnowledgeDiffi(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi) {
        HashMap<String, Integer> rtnMap = new HashMap<String, Integer>();
        if (listExamPaperKnowledgeDiffi != null && listExamPaperKnowledgeDiffi.size() > 0) {
            for (int i = 0; i < listExamPaperKnowledgeDiffi.size(); ++i) {
                ExamPaperKnowledgeDiffi one = new ExamPaperKnowledgeDiffi();
                one = listExamPaperKnowledgeDiffi.get(i);
                Long knowledgeId = one.getKnowledgeId();
                Long typeId = one.getTypeId();
                Integer diff1Percent = one.getDiff1Percent();
                Integer diff2Percent = one.getDiff2Percent();
                Integer diff3Percent = one.getDiff3Percent();
                Integer diff4Percent = one.getDiff4Percent();
                Integer diff5Percent = one.getDiff5Percent();
                if (typeId != null) {
                    if (diff1Percent != null) {
                        rtnMap.put(knowledgeId + "_" + typeId + "_1", diff1Percent);
                    }
                    if (diff2Percent != null) {
                        rtnMap.put(knowledgeId + "_" + typeId + "_2", diff2Percent);
                    }
                    if (diff3Percent != null) {
                        rtnMap.put(knowledgeId + "_" + typeId + "_3", diff3Percent);
                    }
                    if (diff4Percent != null) {
                        rtnMap.put(knowledgeId + "_" + typeId + "_4", diff4Percent);
                    }
                    if (diff5Percent == null) continue;
                    rtnMap.put(knowledgeId + "_" + typeId + "_5", diff5Percent);
                    continue;
                }
                if (typeId != null) continue;
                if (diff1Percent != null) {
                    rtnMap.put(knowledgeId + "__1", diff1Percent);
                }
                if (diff2Percent != null) {
                    rtnMap.put(knowledgeId + "__2", diff2Percent);
                }
                if (diff3Percent != null) {
                    rtnMap.put(knowledgeId + "__3", diff3Percent);
                }
                if (diff4Percent != null) {
                    rtnMap.put(knowledgeId + "__4", diff4Percent);
                }
                if (diff5Percent == null) continue;
                rtnMap.put(knowledgeId + "__5", diff5Percent);
            }
        }
        return rtnMap;
    }

    private Map<Long, Integer> getTypeNum(List<ExamPaperType> listPaperTypeInfo, String strTypeId) {
        HashMap<Long, Integer> mapTypeNum = new HashMap<Long, Integer>();
        if (listPaperTypeInfo != null && listPaperTypeInfo.size() > 0) {
            for (int i = 0; i < listPaperTypeInfo.size(); ++i) {
                ExamPaperType one = new ExamPaperType();
                one = listPaperTypeInfo.get(i);
                String TYPEID = one.getTypeId().toString();
                String NUM = one.getNum().toString();
                if (!strTypeId.equals(TYPEID)) continue;
                mapTypeNum.put(new Long(TYPEID), new Integer(NUM));
                break;
            }
        }
        return mapTypeNum;
    }

    @Override
    public Map<String, KnowledgeDiffPercentInfo> getExamPaperKnowledgeDiffiCountByType(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi, List<ExamPaperType> listPaperTypeInfo, String strTypeId, Map mapKnowledgeTypeDiff, Map<String, KnowledgeDiffPercentInfo> mapCount, Map<String, Long> mapPaperTypeHaveQuesCount, boolean isNeedHaveQuesCount) {
        Map<Long, Integer> mapTypeNum = this.getTypeNum(listPaperTypeInfo, strTypeId);
        List<KnowledgeDiffPercentInfo> listKnowledgeTypePercentBySort = this.getExamPaperKnowledgeDiffiBySort(listExamPaperKnowledgeDiffi, new Long(strTypeId == null || strTypeId.equals("") ? "-1" : strTypeId));
        Map<Object, Object> mapKnowledgeTypeDiffCount = new HashMap();
        if (isNeedHaveQuesCount) {
            mapKnowledgeTypeDiffCount = this.getKnowledgeTypeDiffCountByAllKnowledge(mapKnowledgeTypeDiff);
        }
        DecimalFormat df = new DecimalFormat("#");
        int num = 0;
        double temp = 0.0;
        String needNum = "0";
        if (!strTypeId.equals("")) {
            int count = 0;
            num = mapTypeNum.get(new Long(strTypeId));
            Long haveQuesCount = new Long(0L);
            if (mapPaperTypeHaveQuesCount.containsKey(strTypeId) && (haveQuesCount = mapPaperTypeHaveQuesCount.get(strTypeId)).intValue() > 0) {
                num -= haveQuesCount.intValue();
            }
            for (int i = 0; i < listKnowledgeTypePercentBySort.size(); ++i) {
                KnowledgeDiffPercentInfo one = new KnowledgeDiffPercentInfo();
                one = listKnowledgeTypePercentBySort.get(i);
                String key = one.getKey();
                if (key.indexOf("_" + strTypeId + "_") == -1) continue;
                Integer percent = one.getPercent();
                if (i < listKnowledgeTypePercentBySort.size() - 1) {
                    temp = percent * num / 100;
                    needNum = df.format(temp);
                    count += Integer.parseInt(needNum);
                } else if (i == listKnowledgeTypePercentBySort.size() - 1) {
                    needNum = num - count + "";
                }
                if (percent == 0) {
                    needNum = "0";
                }
                one.setKey(key);
                one.setNeedNum(new Integer(needNum));
                one.setHaveCount((Integer)mapKnowledgeTypeDiffCount.get(key));
                String[] arrayKey = key.split("_");
                if (arrayKey != null && arrayKey.length == 3) {
                    one.setKnowledgeId(new Long(arrayKey[0]));
                    one.setTypeId(new Long(strTypeId));
                    one.setDifficulty(new Integer(arrayKey[2]));
                }
                mapCount.put(key, one);
            }
        }
        return mapCount;
    }

    @Override
    public Map<String, KnowledgeDiffPercentInfo> getExamPaperKnowledgeDiffiAutoParam(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi, List<ExamPaperType> listPaperTypeInfo, Map mapKnowledgeTypeDiff, Map<String, Long> mapPaperTypeHaveQuesCount, boolean isNeedHaveQuesCount) {
        Map<String, KnowledgeDiffPercentInfo> mapCount = new HashMap<String, KnowledgeDiffPercentInfo>();
        for (int i = 0; i < listPaperTypeInfo.size(); ++i) {
            ExamPaperType one = new ExamPaperType();
            one = listPaperTypeInfo.get(i);
            String TYPEID = one.getTypeId().toString();
            mapCount = this.getExamPaperKnowledgeDiffiCountByType(listExamPaperKnowledgeDiffi, listPaperTypeInfo, TYPEID, mapKnowledgeTypeDiff, mapCount, mapPaperTypeHaveQuesCount, isNeedHaveQuesCount);
        }
        return mapCount;
    }

    @Override
    public Map<String, KnowledgeDiffPercentInfo> getExamPaperKnowledgeDiffiCount(List<ExamPaperKnowledge> listExamPaperKnowledge, List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi, List<ExamPaperType> listPaperTypeInfo, String strTypeId, Map mapKnowledgeTypeDiff, Map<String, Long> mapPaperTypeHaveQuesCount, boolean isNeedHaveQuesCount) {
        Map<String, KnowledgeDiffPercentInfo> mapCount = new HashMap<String, KnowledgeDiffPercentInfo>();
        for (int i = 0; i < listPaperTypeInfo.size(); ++i) {
            ExamPaperType one = new ExamPaperType();
            one = listPaperTypeInfo.get(i);
            String TYPEID = one.getTypeId().toString();
            mapCount = this.getExamPaperKnowledgeDiffiCountByType(listExamPaperKnowledgeDiffi, listPaperTypeInfo, TYPEID, mapKnowledgeTypeDiff, mapCount, mapPaperTypeHaveQuesCount, isNeedHaveQuesCount);
        }
        HashMap<String, KnowledgeDiffPercentInfo> rtnMapCount = new HashMap<String, KnowledgeDiffPercentInfo>();
        for (int i = 0; i < listExamPaperKnowledge.size(); ++i) {
            ExamPaperKnowledge oneExamPaperKnowledge = new ExamPaperKnowledge();
            oneExamPaperKnowledge = listExamPaperKnowledge.get(i);
            Long knowledgeId = oneExamPaperKnowledge.getKnowledgeId();
            for (int j = 1; j <= 5; ++j) {
                int needNum = 0;
                int haveCount = 0;
                String tempKey = "";
                KnowledgeDiffPercentInfo oneKnowledgeDiffPercentInfo = new KnowledgeDiffPercentInfo();
                for (int k = 0; k < listPaperTypeInfo.size(); ++k) {
                    ExamPaperType one = new ExamPaperType();
                    one = listPaperTypeInfo.get(k);
                    String TYPEID = one.getTypeId().toString();
                    tempKey = knowledgeId + "_" + TYPEID + "_" + j;
                    if (!mapCount.containsKey(tempKey)) break;
                    oneKnowledgeDiffPercentInfo = mapCount.get(tempKey);
                    needNum += (oneKnowledgeDiffPercentInfo.getNeedNum() == null ? new Integer(0) : oneKnowledgeDiffPercentInfo.getNeedNum()).intValue();
                    haveCount += (oneKnowledgeDiffPercentInfo.getHaveCount() == null ? new Integer(0) : oneKnowledgeDiffPercentInfo.getHaveCount()).intValue();
                }
                if (!mapCount.containsKey(tempKey)) continue;
                oneKnowledgeDiffPercentInfo.setNeedNum(new Integer(needNum));
                oneKnowledgeDiffPercentInfo.setHaveCount(new Integer(haveCount));
                oneKnowledgeDiffPercentInfo.setKey(knowledgeId + "__" + j);
                rtnMapCount.put(knowledgeId + "__" + j, oneKnowledgeDiffPercentInfo);
            }
        }
        return rtnMapCount;
    }

    private List<KnowledgeDiffPercentInfo> getExamPaperKnowledgeDiffiBySort(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi) {
        HashMap rtnMap = new HashMap();
        ArrayList<KnowledgeDiffPercentInfo> listKnowledgeTypePercent = new ArrayList<KnowledgeDiffPercentInfo>();
        if (listExamPaperKnowledgeDiffi != null && listExamPaperKnowledgeDiffi.size() > 0) {
            for (int i = 0; i < listExamPaperKnowledgeDiffi.size(); ++i) {
                Integer diff5Percent;
                ExamPaperKnowledgeDiffi one = new ExamPaperKnowledgeDiffi();
                one = listExamPaperKnowledgeDiffi.get(i);
                KnowledgeDiffPercentInfo keyValue = new KnowledgeDiffPercentInfo();
                Long knowledgeId = one.getKnowledgeId();
                Long typeId = one.getTypeId();
                Integer diff1Percent = one.getDiff1Percent() == null ? new Integer(0) : one.getDiff1Percent();
                Integer diff2Percent = one.getDiff2Percent() == null ? new Integer(0) : one.getDiff2Percent();
                Integer diff3Percent = one.getDiff3Percent() == null ? new Integer(0) : one.getDiff3Percent();
                Integer diff4Percent = one.getDiff4Percent() == null ? new Integer(0) : one.getDiff4Percent();
                Integer n = diff5Percent = one.getDiff5Percent() == null ? new Integer(0) : one.getDiff5Percent();
                if (typeId != null) {
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_1");
                    keyValue.setPercent(diff1Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_2");
                    keyValue.setPercent(diff2Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_3");
                    keyValue.setPercent(diff3Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_4");
                    keyValue.setPercent(diff4Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_5");
                    keyValue.setPercent(diff5Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    continue;
                }
                if (typeId != null) continue;
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__1");
                keyValue.setPercent(diff1Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__2");
                keyValue.setPercent(diff2Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__3");
                keyValue.setPercent(diff3Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__4");
                keyValue.setPercent(diff4Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__5");
                keyValue.setPercent(diff5Percent);
                listKnowledgeTypePercent.add(keyValue);
            }
        }
        Collections.sort(listKnowledgeTypePercent, new KnowledgeDiffPercentInfo());
        return listKnowledgeTypePercent;
    }

    private List<KnowledgeDiffPercentInfo> getExamPaperKnowledgeDiffiBySort(List<ExamPaperKnowledgeDiffi> listExamPaperKnowledgeDiffi, Long l_typeId) {
        HashMap rtnMap = new HashMap();
        ArrayList<KnowledgeDiffPercentInfo> listKnowledgeTypePercent = new ArrayList<KnowledgeDiffPercentInfo>();
        if (listExamPaperKnowledgeDiffi != null && listExamPaperKnowledgeDiffi.size() > 0) {
            for (int i = 0; i < listExamPaperKnowledgeDiffi.size(); ++i) {
                Integer diff5Percent;
                ExamPaperKnowledgeDiffi one = new ExamPaperKnowledgeDiffi();
                one = listExamPaperKnowledgeDiffi.get(i);
                KnowledgeDiffPercentInfo keyValue = new KnowledgeDiffPercentInfo();
                Long knowledgeId = one.getKnowledgeId();
                Long typeId = one.getTypeId();
                Integer diff1Percent = one.getDiff1Percent() == null ? new Integer(0) : one.getDiff1Percent();
                Integer diff2Percent = one.getDiff2Percent() == null ? new Integer(0) : one.getDiff2Percent();
                Integer diff3Percent = one.getDiff3Percent() == null ? new Integer(0) : one.getDiff3Percent();
                Integer diff4Percent = one.getDiff4Percent() == null ? new Integer(0) : one.getDiff4Percent();
                Integer n = diff5Percent = one.getDiff5Percent() == null ? new Integer(0) : one.getDiff5Percent();
                if (typeId != null && typeId.longValue() == l_typeId.longValue()) {
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_1");
                    keyValue.setPercent(diff1Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_2");
                    keyValue.setPercent(diff2Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_3");
                    keyValue.setPercent(diff3Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_4");
                    keyValue.setPercent(diff4Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    keyValue = new KnowledgeDiffPercentInfo();
                    keyValue.setKey(knowledgeId + "_" + typeId + "_5");
                    keyValue.setPercent(diff5Percent);
                    listKnowledgeTypePercent.add(keyValue);
                    continue;
                }
                if (typeId != null) continue;
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__1");
                keyValue.setPercent(diff1Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__2");
                keyValue.setPercent(diff2Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__3");
                keyValue.setPercent(diff3Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__4");
                keyValue.setPercent(diff4Percent);
                listKnowledgeTypePercent.add(keyValue);
                keyValue = new KnowledgeDiffPercentInfo();
                keyValue.setKey(knowledgeId + "__5");
                keyValue.setPercent(diff5Percent);
                listKnowledgeTypePercent.add(keyValue);
            }
        }
        Collections.sort(listKnowledgeTypePercent, new KnowledgeDiffPercentInfo());
        return listKnowledgeTypePercent;
    }

    @Override
    public Map<String, Long> getKnowledgeTypeDiffCount(Map map) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.getKnowledgeTypeDiffCount(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        if (list == null || list.size() == 0) {
            return countMap;
        }
        for (int i = 0; i < list.size(); ++i) {
            one = (HashMap)list.get(i);
            String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
            String DIFFICULTY = one.get("DIFFICULTY") == null ? "" : (String)one.get("DIFFICULTY");
            String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
            countMap.put(TYPEID + "_" + DIFFICULTY, new Long(COUNT));
        }
        return countMap;
    }

    @Override
    public Map<Long, Long> getKnowledgeTypeCount(Map map) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.getKnowledgeTypeCount(map);
        HashMap<Long, Long> countMap = new HashMap<Long, Long>();
        if (list == null || list.size() == 0) {
            return countMap;
        }
        HashMap one = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            one = (HashMap)list.get(i);
            String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
            String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
            countMap.put(new Long(TYPEID), new Long(COUNT));
        }
        return countMap;
    }

    @Override
    public Map<String, Integer> getKnowledgeTypeDiffCountByAllKnowledge(Map map) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.getKnowledgeTypeDiffCountByAllKnowledge(map);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap one = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            one = (HashMap)list.get(i);
            String KNOWLEDGEID = one.get("KNOWLEDGEID") == null ? "" : (String)one.get("KNOWLEDGEID");
            String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
            String DIFFICULTY = one.get("DIFFICULTY") == null ? "" : (String)one.get("DIFFICULTY");
            String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
            countMap.put(KNOWLEDGEID + "_" + TYPEID + "_" + DIFFICULTY, new Integer(COUNT));
        }
        return countMap;
    }

    @Override
    public Map<String, Double> staticPaperKnowledgePercent(Long paperId, String fullMark) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.staticPaperKnowledgePercent(paperId);
        double sumScore = Double.parseDouble(fullMark);
        HashMap<String, Double> rtnMap = new HashMap<String, Double>();
        if (list != null) {
            DecimalFormat df = new DecimalFormat("#.#");
            for (int i = 0; i < list.size(); ++i) {
                Map<Object, Object> one = new HashMap();
                one = list.get(i);
                String knowledgeId = ((String)one.get("KNOWLEDGEID")).toString();
                String score = one.get("SCORE") == null ? "0" : ((String)one.get("SCORE")).toString();
                double percent = Double.parseDouble(score) * 100.0 / sumScore;
                rtnMap.put(knowledgeId + "_", new Double(df.format(percent)));
            }
        }
        return rtnMap;
    }

    @Override
    public Map<String, Double> staticPaperKnowledgeDiffPercent(Long paperId) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.staticPaperKnowledgePercent(paperId);
        HashMap<String, Double> rtnMap = new HashMap<String, Double>();
        if (list != null) {
            Map<Object, Object> one;
            int i;
            DecimalFormat df = new DecimalFormat("#.#");
            double sumScore = 0.0;
            for (i = 0; i < list.size(); ++i) {
                one = new HashMap();
                one = list.get(i);
                String score = one.get("SCORE") == null ? "0" : ((String)one.get("SCORE")).toString();
                sumScore += Double.parseDouble(score);
            }
            if (Math.abs(sumScore) < 1.0E-10) {
                sumScore = 1.0;
            }
            for (i = 0; i < list.size(); ++i) {
                one = new HashMap();
                one = list.get(i);
                String knowledgeId = ((String)one.get("KNOWLEDGEID")).toString();
                String score = one.get("SCORE") == null ? "0" : ((String)one.get("SCORE")).toString();
                double percent = Double.parseDouble(score) * 100.0 / sumScore;
                rtnMap.put(knowledgeId + "_", new Double(df.format(percent)));
            }
        }
        return rtnMap;
    }

    @Override
    public Map<String, Double> staticPaperTypeKnowledgeDiffPercent(Long paperId) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.staticPaperTypeKnowledgePercent(paperId);
        HashMap<String, Double> rtnMap = new HashMap<String, Double>();
        if (list != null) {
            DecimalFormat df = new DecimalFormat("#.#");
            for (int i = 0; i < list.size(); ++i) {
                Map<Object, Object> one = new HashMap();
                one = list.get(i);
                String knowledgeId = ((String)one.get("KNOWLEDGEID")).toString();
                String typeId = ((String)one.get("TYPEID")).toString();
                String score = one.get("SCORE") == null ? "0" : ((String)one.get("SCORE")).toString();
                double sumScore = 0.0;
                for (int j = 0; j < list.size(); ++j) {
                    Map<Object, Object> oneMap = new HashMap();
                    oneMap = list.get(j);
                    String typeId1 = ((String)oneMap.get("TYPEID")).toString();
                    if (!typeId1.equals(typeId)) continue;
                    String score1 = oneMap.get("SCORE") == null ? "0" : ((String)oneMap.get("SCORE")).toString();
                    sumScore += Double.parseDouble(score1);
                }
                double percent = 0.0;
                if (!(Math.abs(sumScore) < 1.0E-10)) {
                    percent = Double.parseDouble(score) * 100.0 / sumScore;
                }
                rtnMap.put(knowledgeId + "_" + typeId, new Double(df.format(percent)));
            }
        }
        return rtnMap;
    }

    @Override
    public Map<String, Double> staticPaperTypeKnowledgePercent(Long paperId, List<Map<String, String>> listPaperTypeInfo) {
        List<Map<String, String>> list = this.examPaperKnowledgeDiffiDao.staticPaperTypeKnowledgePercent(paperId);
        HashMap<String, Double> rtnMap = new HashMap<String, Double>();
        if (list != null) {
            Map<Object, Object> one;
            int i;
            DecimalFormat df = new DecimalFormat("#.#");
            double sumScore = 0.0;
            HashMap<String, Double> mapTypeSumScore = new HashMap<String, Double>();
            for (i = 0; i < listPaperTypeInfo.size(); ++i) {
                one = new HashMap();
                one = listPaperTypeInfo.get(i);
                String typeId = one.get("TYPEID").toString();
                Double score = one.get("SCORE") == null ? new Double(0.0) : (Double)one.get("SCORE");
                String num = one.get("NUM") == null ? "0" : one.get("NUM").toString();
                sumScore = Double.parseDouble(num) * score;
                mapTypeSumScore.put(typeId, new Double(sumScore));
            }
            for (i = 0; i < list.size(); ++i) {
                one = new HashMap();
                one = list.get(i);
                String knowledgeId = ((String)one.get("KNOWLEDGEID")).toString();
                String typeId = ((String)one.get("TYPEID")).toString();
                String score = one.get("SCORE") == null ? "0" : ((String)one.get("SCORE")).toString();
                sumScore = (Double)mapTypeSumScore.get(typeId);
                double percent = 0.0;
                if (!(Math.abs(sumScore) < 1.0E-10)) {
                    percent = Double.parseDouble(score) * 100.0 / sumScore;
                }
                rtnMap.put(knowledgeId + "_" + typeId, new Double(df.format(percent)));
            }
        }
        return rtnMap;
    }

    @Override
    public List<Map<String, String>> getPaperQuestionKnowledgeList(Long paperId) {
        return this.examPaperKnowledgeDiffiDao.getPaperQuestionKnowledgeList(paperId);
    }

    @Override
    public boolean txDeleteOneKnowledge(Long paperId, Long knowledgeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("paperId", paperId);
        map.put("knowledgeIds", knowledgeId);
        this.examPaperKnowledgeDiffiDao.delete(map);
        this.examPaperKnowledgeDao.deleteByPaperAndKnowledgeId(paperId, knowledgeId + "");
        return true;
    }

    @Override
    public void deleteByPaper(Long paperId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("paperId", paperId);
        this.examPaperKnowledgeDiffiDao.delete(map);
    }
}

