/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exam.exampaper.service.imple;

import com.peak.app.exam.exampaper.dao.IExamPaperDao;
import com.peak.app.exam.exampaper.dao.IExamPaperQuestionDao;
import com.peak.app.exam.exampaper.model.ExamPaperQuestion;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.service.IExamPaperQuestionService;
import com.peak.app.exam.exampaper.vo.ExamPaperQuestionQuery;
import com.peak.app.exam.examquestion.service.IExamQuestionClobService;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperQuestionService
extends BaseService<ExamPaperQuestion, Long, ExamPaperQuestionQuery>
implements IExamPaperQuestionService {
    private IExamPaperQuestionDao examPaperQuestionDao;
    private IExamQuestionClobService examQuestionClobService;
    private IExamPaperDao examPaperDao;

    public void setExamPaperQuestionDao(IExamPaperQuestionDao dao) {
        this.examPaperQuestionDao = dao;
    }

    public void setExamQuestionClobService(IExamQuestionClobService examQuestionClobService) {
        this.examQuestionClobService = examQuestionClobService;
    }

    public IExamPaperQuestionDao getExamPaperQuestionDao() {
        return this.examPaperQuestionDao;
    }

    public void setExamPaperDao(IExamPaperDao dao) {
        this.examPaperDao = dao;
    }

    public IEntityDao<ExamPaperQuestion, Long, ExamPaperQuestionQuery> getEntityDao() {
        return this.examPaperQuestionDao;
    }

    @Override
    public int txInsert(Collection<ExamPaperQuestion> list, Long paperId, String paperContent) {
        this.examPaperQuestionDao.deleteByPaperId(paperId);
        this.examPaperDao.updatePaperContent(paperId, paperContent, 0);
        if (list != null) {
            try {
                for (ExamPaperQuestion pq : list) {
                    if (pq.getUseClob() == null || pq.getUseClob() != 1) continue;
                    int useClob = this.examQuestionClobService.saveLob(pq);
                    pq.setUseClob(useClob);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.examPaperQuestionDao.insert(list);
    }

    @Override
    public List<Map<String, String>> getConditionQuestions(Map map) {
        return this.examPaperQuestionDao.getConditionQuestions(map);
    }

    @Override
    public List<Map<String, String>> getPaperHaveQues(Long paperId) {
        return this.examPaperQuestionDao.getPaperHaveQues(paperId);
    }

    @Override
    public Map<Long, ExamPaperQuestion> setExamPaperQuestion(List<Map<String, String>> listQuestion, Long paperId, Map<Long, ExamPaperQuestion> mapQuestion, Map<String, ExamPaperType> mapExamPaperType) throws SQLException {
        if (listQuestion != null) {
            for (int i = 0; i < listQuestion.size(); ++i) {
                HashMap one = new HashMap();
                one = (HashMap)listQuestion.get(i);
                String typeId = one.get("TYPEID") == null ? "-1" : one.get("TYPEID").toString();
                String questionId = one.get("QUESTIONID").toString();
                ExamPaperType typeModel = new ExamPaperType();
                typeModel = mapExamPaperType.get(typeId);
                Double score = typeModel.getScore();
                ExamPaperQuestion entity = new ExamPaperQuestion();
                entity = this.setExamPaperQuestionModel(one, paperId, typeId, questionId, score);
                mapQuestion.put(new Long(questionId), entity);
                if (Integer.parseInt(typeId) % 100 != 30) continue;
                List<Map<String, String>> list = this.getReadQuestions(new Long(questionId));
                for (int j = 0; j < list.size(); ++j) {
                    String ques_score;
                    one = (HashMap)list.get(j);
                    String string = ques_score = one.get("SCORE") == null ? score + "" : one.get("SCORE").toString();
                    if (j == list.size() - 1) {
                        double sum = (double)j * Math.floor(score / (double)list.size());
                        ques_score = score - sum + "";
                    } else {
                        ques_score = Math.floor(score / (double)list.size()) + "";
                    }
                    String ques_questionId = one.get("QUESTIONID").toString();
                    String ques_typeId = one.get("TYPEID") == null ? "-1" : one.get("TYPEID").toString();
                    entity = this.setExamPaperQuestionModel(one, paperId, ques_typeId, ques_questionId, new Double(ques_score));
                    mapQuestion.put(new Long(ques_questionId), entity);
                }
            }
        }
        return mapQuestion;
    }

    @Override
    public List<ExamPaperQuestion> getListByPageId(Long paperId) {
        return this.examPaperQuestionDao.getListByPageId(paperId);
    }

    @Override
    public Double getPaperQuestionSumMark(Long paperId) {
        return new Double(this.examPaperQuestionDao.getPaperQuestionSumMark(paperId));
    }

    private ExamPaperQuestion setExamPaperQuestionModel(HashMap one, Long paperId, String typeId, String questionId, Double score) throws SQLException {
        String isMedia = one.get("ISMEDIA") == null ? null : one.get("ISMEDIA").toString();
        String mediaFilePath = one.get("MEDIAFILEPATH") == null ? null : one.get("MEDIAFILEPATH").toString();
        String answerTime = one.get("ANSWERTIME") == null ? null : one.get("ANSWERTIME").toString();
        String difficulty = one.get("DIFFICULTY") == null ? null : one.get("DIFFICULTY").toString();
        String mediaFileType = one.get("MEDIAFILETYPE") == null ? null : one.get("MEDIAFILETYPE").toString();
        String playCount = one.get("PLAYCOUNT") == null ? null : one.get("PLAYCOUNT").toString();
        String content = one.get("CONTENT") == null ? null : one.get("CONTENT").toString();
        String detailAnswer = one.get("DETAILANSWER") == null ? null : one.get("DETAILANSWER").toString();
        String answer = one.get("ANSWER") == null ? null : one.get("ANSWER").toString();
        String options = one.get("OPTIONS") == null ? null : one.get("OPTIONS").toString();
        String useClob = one.get("USECLOB") == null ? null : one.get("USECLOB").toString();
        String parentID = one.get("PARENTID") == null ? null : one.get("PARENTID").toString();
        String isBigQuestion = one.get("ISBIGQUESTION") == null ? null : one.get("ISBIGQUESTION").toString();
        String isdisorder = one.get("ISDISORDER") == null ? "0" : one.get("ISDISORDER").toString();
        ExamPaperQuestion entity = new ExamPaperQuestion();
        entity.setPqId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_QUESTION"));
        entity.setPaperId(paperId);
        entity.setQuestionId(new Long(questionId));
        entity.setTypeId(new Long(typeId));
        entity.setScore(score);
        entity.setIsMedia(isMedia == null ? null : new Integer(isMedia));
        entity.setMediaFilePath(mediaFilePath);
        entity.setAnswerTime(answerTime == null ? null : new Double(answerTime));
        entity.setDifficulty(difficulty == null ? null : new Integer(difficulty));
        entity.setMediaFileType(mediaFileType);
        entity.setPlayCount(playCount == null ? null : new Integer(playCount));
        entity.setContent(content);
        entity.setDetailAnswer(detailAnswer);
        entity.setAnswer(answer);
        entity.setOptions(options);
        entity.setUseClob(useClob == null ? null : new Integer(useClob));
        entity.setParentId(parentID == null ? null : new Long(parentID));
        entity.setIsBigQuestion(isBigQuestion == null ? null : new Integer(isBigQuestion));
        entity.setCreateDate(new Date());
        entity.setDisorder(new Integer(isdisorder));
        if (entity.getUseClob() == null || entity.getUseClob() == 1) {
            // empty if block
        }
        return entity;
    }

    private List<Map<String, String>> getReadQuestions(Long questionId) {
        return this.examPaperQuestionDao.getReadQuestions(questionId);
    }

    @Override
    public ExamPaperQuestion getByPaperIdAndQuestionId(Long paperId, Long questionId) {
        return this.examPaperQuestionDao.getByPaperIdAndQuestionId(paperId, questionId);
    }

    @Override
    public void deleteQuestion(long pqId, long paperId) {
        this.examPaperQuestionDao.deleteQuestion(pqId, paperId);
    }
}

