/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exam.exampaper.service.imple;

import com.peak.app.exam.exampaper.dao.IExamPaperHavequesDao;
import com.peak.app.exam.exampaper.dao.IExamPaperTypeDao;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.service.IExamPaperTypeService;
import com.peak.app.exam.exampaper.vo.ExamPaperTypeQuery;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperTypeService
extends BaseService<ExamPaperType, Long, ExamPaperTypeQuery>
implements IExamPaperTypeService {
    private IExamPaperTypeDao examPaperTypeDao;
    private IExamPaperHavequesDao examPaperHavequesDao;

    public void setExamPaperTypeDao(IExamPaperTypeDao dao) {
        this.examPaperTypeDao = dao;
    }

    public IExamPaperTypeDao getExamPaperTypeDao() {
        return this.examPaperTypeDao;
    }

    public IExamPaperHavequesDao getExamPaperHavequesDao() {
        return this.examPaperHavequesDao;
    }

    public void setExamPaperHavequesDao(IExamPaperHavequesDao examPaperHavequesDao) {
        this.examPaperHavequesDao = examPaperHavequesDao;
    }

    public IEntityDao<ExamPaperType, Long, ExamPaperTypeQuery> getEntityDao() {
        return this.examPaperTypeDao;
    }

    @Override
    public List<Map<String, String>> getPaperTypeInfo(Map map) {
        return this.examPaperTypeDao.getPaperTypeInfo(map);
    }

    @Override
    public boolean txInsert(List<ExamPaperType> list, Long paperId, boolean isOneExamPaperType) {
        String typeIds = "";
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ExamPaperType one = new ExamPaperType();
                one = list.get(i);
                typeIds = typeIds + one.getTypeId() + ",";
            }
            if (typeIds.endsWith(",")) {
                typeIds = typeIds.substring(0, typeIds.length() - 1);
            }
        } else {
            return true;
        }
        HashMap<String, Object> mapDelete = new HashMap<String, Object>();
        mapDelete.put("paperId", paperId);
        if (!isOneExamPaperType) {
            this.examPaperTypeDao.deleteByPaperId(mapDelete);
        } else {
            mapDelete.put("typeId", typeIds);
            this.examPaperTypeDao.deleteByPaperId(mapDelete);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("typeIds", typeIds);
        map.put("paperId", paperId);
        this.examPaperHavequesDao.deleteByQuestionType(map);
        this.examPaperTypeDao.insert(list);
        return true;
    }

    @Override
    public Map<String, Long> getPaperTypeQuesCountByQuesBank(Map map, List<Map<String, String>> listQuestionType) {
        List<Map<String, String>> list = this.examPaperTypeDao.getPaperTypeQuesCountByQuesBank(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        for (Map<String, String> oneType : listQuestionType) {
            countMap.put(oneType.get("TYPEID") + "_", new Long(0L));
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                one = (HashMap)list.get(i);
                String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
                String QUESBANKID = one.get("QUESBANKID") == null ? "" : (String)one.get("QUESBANKID");
                String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
                countMap.put(TYPEID + "_" + QUESBANKID, new Long(COUNT));
            }
        }
        return countMap;
    }

    @Override
    public Map<Long, Long> getQuesBankTypeCount(Map map) {
        List<Map<String, String>> list = this.examPaperTypeDao.getQuesBankTypeCount(map);
        HashMap<Long, Long> countMap = new HashMap<Long, Long>();
        HashMap one = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            one = (HashMap)list.get(i);
            String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
            String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
            countMap.put(new Long(TYPEID), new Long(COUNT));
        }
        return countMap;
    }

    @Override
    public Map<String, Long> getQuesBankTypeDifficultyCount(Map map) {
        List<Map<String, String>> list = this.examPaperTypeDao.getQuesBankTypeDifficultyCount(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            one = (HashMap)list.get(i);
            String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
            String DIFFICULTY = one.get("DIFFICULTY") == null ? "" : (String)one.get("DIFFICULTY");
            String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
            countMap.put(TYPEID + "_" + DIFFICULTY, new Long(COUNT));
        }
        return countMap;
    }

    @Override
    public Map<String, Long> getPaperTypeQuesCount(Map map, List<Map<String, String>> listQuestionType) {
        List<Map<String, String>> list = this.examPaperTypeDao.getPaperTypeQuesCount(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        for (Map<String, String> oneType : listQuestionType) {
            countMap.put(oneType.get("TYPEID") + "_", new Long(0L));
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                one = (HashMap)list.get(i);
                String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
                String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
                countMap.put(TYPEID + "_", new Long(COUNT));
            }
        }
        return countMap;
    }

    @Override
    public Map<String, Long> getOneQuesBankByTypeDifficultyCount(Map map) {
        List<Map<String, String>> list = this.examPaperTypeDao.getOneQuesBankByTypeDifficultyCount(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                one = (HashMap)list.get(i);
                String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
                String QUESBANKID = one.get("QUESBANKID") == null ? "" : (String)one.get("QUESBANKID");
                String DIFFICULTY = one.get("DIFFICULTY") == null ? "" : (String)one.get("DIFFICULTY");
                String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
                countMap.put(TYPEID + "_" + QUESBANKID + "_" + DIFFICULTY, new Long(COUNT));
            }
        }
        return countMap;
    }

    @Override
    public Map<String, Long> getQuesBankByTypeDifficultyCount(Map map) {
        List<Map<String, String>> list = this.examPaperTypeDao.getQuesBankByTypeDifficultyCount(map);
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        HashMap one = new HashMap();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                one = (HashMap)list.get(i);
                String TYPEID = one.get("TYPEID") == null ? "" : (String)one.get("TYPEID");
                String DIFFICULTY = one.get("DIFFICULTY") == null ? "" : (String)one.get("DIFFICULTY");
                String COUNT = one.get("COUNT") == null ? "0" : (String)one.get("COUNT");
                countMap.put(TYPEID + "_" + DIFFICULTY, new Long(COUNT));
            }
        }
        return countMap;
    }

    @Override
    public List<Map<String, String>> getPaperTypeInfoOfSelected(Map map) {
        return this.examPaperTypeDao.getPaperTypeInfoOfSelected(map);
    }

    @Override
    public List<ExamPaperType> getExamPaperTypeList(Map map) {
        return this.examPaperTypeDao.getExamPaperTypeList(map);
    }

    @Override
    public boolean insertSelectExamPaperType(long paperId, long ptIDNew) {
        int count = this.examPaperTypeDao.insertSelectExamPaperType(paperId, ptIDNew);
        return count >= 0;
    }

    @Override
    public boolean txInsertSelectExamPaperType(long paperId, List<Long> ptIDNewList) {
        for (Long ptIDNew : ptIDNewList) {
            this.examPaperTypeDao.insertSelectExamPaperType(paperId, ptIDNew);
        }
        return true;
    }

    @Override
    public List<ExamPaperType> loadByPaperId(Long paperId) {
        return this.examPaperTypeDao.loadByPaperId(paperId);
    }

    @Override
    public boolean txDeleteOneExamPaperType(Long paperId, Long typeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("paperId", paperId);
        map.put("typeId", typeId);
        this.examPaperTypeDao.deleteByPaperId(map);
        map.put("typeIds", typeId);
        this.examPaperHavequesDao.deleteByQuestionType(map);
        return true;
    }
}

