/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampaper.service.imple;

import com.peak.app.exam.exampaper.dao.IExamPaperQuestionDao;
import com.peak.app.exam.exampaper.dao.IExamPaperTypeDao;
import com.peak.app.exam.exampaper.model.ExamPaper;
import com.peak.app.exam.exampaper.model.ExamPaperDifficulty;
import com.peak.app.exam.exampaper.model.ExamPaperHaveques;
import com.peak.app.exam.exampaper.model.ExamPaperKnowledge;
import com.peak.app.exam.exampaper.model.ExamPaperKnowledgeDiffi;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.service.IExamPaperDifficultyService;
import com.peak.app.exam.exampaper.service.IExamPaperHavequesService;
import com.peak.app.exam.exampaper.service.IExamPaperKnowledgeDiffiService;
import com.peak.app.exam.exampaper.service.IExamPaperKnowledgeService;
import com.peak.app.exam.exampaper.service.IExamPaperQuestionService;
import com.peak.app.exam.exampaper.service.IExamPaperService;
import com.peak.app.exam.exampaper.service.IExamPaperTypeService;
import com.peak.app.exam.exampaper.vo.ExamPaperDifficultyQuery;
import com.peak.app.exam.exampaper.vo.ExamPaperHavequesQuery;
import com.peak.app.exam.exampaper.vo.ExamPaperKnowledgeDiffiQuery;
import com.peak.app.exam.exampaper.vo.ExamPaperKnowledgeQuery;
import com.peak.app.exam.exampaper.vo.ExamPaperQuestionQuery;
import com.peak.app.exam.exampaper.vo.ExamPaperTypeQuery;
import com.peak.app.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.app.exam.examquestiontype.service.IExamQuestiontypeService;
import com.peak.app.exampro.common.model.KeyValuePair;
import com.peak.app.exampro.exampaper.dao.IExamProPaperDao;
import com.peak.app.exampro.exampaper.model.AbstractBaseQuestion;
import com.peak.app.exampro.exampaper.model.ComplexQuestion;
import com.peak.app.exampro.exampaper.model.ExamPaperQuestion;
import com.peak.app.exampro.exampaper.model.ExamPaperWrapper;
import com.peak.app.exampro.exampaper.model.FillQuestion;
import com.peak.app.exampro.exampaper.model.IndefiniteChoiceQuestion;
import com.peak.app.exampro.exampaper.model.MatchQuestion;
import com.peak.app.exampro.exampaper.model.MultipleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.RandomComp;
import com.peak.app.exampro.exampaper.model.Section;
import com.peak.app.exampro.exampaper.model.SingleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.TextQuestion;
import com.peak.app.exampro.exampaper.model.YesNoQuestion;
import com.peak.app.exampro.exampaper.service.IExamProPaperService;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplAttr;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplItem;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQBank;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQType;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplAttrService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplItemService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplQBankService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplQTypeService;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplAttrQuery;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplItemQuery;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplQBankQuery;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplQTypeQuery;
import com.peak.app.exampro.examquestion.util.ExamQuestionClobUtil;
import com.peak.app.exampro.util.QuestionConvert;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.exam.examresourcerelation.model.ExamResourceRelation;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamProPaperService
implements IExamProPaperService {
    private static final Logger log = LoggerFactory.getLogger(ExamProPaperService.class);
    @Autowired
    private IExamResourceRelationPlusService examResourceRelationPlusService;
    private IExamPaperService examPaperService;
    private IExamPaperQuestionService examPaperQuestionService;
    private IExamQuestiontypeService examQuestiontypeService;
    private IExamPaperTypeService examPaperTypeService;
    private IExamPaperTypeDao examPaperTypeDao;
    private IExamPaperQuestionDao examPaperQuestionDao;
    private IExamProPaperDao examProPaperDao;
    private IExamPaperTplQBankService examPaperTplQBankService;
    private IExamPaperTplQTypeService examPaperTplQTypeService;
    private IExamPaperHavequesService examPaperHavequesService;
    private IExamPaperDifficultyService examPaperDifficultyService;
    private IExamPaperKnowledgeService examPaperKnowledgeService;
    private IExamPaperKnowledgeDiffiService examPaperKnowledgeDiffiService;

    @Override
    public ExamPaperWrapper loadById(Long paperId, boolean disorderQuestion, boolean disorderChoice) {
        return this.loadById(paperId, disorderQuestion, disorderChoice, false);
    }

    @Override
    public ExamPaperWrapper loadById(Long paperId, boolean disorderQuestion, boolean disorderChoice, boolean withCorrectanswer) {
        RandomComp randomComp = new RandomComp();
        ExamPaper paper = (ExamPaper)this.examPaperService.getById(paperId);
        if (paper == null) {
            return null;
        }
        ExamPaperWrapper paperWrapper = new ExamPaperWrapper(paperId);
        paperWrapper.setTitle(paper.getTitle());
        List allTypes = this.examQuestiontypeService.findAll(null);
        ExamPaperTypeQuery examPaperTypeQuery = new ExamPaperTypeQuery();
        examPaperTypeQuery.setPaperId(paper.getPaperId());
        examPaperTypeQuery.getPage().setSortColumns("createdate,ptId");
        List examPaperTypes = this.examPaperTypeService.findAll(examPaperTypeQuery);
        ExamPaperQuestionQuery examPaperQuestionQuery = new ExamPaperQuestionQuery();
        examPaperQuestionQuery.setPaperId(paper.getPaperId());
        examPaperQuestionQuery.getPage().setSortColumns("typeId,createdate,pqId");
        List examPaperQuestions = this.examPaperQuestionService.findAll(examPaperQuestionQuery);
        JSONArray jStruct = this.getPaperStructure(paper, allTypes, examPaperTypes, examPaperQuestions);
        ArrayList<Section> sections = new ArrayList<Section>();
        for (int i = 0; i < jStruct.size(); ++i) {
            Section section = new Section();
            JSONObject jStructElem = jStruct.getJSONObject(i);
            section.setTitle(jStructElem.has("title") ? jStructElem.getString("title") : "");
            section.setTypeName(jStructElem.getString("typeName"));
            section.setQuestions(new ArrayList<AbstractBaseQuestion>());
            JSONArray jQuestions = jStructElem.getJSONArray("questions");
            block20: for (int j = 0; j < jQuestions.size(); ++j) {
                long qid = jQuestions.getLong(j);
                com.peak.app.exam.exampaper.model.ExamPaperQuestion pq = this.findByQuestionid(qid, examPaperQuestions);
                if (pq == null) continue;
                String contentClob = ExamQuestionClobUtil.loadContentLob(pq);
                String optionsClob = ExamQuestionClobUtil.loadOptionsLob(pq);
                if (contentClob != null) {
                    pq.setContent(contentClob);
                }
                if (optionsClob != null) {
                    pq.setOptions(optionsClob);
                }
                if (pq.getParentId() != null && pq.getParentId() != 0L) continue;
                switch ((int)(pq.getTypeId() % 100L)) {
                    case 1: {
                        SingleChoiceQuestion sc = QuestionConvert.toSingleChoiceQuestion(pq, disorderChoice, withCorrectanswer);
                        section.getQuestions().add(sc);
                        continue block20;
                    }
                    case 2: {
                        MultipleChoiceQuestion mc = QuestionConvert.toMultipleChoiceQuestion(pq, disorderChoice, withCorrectanswer);
                        section.getQuestions().add(mc);
                        continue block20;
                    }
                    case 10: {
                        IndefiniteChoiceQuestion ic = QuestionConvert.toIndefiniteChoiceQuestion(pq, disorderChoice, withCorrectanswer);
                        section.getQuestions().add(ic);
                        continue block20;
                    }
                    case 3: {
                        YesNoQuestion yesno = QuestionConvert.toYesNoQuestion(pq, withCorrectanswer);
                        section.getQuestions().add(yesno);
                        continue block20;
                    }
                    case 4: {
                        FillQuestion fillq = QuestionConvert.toFillQuestion(pq, withCorrectanswer);
                        section.getQuestions().add(fillq);
                        continue block20;
                    }
                    case 6: {
                        MatchQuestion matchq = QuestionConvert.toMatchQuestion(pq, withCorrectanswer);
                        section.getQuestions().add(matchq);
                        continue block20;
                    }
                    case 5: {
                        TextQuestion textq = QuestionConvert.toTextQuestion(pq, withCorrectanswer);
                        section.getQuestions().add(textq);
                        continue block20;
                    }
                    case 30: {
                        ComplexQuestion complexq = QuestionConvert.toComplexQuestion(pq);
                        complexq.setChildren(new ArrayList<AbstractBaseQuestion>());
                        ExamPaperQuestionQuery childQuery = new ExamPaperQuestionQuery();
                        childQuery.setPaperId(paper.getPaperId());
                        childQuery.setParentId(complexq.getQuestionId());
                        childQuery.getPage().setSortColumns("createdate,pqId");
                        List childQuestions = this.examPaperQuestionService.findAll(childQuery);
                        for (com.peak.app.exam.exampaper.model.ExamPaperQuestion cpq : childQuestions) {
                            if (cpq.getParentId() == null || cpq.getParentId().longValue() != pq.getQuestionId().longValue()) continue;
                            switch ((int)(cpq.getTypeId() % 100L)) {
                                case 1: {
                                    SingleChoiceQuestion csc = QuestionConvert.toSingleChoiceQuestion(cpq, false, withCorrectanswer);
                                    csc.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(csc);
                                    break;
                                }
                                case 2: {
                                    MultipleChoiceQuestion cmc = QuestionConvert.toMultipleChoiceQuestion(cpq, false, withCorrectanswer);
                                    cmc.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(cmc);
                                    break;
                                }
                                case 10: {
                                    IndefiniteChoiceQuestion cic = QuestionConvert.toIndefiniteChoiceQuestion(cpq, false, withCorrectanswer);
                                    cic.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(cic);
                                    break;
                                }
                                case 3: {
                                    YesNoQuestion cyesno = QuestionConvert.toYesNoQuestion(cpq, withCorrectanswer);
                                    cyesno.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(cyesno);
                                    break;
                                }
                                case 4: {
                                    FillQuestion cfillq = QuestionConvert.toFillQuestion(cpq, withCorrectanswer);
                                    cfillq.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(cfillq);
                                    break;
                                }
                                case 6: {
                                    MatchQuestion cmatchq = QuestionConvert.toMatchQuestion(cpq, withCorrectanswer);
                                    cmatchq.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(cmatchq);
                                    break;
                                }
                                case 5: {
                                    TextQuestion ctextq = QuestionConvert.toTextQuestion(cpq, withCorrectanswer);
                                    ctextq.setParentId(complexq.getQuestionId());
                                    complexq.getChildren().add(ctextq);
                                    break;
                                }
                            }
                        }
                        section.getQuestions().add(complexq);
                        continue block20;
                    }
                }
            }
            if (disorderQuestion) {
                Collections.sort(section.getQuestions(), randomComp);
            }
            sections.add(section);
        }
        paperWrapper.setSections(sections);
        return paperWrapper;
    }

    private JSONArray getPaperStructure(ExamPaper paper, List<ExamQuestiontype> allTypes, List<ExamPaperType> types, List<com.peak.app.exam.exampaper.model.ExamPaperQuestion> questions) {
        String content = paper.getContent();
        if (content == null || content.trim().isEmpty()) {
            return this.buildPaperStructure(paper, allTypes, types, questions);
        }
        try {
            return this.loadPaperStructure(paper, allTypes, types, questions);
        }
        catch (Exception ex) {
            log.error("loadPaperStructure error[paperId:" + paper.getPaperId() + "]", (Throwable)ex);
            return this.buildPaperStructure(paper, allTypes, types, questions);
        }
    }

    private JSONArray loadPaperStructure(ExamPaper paper, List<ExamQuestiontype> allTypes, List<ExamPaperType> types, List<com.peak.app.exam.exampaper.model.ExamPaperQuestion> questions) throws Exception {
        JSONArray jAry = JSONArray.fromObject((Object)paper.getContent());
        if (jAry.isEmpty()) {
            return this.buildPaperStructure(paper, allTypes, types, questions);
        }
        JSONArray jStruct = new JSONArray();
        for (int i = 0; questions != null && i < questions.size(); ++i) {
            questions.get(i).setChecked(false);
        }
        JSONObject jCurrentSection = null;
        JSONArray jCurrentSectionQuestions = null;
        ArrayList sortAllList = new ArrayList();
        for (int i = 0; i < jAry.size(); ++i) {
            JSONObject jObj = jAry.getJSONObject(i);
            int nType = jObj.getInt("type");
            JSONArray ids = jObj.getJSONArray("id");
            if (nType == 3) {
                ExamQuestiontype type0;
                ExamPaperType pt = this.findByPtid(ids.getLong(0), types);
                if (pt == null || (type0 = this.findByTypeid(pt.getTypeId(), allTypes)) == null) continue;
                if (jCurrentSection != null && jCurrentSectionQuestions.size() > 0) {
                    jCurrentSection.put((Object)"questions", jCurrentSectionQuestions);
                    jStruct.add((Object)jCurrentSection);
                }
                jCurrentSection = new JSONObject();
                jCurrentSectionQuestions = new JSONArray();
                jCurrentSection.put((Object)"typeName", (Object)type0.getTypeName());
                jCurrentSection.put((Object)"title", (Object)pt.getNotes());
                continue;
            }
            if (nType != 1) continue;
            sortAllList.addAll(ids);
            if (jCurrentSection == null) continue;
            for (int j = 0; j < ids.size(); ++j) {
                long pqId = ids.getLong(j);
                com.peak.app.exam.exampaper.model.ExamPaperQuestion pq = this.findByPqid(pqId, questions);
                if (pq.isChecked() || pq.getParentId() != null && pq.getParentId() > 0L) continue;
                pq.setChecked(true);
                jCurrentSectionQuestions.add((Object)pq.getQuestionId());
            }
        }
        if (jCurrentSection != null && jCurrentSectionQuestions.size() > 0) {
            jCurrentSection.put((Object)"questions", jCurrentSectionQuestions);
            jStruct.add(jCurrentSection);
        }
        JSONArray leftQuestions = new JSONArray();
        for (int i = 0; questions != null && i < questions.size(); ++i) {
            if (questions.get(i).isChecked() || questions.get(i).getParentId() != null && questions.get(i).getParentId() != 0L) continue;
            leftQuestions.add((Object)questions.get(i).getQuestionId());
        }
        ArrayList<Long> sortedLeftList = new ArrayList<Long>();
        if (!leftQuestions.isEmpty()) {
            sortAllList.addAll(leftQuestions);
            block4: for (int i = 0; i < sortAllList.size(); ++i) {
                if (sortAllList.get(i) == null) continue;
                for (int j = 0; questions != null && j < questions.size(); ++j) {
                    if (questions.get(j).isChecked() || questions.get(j).getParentId() != null && questions.get(j).getParentId() != 0L || questions.get(j).getQuestionId() != Long.parseLong(sortAllList.get(i).toString())) continue;
                    sortedLeftList.add(questions.get(j).getQuestionId());
                    questions.get(j).setChecked(true);
                    continue block4;
                }
            }
        }
        if (!leftQuestions.isEmpty()) {
            JSONObject jSection = new JSONObject();
            jSection.put((Object)"typeName", (Object)"\u5176\u4ed6");
            jSection.put((Object)"title", (Object)"\u5176\u4ed6");
            jSection.put((Object)"questions", sortedLeftList);
            jStruct.add((Object)jSection);
        }
        return jStruct;
    }

    private JSONArray buildPaperStructure(ExamPaper paper, List<ExamQuestiontype> allTypes, List<ExamPaperType> types, List<com.peak.app.exam.exampaper.model.ExamPaperQuestion> questions) {
        int i;
        JSONArray jStruct = new JSONArray();
        for (i = 0; questions != null && i < questions.size(); ++i) {
            questions.get(i).setChecked(false);
        }
        for (i = 0; types != null && i < types.size(); ++i) {
            ExamQuestiontype type0 = this.findByTypeid(types.get(i).getTypeId(), allTypes);
            if (type0 == null) continue;
            JSONObject jSection = new JSONObject();
            jSection.put((Object)"typeName", (Object)type0.getTypeName());
            jSection.put((Object)"title", (Object)types.get(i).getNotes());
            JSONArray sectionQuestions = new JSONArray();
            for (int j = 0; questions != null && j < questions.size(); ++j) {
                if (questions.get(j).isChecked() || questions.get(j).getParentId() != null && questions.get(j).getParentId() != 0L || questions.get(j).getTypeId() == null || questions.get(j).getTypeId().longValue() != type0.getTypeId().longValue()) continue;
                questions.get(j).setChecked(true);
                sectionQuestions.add((Object)questions.get(j).getQuestionId());
            }
            jSection.put((Object)"questions", (Object)sectionQuestions);
            jStruct.add((Object)jSection);
        }
        JSONArray leftQuestions = new JSONArray();
        for (int i2 = 0; questions != null && i2 < questions.size(); ++i2) {
            if (questions.get(i2).isChecked() || questions.get(i2).getParentId() != null && questions.get(i2).getParentId() != 0L) continue;
            leftQuestions.add((Object)questions.get(i2).getQuestionId());
        }
        if (leftQuestions.size() > 0) {
            JSONObject jSection = new JSONObject();
            jSection.put((Object)"typeName", (Object)"\u5176\u4ed6");
            jSection.put((Object)"title", (Object)"\u5176\u4ed6");
            jSection.put((Object)"questions", (Object)leftQuestions);
            jStruct.add((Object)jSection);
        }
        return jStruct;
    }

    com.peak.app.exam.exampaper.model.ExamPaperQuestion findByQuestionid(Long questionId, List<com.peak.app.exam.exampaper.model.ExamPaperQuestion> allQuestions) {
        if (questionId == null) {
            return null;
        }
        for (int i = 0; allQuestions != null && i < allQuestions.size(); ++i) {
            if (allQuestions.get(i).getQuestionId() == null || allQuestions.get(i).getQuestionId().longValue() != questionId.longValue()) continue;
            return allQuestions.get(i);
        }
        return null;
    }

    com.peak.app.exam.exampaper.model.ExamPaperQuestion findByPqid(Long pqId, List<com.peak.app.exam.exampaper.model.ExamPaperQuestion> allQuestions) {
        if (pqId == null || allQuestions == null || allQuestions.isEmpty()) {
            return null;
        }
        for (int i = 0; i < allQuestions.size(); ++i) {
            if (allQuestions.get(i).getPqId() == null || allQuestions.get(i).getPqId().longValue() != pqId.longValue()) continue;
            return allQuestions.get(i);
        }
        return null;
    }

    ExamPaperType findByPtid(Long ptid, List<ExamPaperType> types) {
        if (ptid == null || types == null || types.isEmpty()) {
            return null;
        }
        for (int i = 0; i < types.size(); ++i) {
            if (types.get(i).getPtId() == null || types.get(i).getPtId().longValue() != ptid.longValue()) continue;
            return types.get(i);
        }
        return null;
    }

    ExamQuestiontype findByTypeid(Long typeid, List<ExamQuestiontype> allTypes) {
        if (typeid == null) {
            return null;
        }
        for (int i = 0; allTypes != null && i < allTypes.size(); ++i) {
            if (allTypes.get(i).getTypeId() == null || allTypes.get(i).getTypeId().longValue() != typeid.longValue()) continue;
            return allTypes.get(i);
        }
        return null;
    }

    @Override
    public void txClearPaper(Long paperId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("paperId", paperId);
        this.examPaperTypeDao.deleteByPaperId(map);
        this.examPaperQuestionDao.deleteByPaperId(paperId);
    }

    public void setExamPaperService(IExamPaperService examPaperService) {
        this.examPaperService = examPaperService;
    }

    public void setExamPaperQuestionService(IExamPaperQuestionService examPaperQuestionService) {
        this.examPaperQuestionService = examPaperQuestionService;
    }

    public void setExamQuestiontypeService(IExamQuestiontypeService examQuestiontypeService) {
        this.examQuestiontypeService = examQuestiontypeService;
    }

    public void setExamPaperTypeService(IExamPaperTypeService examPaperTypeService) {
        this.examPaperTypeService = examPaperTypeService;
    }

    public void setExamPaperTypeDao(IExamPaperTypeDao examPaperTypeDao) {
        this.examPaperTypeDao = examPaperTypeDao;
    }

    public void setExamPaperQuestionDao(IExamPaperQuestionDao examPaperQuestionDao) {
        this.examPaperQuestionDao = examPaperQuestionDao;
    }

    public void setExamProPaperDao(IExamProPaperDao examProPaperDao) {
        this.examProPaperDao = examProPaperDao;
    }

    @Override
    public List<ExamPaperQuestion> findAllCorrectAnswers(Long paperId) {
        return this.examProPaperDao.findAllCorrectAnswers(paperId);
    }

    @Override
    public List<KeyValuePair<Long, String>> findAllQuestionKnowledges(Long paperId) {
        return this.examProPaperDao.findAllQuestionKnowledges(paperId);
    }

    @Override
    public ExamPaper copyPaper(Long originalPaperId, Long creatorId, Long domainId) throws Exception {
        if (originalPaperId == null) {
            return null;
        }
        ExamPaper oldPaper = (ExamPaper)this.examPaperService.getById(originalPaperId);
        if (oldPaper == null) {
            return null;
        }
        if (oldPaper.getPaperMethod() == null) {
            throw new Exception("unknown papermethod");
        }
        Long newPaperId = IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER");
        ExamPaper newPaper = oldPaper;
        newPaper.setPaperId(newPaperId);
        newPaper.setCreateDate(new Date());
        newPaper.setCreatorId(creatorId);
        newPaper.setDomainId(domainId);
        newPaper.setTitle(newPaper.getTitle() + "_\u526f\u672c_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        newPaper.setStatus(0);
        this.examPaperService.insert(newPaper);
        try {
            return this._innerCopyPaper(originalPaperId, newPaper);
        }
        catch (Exception ex) {
            this.examPaperService.deleteById(newPaperId);
            throw ex;
        }
    }

    private ExamPaper _innerCopyPaper(Long originalPaperId, ExamPaper newPaper) throws Exception {
        Long newPaperId = newPaper.getPaperId();
        if (newPaper.getPaperMethod() == 2) {
            this.copyQBanks(originalPaperId, newPaperId);
            this.copyQTypes(originalPaperId, newPaperId);
            this.copyMustQuestions(originalPaperId, newPaperId);
        } else if (newPaper.getPaperMethod() == 3) {
            this.copyQBanks(originalPaperId, newPaperId);
            this.copyQTypes(originalPaperId, newPaperId);
            this.copyMustQuestions(originalPaperId, newPaperId);
            this.copyDifficulties(originalPaperId, newPaperId);
        } else if (newPaper.getPaperMethod() == 4) {
            this.copyQBanks(originalPaperId, newPaperId);
            this.copyQTypes(originalPaperId, newPaperId);
            this.copyMustQuestions(originalPaperId, newPaperId);
            this.copyKnowledges(originalPaperId, newPaperId);
            this.copyKnowledgeDiffis(originalPaperId, newPaperId);
        } else if (newPaper.getPaperMethod() == 6) {
            this.copyFreeItems(originalPaperId, newPaperId);
        } else {
            throw new Exception("unknown papermethod");
        }
        ExamResourceRelationQuery rrQuery = new ExamResourceRelationQuery();
        rrQuery.setExamresourceId(originalPaperId);
        rrQuery.setExamtype(Integer.valueOf(2));
        List rrs = this.examResourceRelationPlusService.findAll((IQuery)rrQuery);
        if (rrs != null && rrs.size() > 0) {
            for (int i = 0; i < rrs.size(); ++i) {
                ((ExamResourceRelation)rrs.get(i)).setExamresourceId(newPaperId);
                ((ExamResourceRelation)rrs.get(i)).setRtId(IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION"));
            }
            this.examResourceRelationPlusService.insert((Collection)rrs);
        }
        return newPaper;
    }

    private void copyQBanks(Long oldPaperId, Long newPaperId) throws Exception {
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperTplQBankService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperTplQBankQuery qbankQuery = new ExamPaperTplQBankQuery();
        qbankQuery.setPaperId(oldPaperId);
        List qbanks = this.examPaperTplQBankService.findAll(qbankQuery);
        if (qbanks == null || qbanks.isEmpty()) {
            return;
        }
        for (int i = 0; i < qbanks.size(); ++i) {
            ExamPaperTplQBank qb = (ExamPaperTplQBank)qbanks.get(i);
            qb.setPaperId(newPaperId);
            qb.setPqId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_QUESBANK"));
            qb.setCreatedate(now);
        }
        this.examPaperTplQBankService.insertBatch(qbanks);
    }

    private void copyQTypes(Long oldPaperId, Long newPaperId) throws Exception {
        ExamPaperTplQType qt;
        int i;
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperTplQTypeService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperTplQTypeQuery qtypeQuery = new ExamPaperTplQTypeQuery();
        qtypeQuery.setPaperId(oldPaperId);
        List qtypes = this.examPaperTplQTypeService.findAll(qtypeQuery);
        if (qtypes == null || qtypes.isEmpty()) {
            return;
        }
        for (i = 0; i < qtypes.size(); ++i) {
            qt = (ExamPaperTplQType)qtypes.get(i);
            qt.setPaperId(newPaperId);
            qt.setPtId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TYPE"));
            qt.setCreatedate(now);
        }
        this.examPaperTplQTypeService.insertBatch(qtypes);
        for (i = 0; i < qtypes.size(); ++i) {
            qt = (ExamPaperTplQType)qtypes.get(i);
            this.examPaperTplQTypeService.update(qt);
        }
    }

    private void copyMustQuestions(Long oldPaperId, Long newPaperId) throws Exception {
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperHavequesService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperHavequesQuery query = new ExamPaperHavequesQuery();
        query.setPaperId(oldPaperId);
        List list = this.examPaperHavequesService.findAll(query);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExamPaperHaveques item = (ExamPaperHaveques)list.get(i);
            item.setPaperId(newPaperId);
            item.setPhId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_HAVEQUES"));
            item.setCreateDate(now);
        }
        this.examPaperHavequesService.insertBatch(list);
    }

    private void copyDifficulties(Long oldPaperId, Long newPaperId) throws Exception {
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperDifficultyService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperDifficultyQuery query = new ExamPaperDifficultyQuery();
        query.setPaperId(oldPaperId);
        List list = this.examPaperDifficultyService.findAll(query);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExamPaperDifficulty item = (ExamPaperDifficulty)list.get(i);
            item.setPaperId(newPaperId);
            item.setPdId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_DIFFICULTY"));
            item.setCreateDate(now);
        }
        this.examPaperDifficultyService.insertBatch(list);
    }

    private void copyKnowledges(Long oldPaperId, Long newPaperId) throws Exception {
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperKnowledgeService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperKnowledgeQuery query = new ExamPaperKnowledgeQuery();
        query.setPaperId(oldPaperId);
        List list = this.examPaperKnowledgeService.findAll(query);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExamPaperKnowledge item = (ExamPaperKnowledge)list.get(i);
            item.setPaperId(newPaperId);
            item.setPkId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_KNOWLEDGE"));
            item.setCreateDate(now);
        }
        this.examPaperKnowledgeService.insertBatch(list);
    }

    private void copyKnowledgeDiffis(Long oldPaperId, Long newPaperId) throws Exception {
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        this.examPaperKnowledgeDiffiService.deleteByPaper(newPaperId);
        Date now = new Date();
        ExamPaperKnowledgeDiffiQuery query = new ExamPaperKnowledgeDiffiQuery();
        query.setPaperId(oldPaperId);
        List list = this.examPaperKnowledgeDiffiService.findAll(query);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExamPaperKnowledgeDiffi item = (ExamPaperKnowledgeDiffi)list.get(i);
            item.setPaperId(newPaperId);
            item.setPkdId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_KNOWLEDGE_DIFFI"));
            item.setCreateDate(now);
        }
        this.examPaperKnowledgeDiffiService.insertBatch(list);
    }

    private void copyFreeItems(Long oldPaperId, Long newPaperId) throws Exception {
        ExamPaperTplItem item;
        int i;
        if (oldPaperId == null || newPaperId == null) {
            return;
        }
        Date now = new Date();
        IExamPaperTplItemService examPaperTplItemService = (IExamPaperTplItemService)SpringUtil.getBean(IExamPaperTplItemService.class);
        IExamPaperTplAttrService examPaperTplAttrService = (IExamPaperTplAttrService)SpringUtil.getBean(IExamPaperTplAttrService.class);
        examPaperTplAttrService.deleteAllByTemplateId(newPaperId);
        examPaperTplItemService.deleteAllByTemplateId(newPaperId);
        ExamPaperTplItemQuery query1 = new ExamPaperTplItemQuery();
        query1.setTemplateId(oldPaperId);
        List items = examPaperTplItemService.findAll(query1);
        if (items == null || items.isEmpty()) {
            return;
        }
        HashMap<Long, Long> mapItemIds = new HashMap<Long, Long>();
        for (i = 0; i < items.size(); ++i) {
            item = (ExamPaperTplItem)items.get(i);
            mapItemIds.put(item.getItemId(), IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ITEM"));
        }
        for (i = items.size() - 1; i >= 0; --i) {
            item = (ExamPaperTplItem)items.get(i);
            item.setTemplateId(newPaperId);
            item.setItemId((Long)mapItemIds.get(item.getItemId()));
            item.setCreatedate(now);
            if (item.getParentId() == null || item.getParentId().intValue() == 0) continue;
            Long itemParentId = (Long)mapItemIds.get(item.getParentId());
            item.setParentId(itemParentId);
            if (itemParentId != null) continue;
            items.remove(i);
        }
        examPaperTplItemService.insertBatch(items);
        ExamPaperTplAttrQuery query2 = new ExamPaperTplAttrQuery();
        query2.setTemplateId(oldPaperId);
        List attrs = examPaperTplAttrService.findAll(query2);
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < attrs.size(); ++i2) {
            ExamPaperTplAttr attr = (ExamPaperTplAttr)attrs.get(i2);
            attr.setAttrId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
            attr.setTemplateId(newPaperId);
            Long tmpid = (Long)mapItemIds.get(attr.getItemId());
            if (tmpid == null) continue;
            attr.setItemId(tmpid);
            attr.setCreatedate(now);
        }
        examPaperTplAttrService.insertBatch(attrs);
        mapItemIds.clear();
    }

    public void setExamPaperTplQBankService(IExamPaperTplQBankService examPaperTplQBankService) {
        this.examPaperTplQBankService = examPaperTplQBankService;
    }

    public void setExamPaperTplQTypeService(IExamPaperTplQTypeService examPaperTplQTypeService) {
        this.examPaperTplQTypeService = examPaperTplQTypeService;
    }

    public void setExamPaperHavequesService(IExamPaperHavequesService examPaperHavequesService) {
        this.examPaperHavequesService = examPaperHavequesService;
    }

    public void setExamPaperDifficultyService(IExamPaperDifficultyService examPaperDifficultyService) {
        this.examPaperDifficultyService = examPaperDifficultyService;
    }

    public void setExamPaperKnowledgeService(IExamPaperKnowledgeService examPaperKnowledgeService) {
        this.examPaperKnowledgeService = examPaperKnowledgeService;
    }

    public void setExamPaperKnowledgeDiffiService(IExamPaperKnowledgeDiffiService examPaperKnowledgeDiffiService) {
        this.examPaperKnowledgeDiffiService = examPaperKnowledgeDiffiService;
    }

    @Override
    public void overwriteTpl(Long fromTplId, Long toTplId) {
        if (fromTplId == null || toTplId == null) {
            return;
        }
        ExamPaper fromPaper = (ExamPaper)this.examPaperService.getById(fromTplId);
        ExamPaper toPaper = (ExamPaper)this.examPaperService.getById(toTplId);
        if (fromPaper == null || toPaper == null) {
            return;
        }
        if (fromPaper.getPaperMethod() == null) {
            throw new RuntimeException("unknown papermethod");
        }
        if (fromPaper.getPaperMethod() == 1) {
            throw new RuntimeException("\u4e0d\u5e94\u8be5\u662f\u56fa\u5b9a\u8bd5\u5377");
        }
        try {
            this._innerCopyPaper(fromTplId, toPaper);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

