/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.model;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplItem;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class ExamPaperTplBlock
extends ExamPaperTplItem {
    private Long qtypeId;
    private Integer difficulty;
    private Double score;
    private Integer questionnum;
    private String qbankIds;
    private String knowledgeIds;
    private List<Long> qbankIdList;
    private List<Long> knowledgeIdList;
    private List<Long> tagIdList;
    private List<ExamQuestion> questions;
    private List<Long> exceptQuestionIds;
    private Integer maxQuestionnum;
    private String key;
    private List<Long> mustQuestionIds;
    private Boolean isMutex;

    public ExamPaperTplBlock() {
        this.setItemtype("BLOCK");
    }

    public boolean hasChilrenQuestions() {
        if (this.qtypeId == null) {
            return false;
        }
        return ExamQuestiontypeEnum.hasChildren((int)ExamQuestiontypeEnum.getBasicType((Long)this.qtypeId));
    }

    @Deprecated
    public boolean getIsComplex() {
        return this.hasChilrenQuestions();
    }

    public Integer getQuestionnum() {
        return this.questionnum;
    }

    public void setQuestionnum(Integer questionnum) {
        this.questionnum = questionnum;
    }

    public Integer getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Integer difficulty) {
        this.difficulty = difficulty;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public String getQbankIds() {
        return this.qbankIds;
    }

    public void setQbankIds(String qbankIds) {
        this.qbankIds = qbankIds;
    }

    public List<Long> getQbankIdList() {
        return this.qbankIdList;
    }

    public void setQbankIdList(List<Long> qbankIdList) {
        this.qbankIdList = qbankIdList;
    }

    public String getKnowledgeIds() {
        return this.knowledgeIds;
    }

    public void setKnowledgeIds(String knowledgeIds) {
        this.knowledgeIds = knowledgeIds;
    }

    public List<Long> getKnowledgeIdList() {
        return this.knowledgeIdList;
    }

    public void setKnowledgeIdList(List<Long> knowledgeIdList) {
        this.knowledgeIdList = knowledgeIdList;
    }

    public Long getQtypeId() {
        return this.qtypeId;
    }

    public void setQtypeId(Long qtypeId) {
        this.qtypeId = qtypeId;
    }

    public String getQbankIdListString() {
        List<Long> ids = this.getQbankIdList();
        return this._getIdString(ids);
    }

    public String getKnowledgeIdListString() {
        List<Long> ids = this.getKnowledgeIdList();
        return this._getIdString(ids);
    }

    private String _getIdString(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            if (id == null) continue;
            sb.append(id.toString());
            sb.append(",");
        }
        String str = sb.toString().trim();
        return str.isEmpty() ? "" : str.substring(0, str.length() - 1);
    }

    public List<ExamQuestion> getQuestions() {
        return this.questions;
    }

    public int getQuestionNumExcludeChildren() {
        if (this.questions == null || this.questions.isEmpty()) {
            return 0;
        }
        int num = 0;
        for (int i = 0; i < this.questions.size(); ++i) {
            Long pid = this.questions.get(i).getParentId();
            if (pid != null && pid != 0L) continue;
            ++num;
        }
        return num;
    }

    public void setQuestions(List<ExamQuestion> questions) {
        this.questions = questions;
    }

    public List<Long> getExceptQuestionIds() {
        return this.exceptQuestionIds;
    }

    public void setExceptQuestionIds(List<Long> exceptQuestionIds) {
        this.exceptQuestionIds = exceptQuestionIds;
    }

    public Integer getMaxQuestionnum() {
        return this.maxQuestionnum;
    }

    public void setMaxQuestionnum(Integer maxQuestionnum) {
        this.maxQuestionnum = maxQuestionnum;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public static Map<String, JSONObject> toMaxQuestionnumMap(List<ExamPaperTplBlock> blocks) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (int k = 0; blocks != null && k < blocks.size(); ++k) {
            ExamPaperTplBlock block = blocks.get(k);
            map.put(block.getKey(), block.toJSONObject());
        }
        return map;
    }

    public static int getQuestionnum(List<ExamPaperTplBlock> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return 0;
        }
        int cnt = 0;
        for (ExamPaperTplBlock b : blocks) {
            if (b == null) continue;
            cnt += b.getQuestionnum() == null ? 0 : b.getQuestionnum();
        }
        return cnt;
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        jObj.put((Object)"maxQuestionnum", (Object)(this.getMaxQuestionnum() == null ? 0 : this.getMaxQuestionnum()));
        jObj.put((Object)"isEmpty", (Object)this.getIsEmpty());
        jObj.put((Object)"isSatisfied", (Object)this.getIsSatisfied());
        return jObj;
    }

    public boolean getIsEmpty() {
        return this.questionnum == null || this.questionnum <= 0;
    }

    public boolean getIsSatisfied() {
        if (this.maxQuestionnum == null || this.maxQuestionnum <= 0) {
            return false;
        }
        if (this.questionnum == null || this.questionnum <= 0) {
            return false;
        }
        return this.maxQuestionnum >= this.questionnum;
    }

    public List<Long> getMustQuestionIds() {
        return this.mustQuestionIds;
    }

    public void setMustQuestionIds(List<Long> mustQuestionIds) {
        this.mustQuestionIds = mustQuestionIds;
    }

    public Boolean getIsMutex() {
        return this.isMutex;
    }

    public void setIsMutex(Boolean isMutex) {
        this.isMutex = isMutex;
    }

    public Date getNow() {
        return new Date();
    }

    public List<Long> getTagIdList() {
        return this.tagIdList;
    }

    public void setTagIdList(List<Long> tagIdList) {
        this.tagIdList = tagIdList;
    }
}

