/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.model;

import com.peak.app.exampro.exampapertpl.model.AbstractExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplKnowDifficulty;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQBank;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQType;
import java.util.ArrayList;
import java.util.List;

public class ExamPaperTplByKnowDiffi
extends AbstractExamPaperTpl {
    @Override
    public void buildBlocks() {
        if (this.getQbanks() == null || this.getQbanks().isEmpty()) {
            return;
        }
        if (this.getQtypes() == null || this.getQtypes().isEmpty()) {
            return;
        }
        Integer byQBPercent = this.getByQBPercent();
        if (byQBPercent == null || byQBPercent != 1) {
            for (int i = 0; i < this.qtypes.size(); ++i) {
                int qtQuestionnum;
                ExamPaperTplQType qt = (ExamPaperTplQType)this.qtypes.get(i);
                List<ExamPaperTplKnowDifficulty> knowDiffs = qt.getKnowDifficulties();
                int leftNum = qtQuestionnum = qt.getQuestionnumExceptMust() == null ? 0 : qt.getQuestionnumExceptMust();
                for (int j = 0; j < knowDiffs.size(); ++j) {
                    ExamPaperTplKnowDifficulty knowDiff = knowDiffs.get(j);
                    ArrayList<ExamPaperTplBlock> blocks = new ArrayList<ExamPaperTplBlock>();
                    Integer diffNum = null;
                    for (int k = 0; k < 5; ++k) {
                        ExamPaperTplBlock block = new ExamPaperTplBlock();
                        if (k == 0) {
                            diffNum = knowDiff.getDiff1Percent();
                        } else if (k == 1) {
                            diffNum = knowDiff.getDiff2Percent();
                        } else if (k == 2) {
                            diffNum = knowDiff.getDiff3Percent();
                        } else if (k == 3) {
                            diffNum = knowDiff.getDiff4Percent();
                        } else if (k == 4) {
                            diffNum = knowDiff.getDiff5Percent();
                        }
                        if (diffNum != null && diffNum > 0) {
                            if (diffNum > leftNum) {
                                diffNum = leftNum;
                            }
                            leftNum -= diffNum.intValue();
                        }
                        block.setQuestionnum(diffNum);
                        block.setDifficulty(k + 1);
                        block.setQtypeId(qt.getQtypeId());
                        block.setScore(qt.getScore());
                        block.setQbankIds(ExamPaperTplQBank.getQBankIds(this.qbanks));
                        block.setQbankIdList(ExamPaperTplQBank.getQBankIdList(this.qbanks));
                        block.setKnowledgeIds(knowDiff.getKnowledgeId().toString());
                        ArrayList<Long> kIds = new ArrayList<Long>();
                        kIds.add(knowDiff.getKnowledgeId());
                        block.setKnowledgeIdList(kIds);
                        block.setKey("block_qtype_" + qt.getQtypeId() + "_know" + knowDiff.getKnowledgeId() + "_diff" + (k + 1));
                        blocks.add(block);
                    }
                    knowDiff.setBlocks(blocks);
                }
            }
        } else {
            for (int i = 0; i < this.qtypes.size(); ++i) {
                int qtQuestionnum;
                ExamPaperTplQType qt = (ExamPaperTplQType)this.qtypes.get(i);
                List<ExamPaperTplKnowDifficulty> knowDiffs = qt.getKnowDifficulties();
                int leftNum = qtQuestionnum = qt.getQuestionnumExceptMust() == null ? 0 : qt.getQuestionnumExceptMust();
                ExamPaperTplBlock lastBlock = null;
                for (int j = 0; j < knowDiffs.size(); ++j) {
                    ExamPaperTplKnowDifficulty knowDiff = knowDiffs.get(j);
                    ArrayList<ExamPaperTplBlock> blocks = new ArrayList<ExamPaperTplBlock>();
                    Integer diffPercent = null;
                    for (int k = 0; k < 5; ++k) {
                        ExamPaperTplBlock block = new ExamPaperTplBlock();
                        if (k == 0) {
                            diffPercent = knowDiff.getDiff1Percent();
                        } else if (k == 1) {
                            diffPercent = knowDiff.getDiff2Percent();
                        } else if (k == 2) {
                            diffPercent = knowDiff.getDiff3Percent();
                        } else if (k == 3) {
                            diffPercent = knowDiff.getDiff4Percent();
                        } else if (k == 4) {
                            diffPercent = knowDiff.getDiff5Percent();
                        }
                        int num = 0;
                        if (diffPercent != null && diffPercent > 0) {
                            num = (int)Math.round((double)(qtQuestionnum * diffPercent) / 100.0);
                            if (num < 1) {
                                num = 1;
                            }
                            if (num > leftNum) {
                                num = leftNum;
                            }
                            leftNum -= num;
                            lastBlock = block;
                        }
                        block.setQuestionnum(num);
                        block.setDifficulty(k + 1);
                        block.setQtypeId(qt.getQtypeId());
                        block.setScore(qt.getScore());
                        block.setQbankIds(ExamPaperTplQBank.getQBankIds(this.qbanks));
                        block.setQbankIdList(ExamPaperTplQBank.getQBankIdList(this.qbanks));
                        block.setKnowledgeIds(knowDiff.getKnowledgeId().toString());
                        ArrayList<Long> kIds = new ArrayList<Long>();
                        kIds.add(knowDiff.getKnowledgeId());
                        block.setKnowledgeIdList(kIds);
                        block.setKey("block_qtype_" + qt.getQtypeId() + "_know" + knowDiff.getKnowledgeId() + "_diff" + (k + 1));
                        blocks.add(block);
                    }
                    knowDiff.setBlocks(blocks);
                }
                if (leftNum <= 0 || lastBlock == null) continue;
                lastBlock.setQuestionnum(lastBlock.getQuestionnum() + leftNum);
            }
        }
    }
}

