/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.model;

import com.peak.app.base.BaseEntityBean;
import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplSection;
import com.peak.framework.common.util.DateConvertUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ExamPaperTplGen
extends BaseEntityBean
implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;
    public static final String TABLE_NAME = "EXAM_PAPER_TPL_GEN";
    public static final String TABLE_ALIAS = "\u8bd5\u5377\u6a21\u677f\u751f\u6210\u5377\u5b50";
    public static final String ALIAS_TEMPLATE_ID = "\u8bd5\u5377\u6a21\u677fId";
    public static final String ALIAS_GENERATEID = "\u751f\u6210id";
    public static final String ALIAS_DATA = "\u6570\u636e";
    public static final String ALIAS_CREATOR_ID = "\u521b\u5efa\u4eba";
    public static final String ALIAS_CREATEDATE = "\u521b\u5efa\u65f6\u95f4";
    public static final String FORMAT_CREATEDATE = "yyyy-MM-dd";
    private Long templateId;
    private String generateid;
    private String data;
    private Long creatorId;
    private Date createdate;
    private String title;
    private ExamPaperTpl template;
    private List<ExamQuestion> conflictQuestions = new ArrayList<ExamQuestion>();
    private boolean allinone;

    public ExamPaperTplGen() {
    }

    public ExamPaperTplGen(Long templateId, String generateid) {
        this.templateId = templateId;
        this.generateid = generateid;
    }

    public void setTemplateId(Long value) {
        this.templateId = value;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setGenerateid(String value) {
        this.generateid = value;
    }

    public String getGenerateid() {
        return this.generateid;
    }

    public void setData(String value) {
        this.data = value;
    }

    public String getData() {
        return this.data;
    }

    public void setCreatorId(Long value) {
        this.creatorId = value;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public String getCreatedateString() {
        return DateConvertUtils.format((Date)this.getCreatedate(), (String)FORMAT_CREATEDATE);
    }

    public void setCreatedateString(String value) {
        this.setCreatedate(DateConvertUtils.parse((String)value, (String)FORMAT_CREATEDATE, Date.class));
    }

    public void setCreatedate(Date value) {
        this.createdate = value;
    }

    public Date getCreatedate() {
        return this.createdate;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("TemplateId", (Object)this.getTemplateId()).append("Generateid", (Object)this.getGenerateid()).append("Data", (Object)this.getData()).append("CreatorId", (Object)this.getCreatorId()).append("Createdate", (Object)this.getCreatedate()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getTemplateId()).append((Object)this.getGenerateid()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExamPaperTplGen)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExamPaperTplGen other = (ExamPaperTplGen)obj;
        return new EqualsBuilder().append((Object)this.getTemplateId(), (Object)other.getTemplateId()).append((Object)this.getGenerateid(), (Object)other.getGenerateid()).isEquals();
    }

    public boolean isNew() {
        if (this.isNullOrEmpty(this.getTemplateId())) {
            return true;
        }
        return this.isNullOrEmpty(this.getGenerateid());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static String fromTemplate(ExamPaperTpl template) {
        JSONArray jAry = new JSONArray();
        List<? extends ExamPaperTplSection> questiontypes = template.getSections();
        for (int i = 0; questiontypes != null && i < questiontypes.size(); ++i) {
            ExamPaperTplSection questiontype = questiontypes.get(i);
            JSONArray jQuestions = new JSONArray();
            List<ExamPaperTplBlock> questionblocks = questiontype.getBlocksIncludeMust();
            for (int j = 0; questionblocks != null && j < questionblocks.size(); ++j) {
                ExamPaperTplBlock block = questionblocks.get(j);
                List<ExamQuestion> qs = block.getQuestions();
                for (int k = 0; qs != null && k < qs.size(); ++k) {
                    JSONObject jQ = new JSONObject();
                    jQ.put((Object)"id", (Object)qs.get(k).getQuestionId());
                    jQ.put((Object)"score", (Object)qs.get(k).getScore());
                    jQuestions.add((Object)jQ);
                }
            }
            JSONObject jType = new JSONObject();
            jType.put((Object)"title", (Object)questiontype.getTitle());
            jType.put((Object)"totalscore", (Object)questiontype.getTotalscore());
            jType.put((Object)"qtypeId", (Object)questiontype.getQtypeId());
            jType.put((Object)"questions", (Object)jQuestions);
            jAry.add((Object)jType);
        }
        return jAry.toString();
    }

    public ExamPaperTpl getTemplate() {
        return this.template;
    }

    public void setTemplate(ExamPaperTpl template) {
        this.template = template;
    }

    public List<ExamQuestion> getConflictQuestions() {
        return this.conflictQuestions;
    }

    public void setConflictQuestions(List<ExamQuestion> conflictQuestions) {
        this.conflictQuestions = conflictQuestions;
    }

    public List<ExamQuestion> getSortedConflictQuestions() {
        Collections.sort(this.conflictQuestions, new Comparator(){

            public int compare(Object q1, Object q2) {
                ExamQuestion qq1 = (ExamQuestion)q1;
                ExamQuestion qq2 = (ExamQuestion)q2;
                return qq1.getContent().compareTo(qq2.getContent());
            }
        });
        return this.conflictQuestions;
    }

    public void addConflictQuestion(ExamQuestion ques) {
        if (ques == null) {
            return;
        }
        for (int i = 0; i < this.conflictQuestions.size(); ++i) {
            if (!this.conflictQuestions.get(i).getQuestionId().equals(ques.getQuestionId())) continue;
            return;
        }
        this.conflictQuestions.add(ques);
    }

    public boolean isAllinone() {
        return this.allinone;
    }

    public void setAllinone(boolean allinone) {
        this.allinone = allinone;
    }
}

