/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.model;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplItem;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamPaperTplSection
extends ExamPaperTplItem {
    private static final Logger log = LoggerFactory.getLogger(ExamPaperTplSection.class);
    protected Double score;
    protected List<ExamQuestion> mustQuestions;
    private Long qtypeId;
    private List<ExamPaperTplBlock> blocks;
    private ExamPaperTplBlock mustBlock;

    public ExamPaperTplSection() {
        this.setParentId(0L);
        this.setItemtype("SECTION");
    }

    public Long getQtypeId() {
        return this.qtypeId;
    }

    public void setQtypeId(Long qtypeId) {
        this.qtypeId = qtypeId;
    }

    public Double getTotalscore() {
        List<ExamPaperTplBlock> blocks = this.getBlocksIncludeMust();
        if (blocks == null || blocks.size() == 0) {
            return 0.0;
        }
        double totalscore = 0.0;
        for (ExamPaperTplBlock b : blocks) {
            if (b.getQuestionnum() == null || b.getScore() == null) continue;
            totalscore += b.getScore() * (double)b.getQuestionNumExcludeChildren();
        }
        return totalscore;
    }

    public Double getFetchedTotalscore() {
        List<ExamPaperTplBlock> blocks = this.getBlocksIncludeMust();
        if (blocks == null || blocks.size() == 0) {
            return 0.0;
        }
        double totalscore = 0.0;
        for (ExamPaperTplBlock b : blocks) {
            if (b.getQuestionnum() == null || b.getScore() == null || b.getQuestions() == null || b.getQuestions().isEmpty()) continue;
            totalscore += b.getScore() * (double)b.getQuestionNumExcludeChildren();
        }
        return totalscore;
    }

    public Integer getQuestionnum() {
        List<ExamPaperTplBlock> blocks = this.getBlocksIncludeMust();
        if (blocks == null || blocks.size() == 0) {
            return 0;
        }
        int totalnum = 0;
        for (ExamPaperTplBlock b : blocks) {
            totalnum += b.getQuestionNumExcludeChildren();
        }
        if (log.isDebugEnabled()) {
            log.debug("section.questionnum:{}", (Object)totalnum);
        }
        return totalnum;
    }

    public Integer getWantQuestionum() {
        List<ExamPaperTplBlock> blocks = this.getBlocksIncludeMust();
        if (blocks == null || blocks.size() == 0) {
            return 0;
        }
        int totalnum = 0;
        for (ExamPaperTplBlock b : blocks) {
            totalnum += b.getQuestionnum() == null ? 0 : b.getQuestionnum();
        }
        if (log.isDebugEnabled()) {
            log.debug("section.wantQuestionnum:{}", (Object)totalnum);
        }
        return totalnum;
    }

    public Integer getFetchedQuestionnum() {
        List<ExamPaperTplBlock> blocks = this.getBlocksIncludeMust();
        if (blocks == null || blocks.size() == 0) {
            return 0;
        }
        int totalnum = 0;
        for (ExamPaperTplBlock b : blocks) {
            totalnum += b.getQuestionNumExcludeChildren();
        }
        if (log.isDebugEnabled()) {
            log.debug("section.fetchedQuestionnum:{}", (Object)totalnum);
        }
        return totalnum;
    }

    public List<ExamPaperTplBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<ExamPaperTplBlock> blocks) {
        this.blocks = blocks;
    }

    public ExamPaperTplBlock getMustBlock() {
        if (this.mustQuestions == null || this.mustQuestions.isEmpty()) {
            return null;
        }
        if (this.mustBlock == null) {
            this.mustBlock = new ExamPaperTplBlock();
        }
        this.mustBlock.setScore(this.score);
        this.mustBlock.setQtypeId(this.qtypeId);
        this.mustBlock.setQuestionnum(this.mustQuestions.size());
        this.mustBlock.setKey("block_qtype" + this.qtypeId + "_must");
        ArrayList<Long> mustQuestionIds = new ArrayList<Long>();
        for (ExamQuestion q : this.mustQuestions) {
            mustQuestionIds.add(q.getQuestionId());
        }
        this.mustBlock.setMustQuestionIds(mustQuestionIds);
        return this.mustBlock;
    }

    public List<ExamPaperTplBlock> getBlocksIncludeMust() {
        if (this.mustQuestions == null || this.mustQuestions.isEmpty()) {
            return this.getBlocks();
        }
        ArrayList<ExamPaperTplBlock> allBlocks = new ArrayList<ExamPaperTplBlock>();
        allBlocks.add(this.getMustBlock());
        List<ExamPaperTplBlock> blocks = this.getBlocks();
        if (blocks != null) {
            allBlocks.addAll(blocks);
        }
        return allBlocks;
    }

    public List<ExamQuestion> getMustQuestions() {
        return this.mustQuestions;
    }

    public void setMustQuestions(List<ExamQuestion> mustQuestions) {
        this.mustQuestions = mustQuestions;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public int getMustQuestionnum() {
        return this.mustQuestions == null ? 0 : this.mustQuestions.size();
    }
}

