/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.service.imple;

import com.peak.app.exam.common.dao.IExamResourceRelationDao;
import com.peak.app.exam.common.model.ExamResourceRelation;
import com.peak.app.exam.examarrange.service.IExamArrangePaperService;
import com.peak.app.exam.exampaper.model.ExamPaper;
import com.peak.app.exam.exampaper.model.ExamPaperType;
import com.peak.app.exam.exampaper.service.IExamPaperQuestionService;
import com.peak.app.exam.exampaper.service.IExamPaperService;
import com.peak.app.exam.exampaper.service.IExamPaperTypeService;
import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exam.examquestion.service.IExamQuestionClobService;
import com.peak.app.exam.examquestion.service.IExamQuestionService;
import com.peak.app.exampro.exampapertpl.bean.ExamPaperTplGenContext;
import com.peak.app.exampro.exampapertpl.dao.IExamPaperTplGenDao;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByDiffi;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByKnowDiffi;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByType;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplGen;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplSection;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByDiffiService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByKnowDiffiService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByTypeService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplGenService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplItemService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplService;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplGenQuery;
import com.peak.app.exampro.examquestion.service.IExamProQuestionService;
import com.peak.app.exampro.util.ProgressUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.examplus.exam.util.ExamUtil;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.exampaper.service.IExamPaperTypePlusService;
import com.peak.prd.exam.exampaper.vo.ExamPaperTypeQuery;
import com.peak.prd.exam.examquestion.service.IExamQuestionClobPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPlusService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperTplGenService
extends BaseService<ExamPaperTplGen, Map<String, Object>, ExamPaperTplGenQuery>
implements IExamPaperTplGenService {
    private static final Logger log = LoggerFactory.getLogger(ExamPaperTplGenService.class);
    @Autowired
    private IExamPaperQuestionPlusService examPaperQuestionPlusService;
    @Autowired
    private IExamQuestionPlusService examQuestionPlusService;
    @Autowired
    private IExamQuestionClobPlusService examQuestionClobPlusService;
    private IExamPaperTplGenDao examPaperTplGenDao;
    private IExamPaperService examPaperService;
    private IExamPaperQuestionService examPaperQuestionService;
    private IExamQuestionService examQuestionService;
    private IExamPaperTypeService examPaperTypeService;
    private IExamResourceRelationDao examResourceRelationDao;
    private IExamQuestionClobService examQuestionClobService;
    private IExamPaperTplService examPaperTplService;
    private IExamPaperTplByTypeService examPaperTplByTypeService;
    private IExamPaperTplByDiffiService examPaperTplByDiffiService;
    private IExamPaperTplByKnowDiffiService examPaperTplByKnowDiffiService;
    private IExamPaperTplItemService examPaperTplItemService;
    private IExamArrangePaperService examArrangePaperService;
    private IExamProQuestionService examProQuestionService;

    public void setExamArrangePaperService(IExamArrangePaperService examArrangePaperService) {
        this.examArrangePaperService = examArrangePaperService;
    }

    public void setExamPaperTplItemService(IExamPaperTplItemService examPaperTplItemService) {
        this.examPaperTplItemService = examPaperTplItemService;
    }

    public void setExamPaperTplByTypeService(IExamPaperTplByTypeService examPaperTplByTypeService) {
        this.examPaperTplByTypeService = examPaperTplByTypeService;
    }

    public void setExamPaperTplByDiffiService(IExamPaperTplByDiffiService examPaperTplByDiffiService) {
        this.examPaperTplByDiffiService = examPaperTplByDiffiService;
    }

    public void setExamPaperTplByKnowDiffiService(IExamPaperTplByKnowDiffiService examPaperTplByKnowDiffiService) {
        this.examPaperTplByKnowDiffiService = examPaperTplByKnowDiffiService;
    }

    public void setExamPaperTplService(IExamPaperTplService examPaperTplService) {
        this.examPaperTplService = examPaperTplService;
    }

    public void setExamPaperService(IExamPaperService examPaperService) {
        this.examPaperService = examPaperService;
    }

    public void setExamQuestionClobService(IExamQuestionClobService examQuestionClobService) {
        this.examQuestionClobService = examQuestionClobService;
    }

    public void setExamQuestionService(IExamQuestionService examQuestionService) {
        this.examQuestionService = examQuestionService;
    }

    public void setExamPaperQuestionService(IExamPaperQuestionService examPaperQuestionService) {
        this.examPaperQuestionService = examPaperQuestionService;
    }

    public void setExamPaperTypeService(IExamPaperTypeService examPaperTypeService) {
        this.examPaperTypeService = examPaperTypeService;
    }

    public void setExamResourceRelationDao(IExamResourceRelationDao examResourceRelationDao) {
        this.examResourceRelationDao = examResourceRelationDao;
    }

    public void setExamPaperTplGenDao(IExamPaperTplGenDao dao) {
        this.examPaperTplGenDao = dao;
    }

    public IExamPaperTplGenDao getExamPaperTplGenDao() {
        return this.examPaperTplGenDao;
    }

    public IEntityDao<ExamPaperTplGen, Map<String, Object>, ExamPaperTplGenQuery> getEntityDao() {
        return this.examPaperTplGenDao;
    }

    public void setExamProQuestionService(IExamProQuestionService examProQuestionService) {
        this.examProQuestionService = examProQuestionService;
    }

    @Override
    public ExamPaper txSaveasPaper(ExamPaperTplGen gen, ExamPaper paper) throws Exception {
        return this.saveasPaper(gen, paper, 0L, null);
    }

    @Override
    public ExamPaper txSaveasPaper(ExamPaperTplGen gen, ExamPaper paper, Long subjectId) throws Exception {
        return this.saveasPaper(gen, paper, subjectId, null);
    }

    @Override
    public ExamPaper txSaveasPaper(ExamPaperTplGen gen, ExamPaper paper, Long subjectId, JSONArray jSections) throws Exception {
        return this.saveasPaper(gen, paper, subjectId, jSections);
    }

    private ExamPaper saveasPaper(ExamPaperTplGen gen, ExamPaper paper, Long subjectId, JSONArray jSections) throws Exception {
        boolean isInsert;
        paper.setTitle(paper.getTitle() == null ? gen.getTitle() : paper.getTitle());
        paper.setGkey(UUID.randomUUID().toString().replaceAll("-", ""));
        paper.setEnterpriseId(9002L);
        paper.setCreateDate(new Date());
        boolean bl = isInsert = paper.getPaperId() == null;
        if (isInsert) {
            paper.setPaperId(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER"));
            paper.setStatus(0);
            paper.setFullMark(0);
            this.examPaperService.insert(paper);
        }
        Double totalscore = this.savePaperQuestions(gen, paper.getPaperId(), isInsert, jSections);
        if (isInsert) {
            paper.setFullMark(totalscore.intValue());
            this.examPaperService.update(paper);
        }
        if (isInsert) {
            ExamResourceRelation rr = new ExamResourceRelation(IPrimaryKey.DEFAULT.getSequence("EXAM_RESOURCE_RELATION"));
            rr.setExamResourceId(paper.getPaperId());
            rr.setExamType(2);
            rr.setResourceType(5);
            rr.setResourceId(subjectId == null ? Long.valueOf(0L) : subjectId);
            this.examResourceRelationDao.insert(rr);
        }
        return paper;
    }

    private Double savePaperQuestions(ExamPaperTplGen gen, Long paperId, boolean bInsert, JSONArray jSections) throws Exception {
        int totalscore = 0;
        JSONArray jAry = null;
        jAry = jSections == null ? (gen == null || gen.getData() == null ? null : JSONArray.fromObject((Object)gen.getData())) : jSections;
        ArrayList<ExamPaperType> paperTypes = new ArrayList<ExamPaperType>();
        ArrayList<ExamPaperQuestion> pqList = new ArrayList<ExamPaperQuestion>();
        for (int i = 0; jAry != null && i < jAry.size(); ++i) {
            JSONObject jType = jAry.getJSONObject(i);
            JSONArray jQuestions = jType.has("questions") ? jType.getJSONArray("questions") : null;
            ExamPaperType pt = new ExamPaperType(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TYPE"));
            pt.setPaperId(paperId);
            pt.setTypeId(jType.getLong("qtypeId"));
            pt.setScore(0.0);
            pt.setNotes(jType.has("title") ? jType.getString("title") : "");
            pt.setBigSequence(i + 1);
            pt.setNum(jQuestions != null ? jQuestions.size() : 0);
            pt.setCreateDate(gen.getCreatedate());
            paperTypes.add(pt);
            for (int j = 0; jQuestions != null && j < jQuestions.size(); ++j) {
                JSONObject jQ = jQuestions.getJSONObject(j);
                boolean withClob = true;
                com.peak.prd.exam.examquestion.model.ExamQuestion q = this.examQuestionPlusService.getById(Long.valueOf(jQ.getLong("id")), withClob);
                if (q == null) continue;
                ExamPaperQuestion pq = new ExamPaperQuestion(Long.valueOf(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_QUESTION")));
                pq.setPaperId(paperId);
                pq.setScore(Double.valueOf(jQ.has("score") ? jQ.getDouble("score") : 0.0));
                pq.setQuestionId(q.getQuestionId());
                pq.setParentId(q.getParentId());
                pq.setUseclob(q.getUseclob());
                pq.setTypeId(q.getTypeId());
                pq.setContent(q.getContent());
                pq.setOptions(q.getOptions());
                pq.setDetailanswer(q.getDetailanswer());
                pq.setAnswer(q.getAnswer());
                pq.setDifficulty(q.getDifficulty());
                pq.setDisorder(q.getIsdisorder());
                pq.setCreatedate(gen.getCreatedate());
                pq.setPtId(pt.getPtId());
                if (gen != null && gen.isAllinone()) {
                    com.peak.prd.exam.exampaper.model.ExamPaperType examPaperType = this.getExamPaperType(paperId, pq.getTypeId());
                    pq.setPtId(examPaperType == null ? null : examPaperType.getPtId());
                }
                int pqUseClob = this.examQuestionClobPlusService.saveLob(pq);
                pq.setUseclob(Integer.valueOf(pqUseClob));
                pqList.add(pq);
                totalscore = (int)((long)totalscore + Math.round(pq.getScore() * 100.0));
            }
        }
        this.examPaperTplGenDao.deletePaperQuestions(paperId);
        if (pqList != null && pqList.size() > 0) {
            boolean isGddb;
            boolean bl = isGddb = "gdxyk".equals(ExamUtil.getPrj()) || "guangda".equals(ExamUtil.getPrj());
            if (isGddb) {
                log.info("gd | gdxyk \u7ec4\u5377");
                for (int i = 0; i < pqList.size(); ++i) {
                    ExamPaperQuestion pqGdxyk = (ExamPaperQuestion)pqList.get(i);
                    pqGdxyk.setContent(this.replaceByGdxyk(pqGdxyk.getContent()));
                    pqGdxyk.setBriefcontent(this.replaceByGdxyk(pqGdxyk.getBriefcontent()));
                    pqGdxyk.setOptions(this.replaceByGdxyk(pqGdxyk.getOptions()));
                    pqGdxyk.setAnswer(this.replaceByGdxyk(pqGdxyk.getAnswer()));
                    pqGdxyk.setDetailanswer(this.replaceByGdxyk(pqGdxyk.getDetailanswer()));
                }
                this.examPaperQuestionPlusService.insertBatch(pqList);
            } else {
                this.examPaperQuestionPlusService.insertBatch(pqList);
            }
        }
        if (bInsert) {
            this.examPaperTplGenDao.deletePaperTypes(paperId);
            if (paperTypes != null && paperTypes.size() > 0) {
                this.examPaperTypeService.insert(paperTypes);
            }
        }
        return (double)totalscore / 100.0;
    }

    private String replaceByGdxyk(String str) {
        if (str == null) {
            return str;
        }
        return str.replace(';', '\uff1b');
    }

    private com.peak.prd.exam.exampaper.model.ExamPaperType getExamPaperType(Long paperId, Long typeId) {
        if (paperId == null || typeId == null) {
            return null;
        }
        ExamPaperTypeQuery examPaperTypeQuery = new ExamPaperTypeQuery();
        examPaperTypeQuery.setPaperId(paperId);
        examPaperTypeQuery.setTypeId(typeId);
        return (com.peak.prd.exam.exampaper.model.ExamPaperType)((IExamPaperTypePlusService)SpringUtil.getBean(IExamPaperTypePlusService.class)).getPrdEntityDao().findOne((IQuery)examPaperTypeQuery);
    }

    @Override
    public ExamPaperTplGen generate(ExamPaperTplGenContext context, ExamPaperTplGen examPaperTplGen, Long templateId) throws Exception {
        return this.generate(context, examPaperTplGen, this.loadById(templateId));
    }

    private int getNeedQuestionNum(ExamPaperTpl tpl) {
        List<ExamPaperTplBlock> blocks = tpl.getTotalBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return 0;
        }
        int num = 0;
        for (int i = 0; i < blocks.size(); ++i) {
            if (blocks.get(i).getQuestionnum() == null) continue;
            num += blocks.get(i).getQuestionnum().intValue();
        }
        return num;
    }

    private ExamPaperTplGen generate(ExamPaperTplGenContext context, ExamPaperTplGen examPaperTplGen, ExamPaperTpl examPaperTemplate) throws Exception {
        examPaperTplGen.setTemplate(examPaperTemplate);
        examPaperTplGen.setTemplateId(examPaperTemplate.getTemplateId());
        int needTotalNum = this.getNeedQuestionNum(examPaperTemplate);
        ProgressUtil.update(context.getProgresskey(), 0, needTotalNum);
        int totalBlockNum = examPaperTemplate.getTotalBlocksNum();
        if (totalBlockNum == 0) {
            examPaperTplGen.setData(null);
            return examPaperTplGen;
        }
        int doneBlockNum = 0;
        List<? extends ExamPaperTplSection> sections = examPaperTemplate.getSections();
        for (int i = 0; i < sections.size(); ++i) {
            List<ExamPaperTplBlock> questionblocks = sections.get(i).getBlocksIncludeMust();
            for (int j = 0; questionblocks != null && j < questionblocks.size(); ++j) {
                ExamPaperTplBlock block = questionblocks.get(j);
                block.setQtypeId(sections.get(i).getQtypeId());
                List<ExamQuestion> questions = this.examPaperTplItemService.fetchQuestions(context, examPaperTplGen, block, examPaperTemplate);
                if (block.hasChilrenQuestions() && questions != null && questions.size() > 0) {
                    int cqNum = questions.size();
                    int index = 0;
                    int x = 0;
                    while (x < cqNum) {
                        ExamQuestion cq = questions.get(index);
                        cq.setScore(0.0);
                        double cqScore = block.getScore() == null ? 0.0 : block.getScore();
                        List<ExamQuestion> children = this.examProQuestionService.findChildrenByParentId(cq.getQuestionId());
                        double leftScore = cqScore;
                        for (int y = 0; children != null && y < children.size(); ++y) {
                            double childScore = (double)Math.round(cqScore * 10.0 / (double)children.size()) / 10.0;
                            if (y == children.size() - 1) {
                                childScore = leftScore;
                            }
                            children.get(y).setScore(childScore);
                            leftScore -= childScore;
                        }
                        if (children != null && children.size() > 0) {
                            questions.addAll(index + 1, children);
                            index += children.size();
                        }
                        ++x;
                        ++index;
                    }
                }
                block.setQuestions(questions);
                ++doneBlockNum;
            }
        }
        examPaperTplGen.setData(ExamPaperTplGen.fromTemplate(examPaperTemplate));
        examPaperTplGen.setCreatedate(new Date());
        HashMap<String, Object> key = new HashMap<String, Object>();
        key.put("generateid", examPaperTplGen.getGenerateid());
        key.put("templateId", examPaperTplGen.getTemplateId());
        this.examPaperTplGenDao.deleteById(key);
        this.examPaperTplGenDao.insert(examPaperTplGen);
        ProgressUtil.update(context.getProgresskey(), 100, 100);
        return examPaperTplGen;
    }

    @Override
    public List<ExamPaper> generate(ExamPaperTplGenContext context, Long templateId, int count) throws Exception {
        ExamPaper tplPaper = (ExamPaper)this.examPaperService.getById(templateId);
        ArrayList<ExamPaper> paperList = new ArrayList<ExamPaper>();
        for (int a = 0; a < count; ++a) {
            long tmpStartms = System.currentTimeMillis();
            ProgressUtil.update(context.getProgresskey(), 0, -1, a, count);
            ExamPaperTpl examPaperTemplate = this.loadById(templateId);
            ExamPaper paper = new ExamPaper();
            paper.setDomainId(examPaperTemplate.getDomainId());
            paper.setCreatorId(examPaperTemplate.getCreatorId());
            paper.setCreatorName(null);
            paper.setExamTime(examPaperTemplate.getReplyminutes());
            paper.setPaperType(0);
            paper.setPaperMethod(examPaperTemplate.getPaperMethod());
            ExamPaperTplGen gen = new ExamPaperTplGen();
            gen.setTitle(examPaperTemplate.getTitle() + "_" + a);
            gen.setGenerateid(IdUtil.getGkey());
            this.generate(context, gen, examPaperTemplate);
            this.txSaveasPaper(gen, paper);
            if (paper.getFullMark().intValue() != tplPaper.getFullMark().intValue()) {
                log.warn("\u7ec4\u5377failed[loop:{}/{}, fullmark:{}/{}, paperId:{}, templateId:{}]", new Object[]{a + 1, count, (int)paper.getFullMark(), (int)tplPaper.getFullMark(), paper.getPaperId(), templateId});
                break;
            }
            log.info("\u7ec4\u5377ok[loop:{}/{}, fullmark:{}/{}, paperId:{}, templateId:{}, spent:{}ms]", new Object[]{a + 1, count, (int)paper.getFullMark(), (int)tplPaper.getFullMark(), paper.getPaperId(), templateId, System.currentTimeMillis() - tmpStartms});
            paperList.add(paper);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u5377{}/{}\u4efd\u7ed3\u675f, fullmark {} by templateId {}", new Object[]{paperList.size(), count, (int)tplPaper.getFullMark(), templateId});
        }
        return paperList;
    }

    private ExamPaperTpl loadById(Long templateId) {
        ExamPaperTpl examPaperTemplate = (ExamPaperTpl)this.examPaperTplService.getById(templateId);
        if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 2) {
            examPaperTemplate = this.examPaperTplByTypeService.loadById(templateId);
            ((ExamPaperTplByType)examPaperTemplate).buildBlocks();
        } else if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 3) {
            examPaperTemplate = this.examPaperTplByDiffiService.loadById(templateId);
            ((ExamPaperTplByDiffi)examPaperTemplate).buildBlocks();
        } else if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 4) {
            examPaperTemplate = this.examPaperTplByKnowDiffiService.loadById(templateId);
            ((ExamPaperTplByKnowDiffi)examPaperTemplate).buildBlocks();
        }
        return examPaperTemplate;
    }

    public ExamPaper generate_del(Long templateId) throws Exception {
        ExamPaperTpl examPaperTemplate = this.loadById(templateId);
        ExamPaperTplGen gen = new ExamPaperTplGen();
        gen.setTitle(examPaperTemplate.getTitle() + "_" + System.currentTimeMillis());
        gen.setGenerateid(UUID.randomUUID().toString().replaceAll("-", ""));
        this.generate(null, gen, examPaperTemplate);
        ExamPaper paper = new ExamPaper(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER"));
        paper.setDomainId(examPaperTemplate.getDomainId());
        paper.setCreatorId(examPaperTemplate.getCreatorId());
        paper.setCreatorName(null);
        paper.setExamTime(examPaperTemplate.getReplyminutes());
        paper.setPaperType(0);
        paper.setPaperMethod(examPaperTemplate.getPaperMethod());
        paper.setCreateDate(new Date());
        paper.setTitle(gen.getTitle());
        paper.setGkey(UUID.randomUUID().toString().replaceAll("-", ""));
        paper.setEnterpriseId(9002L);
        paper.setCorpId(paper.getDomainId());
        paper.setCreateDate(new Date());
        paper.setStatus(0);
        paper.setFullMark(0);
        this.examPaperService.insert(paper);
        Double totalscore = this.savePaperQuestions(gen, paper.getPaperId(), true, null);
        paper.setFullMark(totalscore.intValue());
        this.examPaperService.update(paper);
        return paper;
    }
}

