/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.service.imple;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampapertpl.bean.ExamPaperTplGenContext;
import com.peak.app.exampro.exampapertpl.dao.IExamPaperTplAttrDao;
import com.peak.app.exampro.exampapertpl.dao.IExamPaperTplItemDao;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplAttr;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplGen;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplItem;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplSection;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplItemService;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplItemQuery;
import com.peak.app.exampro.examquestion.service.IExamQuestionMutexService;
import com.peak.app.exampro.util.ProgressUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.exam.examquestion.model.ExamQuestionMutex;
import com.peak.prd.exam.examquestion.service.IExamQuestionMutexPlusService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperTplItemService
extends BaseService<ExamPaperTplItem, Long, ExamPaperTplItemQuery>
implements IExamPaperTplItemService {
    @Autowired
    private IExamQuestionMutexPlusService examQuestionMutexPlusService;
    private IExamPaperTplItemDao examPaperTplItemDao;
    private IExamPaperTplAttrDao examPaperTplAttrDao;
    private IExamQuestionMutexService examQuestionMutexService;

    public void setExamPaperTplItemDao(IExamPaperTplItemDao dao) {
        this.examPaperTplItemDao = dao;
    }

    public void setExamPaperTplAttrDao(IExamPaperTplAttrDao examPaperTplAttrDao) {
        this.examPaperTplAttrDao = examPaperTplAttrDao;
    }

    public void setExamQuestionMutexService(IExamQuestionMutexService examQuestionMutexService) {
        this.examQuestionMutexService = examQuestionMutexService;
    }

    public IExamPaperTplItemDao getExamPaperTplItemDao() {
        return this.examPaperTplItemDao;
    }

    public IEntityDao<ExamPaperTplItem, Long, ExamPaperTplItemQuery> getEntityDao() {
        return this.examPaperTplItemDao;
    }

    @Override
    public void txBatchUpdateOrdernum(List<ExamPaperTplItem> items) {
        if (items == null || items.size() == 0) {
            return;
        }
        for (ExamPaperTplItem item : items) {
            this.examPaperTplItemDao.updateSelective(item);
        }
    }

    @Override
    public ExamPaperTplSection getSectionById(Long itemId) {
        return this.examPaperTplItemDao.getSectionById(itemId);
    }

    @Override
    public ExamPaperTplBlock getBlockById(Long itemId) {
        return this.examPaperTplItemDao.getBlockById(itemId);
    }

    @Override
    public void txInsertBlock(ExamPaperTplBlock block) throws Exception {
        this.examPaperTplItemDao.insert(block);
        this.insertAttrs(block);
    }

    @Override
    public void txUpdateBlock(ExamPaperTplBlock block) throws Exception {
        this.examPaperTplItemDao.update(block);
        this.examPaperTplAttrDao.deleteAllByItemId(block.getItemId());
        this.insertAttrs(block);
    }

    private void insertAttrs(ExamPaperTplBlock block) throws Exception {
        int i;
        String[] ary;
        Date now = new Date();
        ExamPaperTplAttr attrScore = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
        attrScore.setAttrname("SCORE");
        attrScore.setItemId(block.getItemId());
        attrScore.setTemplateId(block.getTemplateId());
        attrScore.setFloatvalue(block.getScore());
        attrScore.setCreatedate(now);
        ExamPaperTplAttr attrQuestionnum = null;
        if (block.getQuestionnum() != null) {
            attrQuestionnum = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
            attrQuestionnum.setAttrname("NUM");
            attrQuestionnum.setItemId(block.getItemId());
            attrQuestionnum.setTemplateId(block.getTemplateId());
            attrQuestionnum.setLongvalue(block.getQuestionnum().longValue());
            attrQuestionnum.setCreatedate(now);
        }
        ExamPaperTplAttr attrDifficulty = null;
        if (block.getDifficulty() != null) {
            attrDifficulty = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
            attrDifficulty.setAttrname("DIFFICULTY");
            attrDifficulty.setItemId(block.getItemId());
            attrDifficulty.setTemplateId(block.getTemplateId());
            attrDifficulty.setLongvalue(block.getDifficulty().longValue());
            attrDifficulty.setCreatedate(now);
        }
        if (block.getQbankIds() != null && !block.getQbankIds().isEmpty()) {
            ary = block.getQbankIds().split(",");
            ArrayList<Long> bankIdAry = new ArrayList<Long>();
            String[] stringArray = ary;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String s = stringArray[j];
                if (s == null || s.trim().isEmpty()) continue;
                bankIdAry.add(new Long(s));
            }
            for (i = 0; i < bankIdAry.size(); ++i) {
                ExamPaperTplAttr attrBank = null;
                attrBank = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
                attrBank.setAttrname("BANK");
                attrBank.setItemId(block.getItemId());
                attrBank.setTemplateId(block.getTemplateId());
                attrBank.setLongvalue((long)((Long)bankIdAry.get(i)));
                attrBank.setCreatedate(now);
                this.examPaperTplAttrDao.insert(attrBank);
            }
        }
        if (block.getKnowledgeIds() != null && !block.getKnowledgeIds().isEmpty()) {
            ary = block.getKnowledgeIds().split(",");
            ArrayList<Long> knowledgeIdAry = new ArrayList<Long>();
            for (String s : ary) {
                if (s == null || s.trim().isEmpty()) continue;
                knowledgeIdAry.add(new Long(s));
            }
            for (i = 0; i < knowledgeIdAry.size(); ++i) {
                ExamPaperTplAttr attrKnow = null;
                attrKnow = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
                attrKnow.setAttrname("KNOWLEDGE");
                attrKnow.setItemId(block.getItemId());
                attrKnow.setTemplateId(block.getTemplateId());
                attrKnow.setLongvalue((long)((Long)knowledgeIdAry.get(i)));
                attrKnow.setCreatedate(now);
                this.examPaperTplAttrDao.insert(attrKnow);
            }
        }
        if (block.getTagIdList() != null && !block.getTagIdList().isEmpty()) {
            for (int i2 = 0; i2 < block.getTagIdList().size(); ++i2) {
                ExamPaperTplAttr attrTag = null;
                attrTag = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
                attrTag.setAttrname("TAG");
                attrTag.setItemId(block.getItemId());
                attrTag.setTemplateId(block.getTemplateId());
                attrTag.setLongvalue(block.getTagIdList().get(i2));
                attrTag.setCreatedate(now);
                this.examPaperTplAttrDao.insert(attrTag);
            }
        }
        this.examPaperTplAttrDao.insert(attrScore);
        if (attrQuestionnum != null) {
            this.examPaperTplAttrDao.insert(attrQuestionnum);
        }
        if (attrDifficulty != null) {
            this.examPaperTplAttrDao.insert(attrDifficulty);
        }
    }

    @Override
    public void txInsertSection(ExamPaperTplSection section) throws Exception {
        this.examPaperTplItemDao.insert(section);
        this.insertAttrs(section);
    }

    @Override
    public void txUpdateSection(ExamPaperTplSection section) throws Exception {
        this.examPaperTplItemDao.update(section);
        this.examPaperTplAttrDao.deleteAllByItemId(section.getItemId());
        this.insertAttrs(section);
    }

    private void insertAttrs(ExamPaperTplSection section) throws Exception {
        Date now = new Date();
        ExamPaperTplAttr attrQtype = null;
        if (section.getQtypeId() != null) {
            attrQtype = new ExamPaperTplAttr(IPrimaryKey.DEFAULT.getSequence("EXAM_PAPER_TPL_ATTR"));
            attrQtype.setAttrname("QTYPE");
            attrQtype.setItemId(section.getItemId());
            attrQtype.setTemplateId(section.getTemplateId());
            attrQtype.setLongvalue((long)section.getQtypeId());
            attrQtype.setCreatedate(now);
        }
        if (attrQtype != null) {
            this.examPaperTplAttrDao.insert(attrQtype);
        }
    }

    @Override
    public List<ExamQuestion> fetchQuestions(ExamPaperTplGenContext context, ExamPaperTplGen gen, ExamPaperTplBlock block, ExamPaperTpl examPaperTemplate) throws Exception {
        if (block.getMustQuestionIds() != null && !block.getMustQuestionIds().isEmpty()) {
            List<ExamQuestion> tmplist = this.examPaperTplItemDao.fetchQuestions(block);
            int addNum = tmplist == null ? 0 : tmplist.size();
            ProgressUtil.addCurrentNum(context.getProgresskey(), addNum);
            return tmplist;
        }
        Integer questionnum = block.getQuestionnum();
        if (questionnum == null || questionnum <= 0) {
            return null;
        }
        ArrayList<ExamQuestion> list = new ArrayList<ExamQuestion>();
        int cnt = 0;
        List<Long> exceptQuestionIds = examPaperTemplate.getTotalQuestionIds();
        if (exceptQuestionIds == null) {
            exceptQuestionIds = new ArrayList<Long>();
        }
        Map<String, ExamQuestion> allQuesMap = this.getTotalQuestionMap(examPaperTemplate);
        Map<String, ExamQuestion> allMutexs = context.isCheckQuesMutex() ? this.getMutexKeys(allQuesMap) : null;
        block.setQuestionnum((int)questionnum);
        block.setExceptQuestionIds(exceptQuestionIds);
        List<ExamQuestion> tmplist = this.examPaperTplItemDao.fetchQuestions(block);
        Map<Long, String> tmpmapOfQuesKeys = this.getQuesMutexkeyMap(tmplist);
        for (int i = 0; tmplist != null && i < tmplist.size(); ++i) {
            String quesMutexKey;
            ExamQuestion question = tmplist.get(i);
            ExamQuestion conflictQues = this.getConflictQues(context, question, allQuesMap, quesMutexKey = tmpmapOfQuesKeys.get(question.getQuestionId()), allMutexs);
            if (conflictQues == null) {
                ++cnt;
                list.add(question);
                allQuesMap.put(this.getQuestionKey(question), question);
                this.putMutex(quesMutexKey, question, allMutexs);
            } else {
                gen.addConflictQuestion(question);
                gen.addConflictQuestion(conflictQues);
            }
            exceptQuestionIds.add(question.getQuestionId());
        }
        while (cnt < questionnum) {
            block.setQuestionnum(1);
            block.setExceptQuestionIds(exceptQuestionIds);
            tmplist = this.examPaperTplItemDao.fetchQuestions(block);
            ExamQuestion question = tmplist == null || tmplist.isEmpty() ? null : tmplist.get(0);
            String quesMutexKey = this.getQuesMutexKey(question);
            ExamQuestion conflictQues = this.getConflictQues(context, question, allQuesMap, quesMutexKey, allMutexs);
            if (question == null) break;
            if (conflictQues == null) {
                ++cnt;
                list.add(question);
                allQuesMap.put(this.getQuestionKey(question), question);
                this.putMutex(quesMutexKey, question, allMutexs);
            } else {
                gen.addConflictQuestion(question);
                gen.addConflictQuestion(conflictQues);
            }
            exceptQuestionIds.add(question.getQuestionId());
        }
        block.setQuestionnum(questionnum);
        return list;
    }

    private void putMutex(String key, ExamQuestion question, Map<String, ExamQuestion> all) {
        if (key == null || question == null) {
            return;
        }
        all.put(key, question);
    }

    private Map<String, ExamQuestion> getTotalQuestionMap(ExamPaperTpl examPaperTemplate) {
        HashMap<String, ExamQuestion> all = new HashMap<String, ExamQuestion>();
        List<ExamPaperTplBlock> blocks = examPaperTemplate.getTotalBlocks();
        if (blocks == null || blocks.isEmpty()) {
            return all;
        }
        for (ExamPaperTplBlock block : blocks) {
            List<ExamQuestion> questions = block.getQuestions();
            if (questions == null || questions.isEmpty()) continue;
            for (ExamQuestion q : questions) {
                all.put(this.getQuestionKey(q), q);
            }
        }
        return all;
    }

    private String getQuestionKey(ExamQuestion q) {
        return q.getContent() + "_" + q.getTypeId();
    }

    private Map<Long, String> getQuesMutexkeyMap(List<ExamQuestion> questions) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (CollectionUtils.isEmpty(questions)) {
            return map;
        }
        List mutexList = this.examQuestionMutexPlusService.getByIds(IdUtil.getIds(questions, e -> e.getQuestionId()));
        for (int i = 0; mutexList != null && i < mutexList.size(); ++i) {
            ExamQuestionMutex mutex = (ExamQuestionMutex)mutexList.get(i);
            map.put(mutex.getQuestionId(), mutex.getMutexkey());
        }
        return map;
    }

    private String getQuesMutexKey(ExamQuestion question) {
        if (question == null) {
            return null;
        }
        ExamQuestionMutex mutex = (ExamQuestionMutex)this.examQuestionMutexPlusService.getById((Object)question.getQuestionId());
        return mutex == null ? null : mutex.getMutexkey();
    }

    private Map<String, ExamQuestion> getMutexKeys(Map<String, ExamQuestion> allMap) {
        HashMap<String, ExamQuestion> mutexKeys = new HashMap<String, ExamQuestion>();
        if (allMap == null || allMap.isEmpty()) {
            return mutexKeys;
        }
        ArrayList<Long> questionIds = new ArrayList<Long>();
        Iterator<ExamQuestion> iter = allMap.values().iterator();
        HashMap<Long, ExamQuestion> tmpMap = new HashMap<Long, ExamQuestion>();
        while (iter.hasNext()) {
            ExamQuestion eq = iter.next();
            questionIds.add(eq.getQuestionId());
            tmpMap.put(eq.getQuestionId(), eq);
        }
        List mutexList = this.examQuestionMutexPlusService.getByIds(questionIds);
        if (CollectionUtils.isEmpty((Collection)mutexList)) {
            return mutexKeys;
        }
        for (ExamQuestionMutex mutex : mutexList) {
            mutexKeys.put(mutex.getMutexkey(), (ExamQuestion)tmpMap.get(mutex.getQuestionId()));
        }
        return mutexKeys;
    }

    private ExamQuestion getConflictQues(ExamPaperTplGenContext context, ExamQuestion question, Map<String, ExamQuestion> allMap, String quesMutexKey, Map<String, ExamQuestion> allMutexs) {
        ExamQuestion conflictQues;
        if (question == null) {
            return null;
        }
        if (allMap == null || allMap.isEmpty()) {
            return null;
        }
        ExamQuestion examQuestion = conflictQues = context.isCheckQuesEqual() ? allMap.get(this.getQuestionKey(question)) : null;
        if (conflictQues != null) {
            return conflictQues;
        }
        if (quesMutexKey == null || allMutexs == null || allMutexs.isEmpty()) {
            return null;
        }
        return context.isCheckQuesMutex() ? allMutexs.get(quesMutexKey) : null;
    }

    @Override
    public void deleteAllByTemplateId(Long templateId) {
        this.examPaperTplAttrDao.deleteAllByTemplateId(templateId);
        this.examPaperTplItemDao.deleteAllByTemplateId(templateId);
    }

    @Override
    public void moveSectionUpDown(Long paperId, Long itemId, boolean isMoveUp) {
        ExamPaperTplItem item;
        int i;
        if (paperId == null || itemId == null) {
            return;
        }
        ExamPaperTplItemQuery query = new ExamPaperTplItemQuery();
        query.setTemplateId(paperId);
        query.setItemtype("SECTION");
        query.getPage().setSortColumns(isMoveUp ? "ordernum, createdate" : "ordernum DESC, createdate DESC");
        List list = this.findAll(query);
        HashSet<Integer> ordernumSet = new HashSet<Integer>();
        boolean hasBadData = false;
        for (i = 0; list != null && i < list.size(); ++i) {
            item = (ExamPaperTplItem)list.get(i);
            if (item.getOrdernum() == null || ordernumSet.contains(item.getOrdernum())) {
                hasBadData = true;
                break;
            }
            ordernumSet.add(item.getOrdernum());
        }
        if (hasBadData) {
            for (i = 0; list != null && i < list.size(); ++i) {
                item = (ExamPaperTplItem)list.get(i);
                item.setOrdernum(isMoveUp ? i + 1 : list.size() - i);
                this.updateSelective(item);
            }
        }
        for (i = 0; list != null && i < list.size(); ++i) {
            item = (ExamPaperTplItem)list.get(i);
            if (!itemId.equals(item.getItemId())) continue;
            if (i == 0) break;
            ExamPaperTplItem item1 = new ExamPaperTplItem(((ExamPaperTplItem)list.get(i - 1)).getItemId());
            item1.setOrdernum(((ExamPaperTplItem)list.get(i)).getOrdernum());
            this.updateSelective(item1);
            ExamPaperTplItem item2 = new ExamPaperTplItem(((ExamPaperTplItem)list.get(i)).getItemId());
            item2.setOrdernum(((ExamPaperTplItem)list.get(i - 1)).getOrdernum());
            this.updateSelective(item2);
            break;
        }
    }

    @Override
    public int countQuestions(ExamPaperTplBlock block) throws Exception {
        block.setIsMutex(false);
        return this.examPaperTplItemDao.countQuestions(block);
    }
}

