/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.exampapertpl.service.imple;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampapertpl.dao.IExamPaperTplDao;
import com.peak.app.exampro.exampapertpl.model.AbstractExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTpl;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplBlock;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByDiffi;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByKnowDiffi;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplByType;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQBank;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplQType;
import com.peak.app.exampro.exampapertpl.model.ExamPaperTplSection;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByDiffiService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByKnowDiffiService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplByTypeService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplItemService;
import com.peak.app.exampro.exampapertpl.service.IExamPaperTplService;
import com.peak.app.exampro.exampapertpl.vo.ExamPaperTplQuery;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExamPaperTplService
extends BaseService<ExamPaperTpl, Long, ExamPaperTplQuery>
implements IExamPaperTplService {
    private IExamPaperTplItemService examPaperTplItemService;
    private IExamPaperTplDao examPaperTplDao;
    private IExamPaperTplByTypeService examPaperTplByTypeService;
    private IExamPaperTplByDiffiService examPaperTplByDiffiService;
    private IExamPaperTplByKnowDiffiService examPaperTplByKnowDiffiService;

    public void setExamPaperTplItemService(IExamPaperTplItemService examPaperTplItemService) {
        this.examPaperTplItemService = examPaperTplItemService;
    }

    public void setExamPaperTplDao(IExamPaperTplDao dao) {
        this.examPaperTplDao = dao;
    }

    public IExamPaperTplDao getExamPaperTplDao() {
        return this.examPaperTplDao;
    }

    public IEntityDao<ExamPaperTpl, Long, ExamPaperTplQuery> getEntityDao() {
        return this.examPaperTplDao;
    }

    @Override
    public ExamPaperTpl fetchQuestions(ExamPaperTpl tpl, boolean isCount, boolean isFetch) throws Exception {
        if (tpl == null) {
            return null;
        }
        if (tpl instanceof AbstractExamPaperTpl) {
            List<ExamPaperTplQBank> qbanks = ((AbstractExamPaperTpl)tpl).getQbanks();
            List<ExamPaperTplQType> qtypes = ((AbstractExamPaperTpl)tpl).getQtypes();
            if (qbanks == null || qbanks.isEmpty() || qtypes == null || qtypes.isEmpty()) {
                return tpl;
            }
            ((AbstractExamPaperTpl)tpl).buildBlocks();
        }
        List<? extends ExamPaperTplSection> sections = tpl.getSections();
        for (int i = 0; sections != null && i < sections.size(); ++i) {
            List<ExamPaperTplBlock> sectionBlocks = sections.get(i).getBlocks();
            for (int j = 0; sectionBlocks != null && j < sectionBlocks.size(); ++j) {
                ExamPaperTplBlock block = sectionBlocks.get(j);
                if (block.getQtypeId() == null || block.getQtypeId() == 0L) {
                    block.setQtypeId(sections.get(i).getQtypeId());
                }
                if (isFetch) {
                    // empty if block
                }
                if (!isCount) continue;
                int maxQuestionnum = this.examPaperTplItemService.countQuestions(block);
                block.setMaxQuestionnum(maxQuestionnum);
            }
        }
        return tpl;
    }

    @Override
    public List<ExamQuestion> findAllMustQuestions(Long paperId) {
        return this.examPaperTplDao.findAllMustQuestions(paperId);
    }

    @Override
    public ExamPaperTpl loadById(Long templateId) {
        ExamPaperTpl examPaperTemplate = (ExamPaperTpl)this.getById(templateId);
        if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 2) {
            examPaperTemplate = this.examPaperTplByTypeService.loadById(templateId);
            ((ExamPaperTplByType)examPaperTemplate).buildBlocks();
        } else if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 3) {
            examPaperTemplate = this.examPaperTplByDiffiService.loadById(templateId);
            ((ExamPaperTplByDiffi)examPaperTemplate).buildBlocks();
        } else if (examPaperTemplate.getPaperMethod() != null && examPaperTemplate.getPaperMethod() == 4) {
            examPaperTemplate = this.examPaperTplByKnowDiffiService.loadById(templateId);
            ((ExamPaperTplByKnowDiffi)examPaperTemplate).buildBlocks();
        }
        return examPaperTemplate;
    }

    public void setExamPaperTplByTypeService(IExamPaperTplByTypeService examPaperTplByTypeService) {
        this.examPaperTplByTypeService = examPaperTplByTypeService;
    }

    public void setExamPaperTplByDiffiService(IExamPaperTplByDiffiService examPaperTplByDiffiService) {
        this.examPaperTplByDiffiService = examPaperTplByDiffiService;
    }

    public void setExamPaperTplByKnowDiffiService(IExamPaperTplByKnowDiffiService examPaperTplByKnowDiffiService) {
        this.examPaperTplByKnowDiffiService = examPaperTplByKnowDiffiService;
    }
}

